#!/bin/sh

# Build script template [20060728]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=uim
ORIGVER=1.2.1
PKGVER=P2
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER.tgz
SRCPKG=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

SRCURL1=http://uim.freedesktop.org/releases/uim-1.2.1.tar.bz2
SRCDIR1=uim-$ORIGVER
PATCH11=patches/uim-1.2.1-site-init.patch
PATCH12=patches/uim-1.2.1-egg-compat.patch
PATCH13=patches/uim-1.2.1-toolbar-compact.patch
PATCH14=patches/uim-1.2.1-toolbar-applet-menu.patch
PATCH15=patches/uim-1.2.1-input-pad.patch

SRC2=patches/site-init.scm
SRC3=patches/default.scm
SRC4=patches/README.plamo

INITSCRIPTS=patches/modules-update.sh

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot

if [ ! -d $SRCROOT/download ]; then
    mkdir -p $SRCROOT/download
fi
for u in ${!SRCURL*}; do
    f=SRC${u#SRCURL}
    if [ -z "${!f}" ]; then
	declare $f=download/${!u##*/}
    fi
    if [ ! -f ${!f} ]; then
	wget -O ${!f} ${!u}
    fi
done

if [ -d $BUILDROOT ]; then
    rm -rf $BUILDROOT
fi
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar jxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
cat $SRCROOT/$PATCH12 | patch -sp1
cat $SRCROOT/$PATCH13 | patch -sp1
cat $SRCROOT/$PATCH14 | patch -sp1
cat $SRCROOT/$PATCH15 | patch -sp1
PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig ./configure --prefix=$PREFIX --with-canna --without-eb --enable-dict || exit 1
#PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig ./configure --prefix=$PREFIX --without-eb --enable-dict || exit 1
make || exit 1
make -C po update-po || exit 1
make install DESTDIR=$PKGROOT || exit 1

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp AUTHORS COPYING ChangeLog* INSTALL NEWS README $PKGROOT$DOCPREFIX/$SRCDIR1
cp -R doc $PKGROOT$DOCPREFIX/$SRCDIR1
rm -f $PKGROOT$DOCPREFIX/$SRCDIR1/doc/Makefile*
gzip $PKGROOT$DOCPREFIX/$SRCDIR1/doc/*

cp -f $SRCROOT/$SRC2 $SRCROOT/$SRC3 $PKGROOT$PREFIX/share/uim
cp -f $SRCROOT/$SRC4 $PKGROOT$DOCPREFIX/$SRCDIR1

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

cd $PKGROOT$DOCPREFIX/$SRCDIR1
tar zcf $SRCPKG $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
