# -*- coding: ascii -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2003, 2004 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: config.py,v 1.11 2004/04/13 05:21:59 shy Exp $
#

import string
import UserDict
import codecs

builtin_open = open

class Config(UserDict.UserDict):
    def __init__(self):
        UserDict.UserDict.__init__(self)
        self.itemlist = []
    def __setitem__(self, key, value):
        UserDict.UserDict.__setitem__(self, key, value)
        self.itemlist.append((key, value))
    def get(self, name, default=None):
        if type(name) == type([]):
            keylist = name
        else:
            keylist = [name]
        for key in keylist:
            if self.data.has_key(key):
                return self.data[key]
        return default
    def getint(self, name, default=None):
        value = self.get(name)
        if value:
            try:
                return int(value)
            except ValueError:
                pass
        return default
    def getfloat(self, name, default=None):
        value = self.get(name)
        if value:
            try:
                return float(value)
            except ValueError:
                pass
        return default
    def adjust(self, name, base, default=None):
        value = self.get(name)
        if value:
            try:
                if value[:2] == "--":
                    return int(value[1:])
                value = int(value)
            except (TypeError, ValueError):
                value = default
        if value is not None and value < 0:
            value = base + value
        return value
    def __str__(self):
        buffer = []
        for item in self.data.items():
            buffer.append('%s,%s\n' % item)
        return string.join(buffer, '')

def open(path):
    file = builtin_open(path)
    buffer = []
    for line in file:
        if not line.strip():
            continue
        buffer.append(line)
    return new_config(buffer)

def new_config(buffer):
    dict = Config()
    charset = 'Shift_JIS' # default
    for line in buffer:
        try:
            key, value = line.split(',', 1)
        except ValueError:
            continue
        if key.strip() == 'charset':
            try:
                codecs.lookup(charset)
            except:
                print "Unsupported charset %s" % value.strip()
            else:
                charset = value.strip()
        elif key.strip() in ['refreshundeletemask', 'icon', 'cursor',
                             'shiori', 'makoto']:
            dict[key.strip()] = value.strip()
        else:
            dict[key.strip()] = unicode(value, charset, 'replace').strip()
    return dict

def null_config():
    return Config()
