#!/bin/sh

build_pkg() {

SWNAME=$1
C_FLAGS=$2

ARCH=i386
PVER=P1
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc
INFODIR=/usr/share/info

rm -rf $SWNAME
tar zxf $SWNAME.tar.gz
cd $SWNAME 

CFLAGS="$C_FLAGS" ./configure --prefix=/usr --mandir=$MANDIR --infodir=$INFODIR
make 
mkdir pkg
make install DESTDIR=`pwd`/pkg
mkdir -p pkg${DOCDIR}/$SWNAME
gzip pkg${INFODIR}/*.info
gzip pkg${INFODIR}/*.info-*
cp -pR ../PlamoBuild-ndtpd.sh A* C* I* N* R* U* pkg${DOCDIR}/$SWNAME
chown -R root:root pkg${DOCDIR}/$SWNAME
cd pkg
/sbin/makepkg ${SWNAME}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
mkdir -p install
cat >> install/doinst.sh <<EOF
#%% begin initialize $SWNAME
INST_INFO=/usr/bin/install-info
if [ -x usr/sbin/install-info ] ; then
 INST_INFO=/usr/sbin/install-info
fi
\$INST_INFO --info-dir=${INFODIR} ${INFODIR}/ndtpd.info.gz
\$INST_INFO --info-dir=${INFODIR} ${INFODIR}/ndtpd-ja.info.gz
#%% end
EOF
rm .${INFODIR}/dir
tar zcf ${SWNAME}-${ARCH}-${PVER}.tgz usr install

mkdir -p ../../pkg
mv ${SWNAME}-${ARCH}-${PVER}.tgz ../../pkg/.

cd ..
cd ..

}

build_pkg "ndtpd-3.1.5" "-O2 -DPROTOTYPES"

