<?php


class Cmd_rename
{
	static function getinstance()
	{
		return new Cmd_rename;
	}
	
	
	function run()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['page']) || $get['page'] == ''){
			return $this->error('パラメータが足りません。');
		}
		
		$post = KinoWiki::getinstance()->getPOST();
		if(isset($post['newname'])){
			$ret = $this->rename();
		}
		else{
			$ret = $this->showform();
		}
		$ret['pagename'] = $get['page'];
		return $ret;
	}
	
	
	protected function showform($newname = null)
	{
		$get = KinoWiki::getinstance()->getGET();
		$smarty = new CMDSmarty('rename');
		$smarty->assign('pagename', $get['page']);
		if($newname != null){
			$smarty->assign('newname', $newname);
		}
		$ret['body'] = $smarty->fetch('rename.tpl.htm');
		$ret['title'] = 'ページ名の変更';
		return $ret;
	}
	
	
	protected function rename()
	{
		$get = KinoWiki::getinstance()->getGET();
		$post = KinoWiki::getinstance()->getPOST();
		
		if(!isset($post['password']) || md5($post['password']) != ADMINPASS){
			return $this->showform($post['newname']);
		}
		
		$smarty = new CMDSmarty('rename');
		$smarty->assign('pagename', $get['page']);
		$smarty->assign('newname', $post['newname']);
		$ret['title'] = 'ページ名の変更';
		
		if(Wiki::getinstance()->rename($get['page'], $post['newname'])){
			$ret['body'] = $smarty->fetch('success.tpl.htm');
		}
		else{
			$ret['body'] = $smarty->fetch('failed.tpl.htm');
		}
		return $ret;
	}
	
	
	protected function error($mes)
	{
		$ret['title'] = 'error';
		$ret['body'] = '<p class="error">' . $mes . '</p>';
		return $ret;
	}
}

?>