<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="es" xml:lang="es"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Secciones de configuracin - Servidor HTTP Apache</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Mdulos</a> | <a href="./mod/directives.html">Directivas</a> | <a href="./faq/">Preguntas Frecuentes</a> | <a href="./glossary.html">Glosario</a> | <a href="./sitemap.html">Mapa de este sitio web</a></p>
<p class="apache">Versin 2.0 del Servidor HTTP Apache</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Servidor HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentacin</a> &gt; <a href="./">Versin 2.0</a></div><div id="page-content"><div id="preamble"><h1>Secciones de configuracin</h1>
<div class="toplang">
<p><span>Idiomas disponibles: </span><a href="./en/sections.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/sections.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./ja/sections.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/sections.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
 <p> Las directivas presentes en los <a href="configuring.html">ficheros de configuracin</a> pueden ser
de aplicacin para todo el servidor, o puede que su
aplicacin se limite solamente a determinados directorios,
ficheros, hosts, o URLs. Este documento explica cmo usar las
secciones de configuracin y los ficheros <code>.htaccess</code>
para modificar el mbito de aplicacin de las directivas de
configuracin.</p> </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#types">Tipos de secciones de
configuracin</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#file-and-web">Sistemas de ficheros y espacio
web</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#virtualhost">Hosts virtuales</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#proxy">Proxy</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#whatwhere">Qu directivas se pueden
usar?</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#mergin">Cmo se fusionan las distintas
secciones?</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="types" id="types">Tipos de secciones de
configuracin</a></h2>

<table class="related"><tr><th>Mdulos Relacionados</th><th>Directivas Relacionadas</th></tr><tr><td><ul><li><code class="module"><a href="./mod/core.html">core</a></code></li><li><code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxymatch">&lt;ProxyMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code></li></ul></td></tr></table>

<p>Exiten dos tipos bsicos de secciones de
configuracin. Por un lado, la mayora de las secciones de
configuracin se evalan para cada peticin que se
recibe y se aplican las directivas que se incluyen en las distintas
secciones solamente a las peticiones que se adecan a
determinadas caractersticas. Por otro lado, las secciones de tipo
<code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code> e
<code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code>, se
evalan solamente al inicio o reinicio del servidor. Si al
iniciar el servidor las condiciones son las adecuadas, las directivas
que incluyen estas secciones se aplicarn a todas las peticiones
que se reciban. Es caso contrario, esas directivas que incluyen se
ignoran completamente.</p>

<p>Las secciones <code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code> incluyen directivas que se
aplicarn solamente si se pasa un determinado parmetro por
lnea de comandos al ejecutar <code class="program"><a href="./programs/httpd.html">httpd</a></code>.  Por
ejemplo, con la siguiente configuracin, todas las peticiones
sern redireccionadas a otro sitio web solamente si el servidor
se inici usando <code>httpd -DClosedForNow</code>:</p>

<div class="example"><p><code>
&lt;IfDefine ClosedForNow&gt;<br />
Redirect / http://otherserver.example.com/<br />
&lt;/IfDefine&gt;
</code></p></div>

<p>La seccin <code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code> es muy parecida. La diferencia
respecto a <code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code> est en que incluye directivas
que se aplicarn solamente si un determinado mdulo en
particular est disponible en el servidor. El mdulo debe
estar compilado estticamente en el servidor, o si est
compilado de forma dinmica ha de ponerse antes una lnea
<code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> en el fichero de
configuracin. Esta directiva debe usarla solamente si necesita
que su fichero de configuracin funcione estn o no
instalados determinados mdulos. No debe usarla para incluir
directivas que quiera que se apliquen siempre, porque puede suprimir
mensajes de error que pueden ser de mucha utilidad para detectar la
falta de algn mdulo.</p>

<p>En el siguiente ejemplo, la directiva <code class="directive"><a href="./mod/mod_mime_magic.html#mimemagicfiles">MimeMagicFiles</a></code> se aplicar
solamente si el mdulo <code class="module"><a href="./mod/mod_mime_magic.html">mod_mime_magic</a></code> est
disponible.</p>

<div class="example"><p><code>
&lt;IfModule mod_mime_magic.c&gt;<br />
MimeMagicFile conf/magic<br />
&lt;/IfModule&gt;
</code></p></div>

<p>Tanto <code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code>
como <code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code>
pueder usarse con condiones negativas anteponiendo al test el
carcter "!".  Estas secciones tambin pueden anidarse para
establecer restricciones ms complejas.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="file-and-web" id="file-and-web">Sistemas de ficheros y espacio
web</a></h2>

<p>Las secciones de configuracin usadas con ms frecuencia
son las que cambian la configuracin de reas del sistema de
ficheros o del espacio web. En primer lugar, es importante comprender
la diferencia que existe entre estos dos conceptos. El sistema de
ficheros es la visin de sus discos desde el punto de vista del
sistema operativo. Por ejemplo, en una instalacin estndar,
Apache estar en <code>/usr/local/apache2</code> en un sistema
Unix o en <code>"c:/Program Files/Apache Group/Apache2"</code> en un
sistema Windows.  (Tenga en cuenta que con Apache debe usar siempre
barras /, incluso en Windows.)  Por el contrario, el espacio web lo
que presenta el servidor web y que visualiza el cliente. De manera que
la ruta <code>/dir/</code> en el espacio web se corresponde con la
ruta <code>/usr/local/apache2/htdocs/dir/</code> en el sistema de
ficheros de una instalacin estndar en Unix.  El espacio
web no tiene que tener correspondencia directa con el sistema de
ficheros, porque las pginas web pueden generarse de forma
dinmica a partir de bases de datos o partiendo de otras
ubicaciones.</p>

<h3><a name="filesystem" id="filesystem">Secciones relacionadas con el sistema
de ficheros</a></h3>

<p>Las secciones <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> y <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>, junto con sus contrapartes que usan
expresiones regulares, aplican sus directivas a reas del sistema de
ficheros. Las directivas incluidas en una seccin <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> se aplican al
directorio del sistema de ficheros especificado y a sus
subdirectorios. El mismo resultado puede obtenerse usando <a href="howto/htaccess.html">ficheros .htaccess</a>.  Por ejemplo, en la
siguiente configuracin, se activarn los ndices de
directorio para el directorio <code>/var/web/dir1</code> y sus
subdirectorios.</p>

<div class="example"><p><code>
&lt;Directory /var/web/dir1&gt;<br />
Options +Indexes<br />
&lt;/Directory&gt;
</code></p></div>

<p>Las directivas incluidas en una seccin <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> se aplicarn a
cualquier fichero cuyo nombre se especifique, sin tener en cuenta en
que directorio se encuentra. Por ejemplo, las siguientes directivas de
configuracin, cuando se colocan en la seccin principal del
fichero de configuracin, deniegan el acceso a cualquier fichero
llamado <code>private.html</code> sin tener en cuenta de donde se
encuentre.</p>

<div class="example"><p><code>
&lt;Files private.html&gt;<br />
Order allow,deny<br />
Deny from all<br />
&lt;/Files&gt;
</code></p></div>

<p>Para referirse a archivos que se encuentren en un determinado lugar
del sistema de ficheros, se pueden combinar las secciones <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> y <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>. Por ejemplo, la
siguiente configuracin denegar el acceso a
<code>/var/web/dir1/private.html</code>,
<code>/var/web/dir1/subdir2/private.html</code>,
<code>/var/web/dir1/subdir3/private.html</code>, y cualquier otra
aparicin de <code>private.html</code> que se encuentre en
<code>/var/web/dir1/</code> o cualquiera de sus subdirectorios.</p>

<div class="example"><p><code>
&lt;Directory /var/web/dir1&gt;<br />
&lt;Files private.html&gt;<br />
Order allow,deny<br />
Deny from all<br />
&lt;/Files&gt;<br />
&lt;/Directory&gt;
</code></p></div>


<h3><a name="webspace" id="webspace">Secciones relacionadas con el espacio
web</a></h3>

<p>La seccin <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> y su contraparte que usa
 expresiones regulares, cambian
 la configuracin para el contenido del espacio web. Por ejemplo,
 la siguiente configuracin evita que se acceda a cualquier URL
 que empiece por /private.  En concreto, se aplicar a
 peticiones que vayan dirigidas a
 <code>http://yoursite.example.com/private</code>,
 <code>http://yoursite.example.com/private123</code>, y a
 <code>http://yoursite.example.com/private/dir/file.html</code>
 as como
 tambin a cualquier otra peticin que comience por
 <code>/private</code>.</p>

<div class="example"><p><code>
&lt;Location /private&gt;<br />
Order Allow,Deny<br />
Deny from all<br />
&lt;/Location&gt;
</code></p></div>

<p>La seccin <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> puede no tener nada que ver con el
sistema de ficheros. Por ejemplo, el siguiente ejemplo muestra como
asociar una determinada URL a un handler interno de Apache del
mdulo <code class="module"><a href="./mod/mod_status.html">mod_status</a></code>.  No tiene por qu
existir ningn fichero <code>server-status</code> en el sistema
de ficheros.</p>

<div class="example"><p><code>
&lt;Location /server-status&gt;<br />
SetHandler server-status<br />
&lt;/Location&gt;
</code></p></div>


<h3><a name="wildcards" id="wildcards">Caracteres comodn y expresiones
regulares</a></h3>

<p>Las secciones <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>, y <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> pueden usar caracteres comodn
del tipo <code>fnmatch</code> de la librera estndar de C.
El carcter "*" equivale a cualquier secuencia de caracteres, "?"
equivale a cualquier carcter individual, y "[<em>seq</em>]"
equivale a cualquier carcter en <em>seq</em>.  Ningn
carcter comodn equivale a"/", que debe siempre
especificarse explcitamente.</p>

<p>Si necesita un sistema de equivalencias ms flexible, cada
seccin tiene una contraparte que acepta <a href="glossary.html#regex">expresiones regulares</a> compatibles con
Perl: <code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code>, <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>, y <code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>. Consulte la seccin
sobre la fusin de secciones de configuracin para ver la
forma en que las secciones expresiones regulares cambian el modo en
que se aplican las directivas.</p>

<p>Abajo se muestra un ejemplo en el que una seccin de
configuracin que usa caracteres comodn en lugar de una
expresin regular modifica la configuracin de todos los
directorios de usuario:</p>

<div class="example"><p><code>
&lt;Directory /home/*/public_html&gt;<br />
Options Indexes<br />
&lt;/Directory&gt;
</code></p></div>

<p>Usando expresiones regulares, podemos denegar el acceso a muchos
tipos ficheros de imgenes de una sola vez:</p>

<div class="example"><p><code>
&lt;FilesMatch \.(?i:gif|jpe?g|png)$&gt;<br /> 
Order allow,deny<br />
Deny from all<br /> 
&lt;/FilesMatch&gt; 
</code></p></div>



<h3><a name="whichwhen" id="whichwhen">Qu usar en cada momento</a></h3>

<p>Decidir cuando hay que usar secciones que se apliquen sobre el
sistema de ficheros y cuando usar secciones que se apliquen sobre el
espacio web es bastante fcil. Cuando se trata de directivas que
se aplican a objetos que residen en el sistema de ficheros, siempre se
deben usar <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> o <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>.  Cuando se trata de directivas que se
aplican a objetos que no residen en el sistema de ficheros (por
ejemplo una pgina web generada a partir de una base de datos),
se usa <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>.</p>

<p>Es importante no usar nunca <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> cuando se trata de restringir el
acceso a objetos en el sistema de ficheros. Esto se debe a que varias
URLs diferentes pueden corresponderse con una misma ubicacin en
el sistema de ficheros, haciendo que la restriccin pueda ser
evitada. Por ejemplo, considere la siguiente configuracin:</p>

<div class="example"><p><code>
&lt;Location /dir/&gt;<br />
Order allow,deny<br />
Deny from all<br />
&lt;/Location&gt;
</code></p></div>

<p>La restriccin funciona si se produce una peticin a
<code>http://yoursite.example.com/dir/</code>.  Pero, qu
ocurrira si se trata de un sistema de ficheros que no distingue
maysculas de minsculas? Entonces, la restriccin que
ha establecido podra evitarse fcilmente haciendo una
peticion a <code>http://yoursite.example.com/DIR/</code>.  Una
seccin <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> por el contrario, se aplicar
a cualquier contenido servido desde esa ubicacin,
independientemente de cmo se llame. (Una excepcin son los
enlaces del sistema de ficheros. El mismo directorio puede ser
colocado en ms de una ubicacin del sistema de ficheros
usando enlaces simblicos.  La seccin <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> seguir los
enlaces simblicos sin resetear la ruta de fichero (resetting the
pathname). Por tanto, para conseguir el mayor nivel de seguridad, los
enlaces simblicos deben desactivarse con la directiva <code class="directive"><a href="./mod/core.html#options">Options</a></code> correspondiente.)</p>

<p>En el caso de que piense que nada de esto le afecta porque usa un
sistema de ficheros que distingue maysculas de minsculas,
recuerde que hay muchas otras maneras de hacer corresponder
mltiples direcciones del espacio web con una misma
ubicacin del sistema de ficheros. Por tanto, use las secciones
de configuracin que se aplican al sistema de ficheros siempre
que sea posible.  Hay, sin embargo, una excepcin a esta
regla. Poner restricciones de configuracin en una seccin
<code>&lt;Location /&gt;</code> es completamente seguro porque estas
secciones se aplicarn a todas las peticiones independientemente
de la URL especfica que se solicite.</p> 

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="virtualhost" id="virtualhost">Hosts virtuales</a></h2>

<p>El contenedor <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> agrupa directivas que se
aplicarn a hosts especficos. Esto es til cuando se
sirven varios hosts con una misma mquina y con una
configuracin diferente cada uno. Para ms informacin,
consulte la <a href="vhosts/">documentacin sobre hosts
virtuales</a>.</p> </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy" id="proxy">Proxy</a></h2>

<p>Las secciones <code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code> y <code class="directive"><a href="./mod/mod_proxy.html#proxymatch">&lt;ProxyMatch&gt;</a></code> aplican las directivas de
configuracin que engloban solo a los sitios accedidos a
travs del servidor proxy del mdulo
<code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code> que tengan equivalencia con la URL
especificada. Por ejemplo, la siguiente configuracin
evitar que se use el servidor proxy para acceder al sitio web
<code>cnn.com</code>.</p>

<div class="example"><p><code>
&lt;Proxy http://cnn.com/*&gt;<br />
Order allow,deny<br />
Deny from all<br />
&lt;/Proxy&gt;
</code></p></div>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="whatwhere" id="whatwhere">Qu directivas se pueden
usar?</a></h2>

<p>Para ver que directivas son las que se pueden usar en cada
seccin de configuracin, consulte el <a href="mod/directive-dict.html#Context">Context</a> de la directiva.
Todas las directivas que est permitido usar en las secciones
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> se
pueden usar tambin en las secciones <code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code>, <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>, <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>, <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>, <code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>, <code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code>, y <code class="directive"><a href="./mod/mod_proxy.html#proxymatch">&lt;ProxyMatch&gt;</a></code>. Sin embargo, hay algunas
excepciones:</p>

<ul> <li>La directiva <code class="directive"><a href="./mod/core.html#allowoverride">AllowOverride</a></code> funciona en las secciones
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>.</li>

<li>Las directivas <code class="directive"><a href="./mod/core.html#options">Options</a></code>
<code>FollowSymLinks</code> y <code>SymLinksIfOwnerMatch</code>
<code class="directive"><a href="./mod/core.html#options">Options</a></code> funcionan solo en las
secciones <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> y en los ficheros
<code>.htaccess</code>.</li>

<li>La direcitva <code class="directive"><a href="./mod/core.html#options">Options</a></code> no puede
ser usada en secciones <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> y <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>.</li>
</ul>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="mergin" id="mergin">Cmo se fusionan las distintas
secciones?</a></h2>

<p>Las secciones de configuracin se aplican en un determinado
orden. Como este orden puede tener efectos significativos en como se
interpretan las directivas de configuracin, es importante
entender cmo funciona este proceso.</p>

    <p>El orden de fusin es el siguiente:</p>

    <ol>
      <li> <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> (excepto expresiones
      regulares) y <code>.htaccess</code> simultneamente (si el
      uso de <code>.htaccess</code> est permitido, prevaleciendo
      sobre <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>)</li>

      <li><code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code>
      (y <code>&lt;Directory ~&gt;</code>)</li>

      <li><code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> y
      <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>
      simultneamente</li>

      <li><code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>
      y <code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>
      simultneamente</li>
    </ol>

    <p>Aparte de <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, cada grupo se procesa en el
    orden en que aparezca en los ficheros de configuracin.
    <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>
    (grupo 1 arriba) se procesa empezando por los componentes de la
    ruta al directorio ms cortos. Por ejemplo,
    <code>&lt;Directory
    /var/web/dir&gt;</code> se procesar antes de
    <code>&lt;Directory /var/web/dir/subdir&gt;</code>. Si hay que
    aplicar varias secciones <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> a un mismo directorio, se
    aplican en el orden en que aparezcan en el fichero de
    configuracin. Las configuraciones incluidas mediante la
    directiva <code class="directive"><a href="./mod/core.html#include">Include</a></code> se
    tratarn como si estuvieran dentro del fichero de
    configuracin principal en lugar de la seccin
    <code class="directive"><a href="./mod/core.html#include">Include</a></code>.</p>

    <p>Las secciones incluidas dentro de secciones <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> se aplican
    <em>despus de</em> las correspondientes secciones fuera
    de la definicin del host virtual. Esto permite que la
    configuracin especificada para los hosts virtuales pueda
    prevalecer sobre la configuracin del servidor principal.</p>

    <p>Las secciones que aparecen despus prevalecen sobre las
    que aparecen antes.</p>

<div class="note"><h3>Nota tcnica.</h3> Previamente a la fase de
      traduccin de nombres (en la que se analizan los
      <code>Aliases</code> y <code>DocumentRoots</code> para calcular
      las correspondencias entre URLs y nombres de ficheros) se
      ejecuta una secuencia
      <code>&lt;Location&gt;</code>/<code>&lt;LocationMatch&gt;</code>. Los
      resultados de esta secuencia se desechan despus de 
      ejecutar la traduccin.  </div>

<h3><a name="merge-examples" id="merge-examples">Algunos ejemplos</a></h3>

<p>Abajo se muestra un ejemplo para que se vea claramente cul es
el orden de fusin. Asumiendo que todas las secciones se aplican
a la peticin, las de este ejemplo se aplicaran en el orden
A &gt; B &gt; C &gt; D &gt; E.</p>

<div class="example"><p><code>
&lt;Location /&gt;<br />
E<br />
&lt;/Location&gt;<br />
<br />
&lt;Files f.html&gt;<br />
D<br />
&lt;/Files&gt;<br />
<br />
&lt;VirtualHost *&gt;<br />
&lt;Directory /a/b&gt;<br />
B<br />
&lt;/Directory&gt;<br />
&lt;/VirtualHost&gt;<br />
<br />
&lt;DirectoryMatch "^.*b$"&gt;<br />
C<br />
&lt;/DirectoryMatch&gt;<br />
<br />
&lt;Directory /a/b&gt;<br />
A<br />
&lt;/Directory&gt;<br />
<br />
</code></p></div>

<p>A continuacin se muestra un ejemplo ms concreto.
Independientemente de las restricciones de acceso que se hayan
establecido en las secciones <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, la seccin <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> ser evaluada
al final y se permitir acceso sin restricciones al servidor.  En
otras palabras, el orden de fusin es importante, de modo que
ponga atencin.</p>

<div class="example"><p><code>
&lt;Location /&gt;<br /> Order deny,allow<br /> Allow from all<br />
&lt;/Location&gt;<br /> <br /> 
# Esta seccin &lt;Directory&gt; no tendr efecto<br /> 
&lt;Directory /&gt;<br /> 
Order allow,deny<br /> 
Allow from all<br /> 
Deny from badguy.example.com<br /> 
&lt;/Directory&gt;
</code></p></div>



</div></div>
<div class="bottomlang">
<p><span>Idiomas disponibles: </span><a href="./en/sections.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/sections.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./ja/sections.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/sections.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2006 The Apache Software Foundation.<br />Licencia bajo los trminos de la <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Mdulos</a> | <a href="./mod/directives.html">Directivas</a> | <a href="./faq/">Preguntas Frecuentes</a> | <a href="./glossary.html">Glosario</a> | <a href="./sitemap.html">Mapa de este sitio web</a></p></div>
</body></html>