//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVDBDATASOURCE_H
#define WSCVDBDATASOURCE_H

#include <WScom.h>
#include <WSCvdb.h>
#include <WSDimage.h>
#define WSCvdbDataSource_VER  1000
#include <WSDprivateTimer.h>

class WSCvdbDataSource   :public WSCvdb{
  protected:
//    char* _db_inst_name;
    char* _table_name;
    char* _item;
    char* _show_item;
    char* _sort_items;
    char* _filter;
    char* _value;
    char* _sort;

    WSClistData _show_item_list;
    WSClistData _item_list;
    WSClistData _sort_item_list;
    WSClistData _sort_list;
    WSClistData _value_list;

//    WSMFpropertyDef(WSNdataBaseInstance,  char*,      _db_inst_name);
    WSMFpropertyDef(WSNdbTableName, char*,      _table_name);
    WSMFpropertyDef(WSNitem,      char*,      _item);
    WSMFpropertyDef(WSNshowItem,       char*,      _show_item);
    WSMFpropertyDef(WSNsortItems,      char*,      _sort_items);
    WSMFpropertyDef(WSNsort,           char*,       _sort);
    WSMFpropertyDef(WSNfilter,       char*,         _filter);
    WSMFpropertyDef(WSNvalue,       char*,         _value);

  public:

    WSCvdbDataSource(WSCbase* base, char* name);
    virtual ~WSCvdbDataSource();

    WSCbool isShow(char* name);

    virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    virtual long getDataSourceType();
    virtual char* getDataSourcePropertyName();
    virtual char* getDefaultProperty();

    WSMFguiClassDef(WSCvdbDataSource,WSCvdb);
    WSMFversionDef(WSCvdbDataSource);
};

#endif //WSCVDBDATASOURCE_H
