//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCSTRING_H
#define WSCSTRING_H
#include <WScom.h>
#include <WSCvariant.h>
#include <WSClistData.h>

#define WS_ASCII 0
#define WS_KANJI 1
#define WS_GAIJI 2
#define WS_HKANA 3

class WSCstring {

  protected:  
    char* _str;
    long _encoding;
    WSClistData _tmp_list;
    WSClistData _tmp_encode;
    long _chars;
    long  _seek_pt;
    void _clear_list();
    void _add_string_to_list(char*,long);
    char* _get_string_from_list(long);
    char* _get_utf8_string(char*,long encode);
    char* _get_mb_string(char*,long encode);
    char* _convert_string(const char*,long from_encode,long to_encode);
    long _get_encoding() const;    

  public:
    WSCstring();
    WSCstring(const char*,long encode = WS_EN_DEFAULT);
    WSCstring(WSCstring&);
    WSCstring(const WSCstring&);
    WSCstring(WSCvariant&,long encode = WS_EN_DEFAULT);
    WSCstring(const WSCvariant&,long encode = WS_EN_DEFAULT);
    virtual ~WSCstring();

    void  setString(const char*,long encode = WS_EN_DEFAULT);
    char* getString(long encode = WS_EN_DEFAULT);

    long getChars();
    long getEncoding();
    long    isExist(const char*,long encode = WS_EN_DEFAULT );      //search None -> return -1 , Hit -> return pos

    void addString(const WSCstring&);
    void addString(const WSCvariant&,long encode = WS_EN_DEFAULT);
    void addString(const char*,long encode = WS_EN_DEFAULT);
    void cutString(WSCulong char_pos); // char_pos,0=clear,
    void insertString(WSCulong char_pos,WSCstring&);
    void deleteChar(WSCulong char_pos);             //begin 0, delete a char.
    void deleteChars(WSCulong char_pos,WSCulong len);   //begin 0, delete a char.
    void clear();
    void delLineFeed();
    void delString(const char*,long num);
    void delString(const char*,long num,long encode);
    void delHeadSpace();
    void delTailSpace();

    void to_upper();    
    void to_lower();    
    
    long replaceString(const char* srcchar,const char* destchar,long num,long encode = WS_EN_DEFAULT); 
    //num=0 means all of hit words..

    long getWords();
    long getWords(const char*,long encode = WS_EN_DEFAULT);
    long getWordCharPos(long wd); //return bytes. wd > -1
    long getWordCharPos(long wd,const char*,long encode = WS_EN_DEFAULT); //ws > -1
    WSCstring getWord(long wd); //wd > -1.
    WSCstring getWord(long num,const char*,long encode = WS_EN_DEFAULT); //ws > -1

    long _seek_next_line();//return getchar of skiped line

    long tell();
    long seek(long ); //charpos
    long seekEnd();
    long eof();
    long getLines();
    WSCstring gets();
    WSCstring& operator = (const WSCstring&);
    WSCstring& operator = (const char*);
    WSCstring& operator = (const WSCvariant&);
    operator char*();
    operator WSCvariant();
    WSCstring operator + (const WSCstring&);
    WSCstring operator + (const WSCvariant&);
    WSCstring operator + (const char*);
    WSCstring& operator += (const WSCstring&);
    WSCstring& operator += (const WSCvariant&);
    WSCstring& operator += (const char*);
    WSCstring& operator << (const WSCstring&);
    WSCstring& operator << (const WSCvariant&);
    WSCstring& operator << (const char*);
    WSCstring& operator << (WSCulong);
    WSCstring& operator << (long);
    WSCstring& operator << (int);
    WSCstring& operator << (WSCuint);
    WSCstring& operator << (double);
    WSCstring& operator << (float);
    long operator == (const WSCstring&);
};
#endif
