/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HONOKAHONOKATIMER_H
#define HONOKAHONOKATIMER_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define Uses_SCIM_UTILITY
#define Uses_SCIM_HELPER
#define Uses_SCIM_TRANS_COMMANDS

#include <scim.h>
#include <vector>
#include <map>

#define HONOKA_TIMER_UUID "050ba7c6-0fe2-4b37-a913-7903bc2c6215"
#define HONOKA_TIMER_INTERVAL 100000
#define HONOKA_TRANS_TIMER SCIM_TRANS_CMD_USER_DEFINED + 0
using namespace scim;
using namespace std;

namespace Honoka {

/**
@author TAM (Teppei Tamra)
*/
class HonokaTimer;
class HonokaTimer{
protected:
    HonokaTimer();

    ~HonokaTimer();
    void timer();
    void exec();
public:
    static HonokaTimer * self();
    static void destruct();
    uint32 decode(const Transaction &trans);
    vector<int> eventFilter(const Transaction &trans);
    int appendDelayEvent(uint32 delay);

protected:
    static HonokaTimer * _self;
    HelperAgent agent;
    int id;
    pid_t timer_pid;
    uint32 bef;
    int eventCount;
    multimap<uint32,int> events;
};

}


#endif
