#!/bin/sh
#
# rc.once.fontsonly:  X11 fonts intialization command.
#

/sbin/ldconfig 1> /dev/null 2>/dev/null

MKBOLD=/usr/bin/qmkbold
GZIP=/bin/gzip
PCF2BDF=/usr/bin/pcf2bdf
BDFTOPCF=/usr/bin/bdftopcf
CHOWN=/bin/chown
MKFONTDIR=/usr/bin/mkfontdir
MKFONTSCALE=/usr/bin/mkfontscale


make_bold() {
  if [ -f $IN ] ; then
    echo -n "$OUT"
    $GZIP -c -d $IN | $PCF2BDF | $MKBOLD $1 $2 | $BDFTOPCF | $GZIP > $OUT
    $CHOWN root.wheel $OUT
    echo -n " "
  fi
}

if [ -d /usr/share/fonts/Bitmap ] ; then
  if [ -x $MKBOLD -a -x $GZIP -a -x $PCF2BDF -a -x $BDFTOPCF ] ; then
    echo "Making some bold fonts in /usr/share/fonts/Bitmap directory. "
    echo "Please wait... "
    ( cd /usr/share/fonts/Bitmap
    IN=5x10a.pcf.gz     ; OUT=5x10b.pcf.gz      ; make_bold
    IN=shnm6x12a.pcf.gz ; OUT=shnm6x12ab.pcf.gz ; make_bold -r -L
    IN=shnm7x14a.pcf.gz ; OUT=shnm7x14ab.pcf.gz ; make_bold -r -L
    IN=shnm8x16a.pcf.gz ; OUT=shnm8x16ab.pcf.gz ; make_bold -r -L
    IN=9x18m.pcf.gz     ; OUT=9x18b.pcf.gz      ; make_bold -r -L
    IN=9x18gm.pcf.gz    ; OUT=9x18gb.pcf.gz     ; make_bold -r -L
    IN=10x20gm.pcf.gz   ; OUT=10x20gb.pcf.gz    ; make_bold -r -L
    IN=12x24.pcf.gz     ; OUT=12x24b.pcf.gz     ; make_bold -r -L
    IN=13x26.pcf.gz     ; OUT=13x26b.pcf.gz     ; make_bold -r -L
    echo
    IN=5x10rk.pcf.gz    ; OUT=5x10rkb.pcf.gz    ; make_bold
    IN=shnm6x12r.pcf.gz ; OUT=shnm6x12rb.pcf.gz ; make_bold -r -L
    IN=shnm7x14r.pcf.gz ; OUT=shnm7x14rb.pcf.gz ; make_bold -r -L
    IN=shnm8x16r.pcf.gz ; OUT=shnm8x16rb.pcf.gz ; make_bold -r -L
    IN=9x18rkm.pcf.gz   ; OUT=9x18rkb.pcf.gz    ; make_bold -r -L
    IN=9x18grkm.pcf.gz  ; OUT=9x18grkb.pcf.gz   ; make_bold -r -L
    IN=10x20grkm.pcf.gz ; OUT=10x20grkb.pcf.gz  ; make_bold -r -L
    IN=12x24rk.pcf.gz   ; OUT=12x24rkb.pcf.gz   ; make_bold -r -L
    IN=13x26rk.pcf.gz   ; OUT=13x26rkb.pcf.gz   ; make_bold -r -L
    IN=min_16x32r.pcf.gz ; OUT=min_16x32rb.pcf.gz ; make_bold -r -L
    echo
    IN=knj10.pcf.gz          ; OUT=knj10b.pcf.gz          ; make_bold
    IN=knj10min.pcf.gz       ; OUT=knj10minb.pcf.gz       ; make_bold
    IN=shnmk12.pcf.gz        ; OUT=shnmk12b.pcf.gz        ; make_bold -r -L
    IN=shnmk12min.pcf.gz     ; OUT=shnmk12minb.pcf.gz     ; make_bold -r -L
    IN=shnmleftk14.pcf.gz    ; OUT=shnmleftk14b.pcf.gz    ; make_bold -r -L
    IN=shnmleftk14min.pcf.gz ; OUT=shnmleftk14minb.pcf.gz ; make_bold -r -L
    IN=shnmleftk16.pcf.gz    ; OUT=shnmleftk16b.pcf.gz    ; make_bold -r -L
    IN=shnmleftk16min.pcf.gz ; OUT=shnmleftk16minb.pcf.gz ; make_bold -r -L
    IN=k18gm.pcf.gz          ; OUT=k18gb.pcf.gz           ; make_bold -r -L
    IN=k18m.pcf.gz           ; OUT=k18b.pcf.gz            ; make_bold -r -L
    IN=k20gm.pcf.gz          ; OUT=k20gb.pcf.gz           ; make_bold -r -L
    IN=jiskan24.pcf.gz       ; OUT=jiskan24b.pcf.gz       ; make_bold -r -L
    IN=kanji26.pcf.gz        ; OUT=kanji26b.pcf.gz        ; make_bold -r -L
    IN=min_k32.pcf.gz        ; OUT=min_k32b.pcf.gz        ; make_bold -r -L
    )
    echo
    echo "done. "
  fi
fi

if [ -x $MKFONTDIR ]; then
  if [ -d /usr/share/fonts/Bitmap ]; then
    echo -n "Initializing  Bitmap fonts directory.."
    $MKFONTDIR /usr/share/fonts/Bitmap
    # $MKFONTSCALE /usr/X11R7/lib/X11/fonts/Bitmap
  fi
#  if [ -d /usr/X11R7/lib/X11/fonts/TrueType ]; then
#    echo -n "Initializing  TrueType fonts directory.."
#     $MKFONTSCALE /usr/X11R7/lib/X11/fonts/TrueType
#    $MKFONTDIR /usr/X11R7/lib/X11/fonts/TrueType
#  fi
  if [ -d /usr/share/fonts/freefont ]; then
    echo -n "Initializing  freefont fonts directory.."
    $MKFONTSCALE /usr/share/fonts/freefont
    $MKFONTDIR /usr/share/fonts/freefont
  fi
  if [ -d /usr/share/fonts/ghostscript ]; then
    echo -n "Initializing  ghostscript fonts directory.."
    $MKFONTDIR /usr/share/fonts/ghostscript
    # $MKFONTSCALE /usr/X11R7/lib/X11/fonts/ghostscript
  fi
  echo "done. "
fi

#if [ -x /usr/bin/fc-cache ]; then
#  if [ -d /usr/X11R7/lib/X11/fonts/TrueType ]; then
#    echo -n "Creating fonts.cache in TrueType fonts directory.."
#    /usr/X11R7/bin/fc-cache /usr/X11R7/lib/X11/fonts/TrueType
#  fi
#  if [ -d /usr/X11R7/lib/X11/fonts/ghostscript ]; then    
#    echo -n "Creating fonts.cache in ghostscript fonts directory.."
#    /usr/X11R7/bin/fc-cache /usr/X11R7/lib/X11/fonts/ghostscript                       
#  fi
#  if [ -d /usr/X11R7/lib/X11/fonts/Type1 ]; then         
#    echo -n "Creating fonts.cache in Type1 fonts directory.."        
#    /usr/X11R7/bin/fc-cache /usr/X11R7/lib/X11/fonts/Type1        
#  fi
#  echo "done. "
#fi
#if [ -d /usr/X11R7/lib/X11/fonts/TrueType ]; then
#  if [ -d /usr/X11R7/lib/X11/fonts/TTF ]; then
#    ( cd /usr/X11R7/lib/X11/fonts/TTF/ ; 
#      for i in ../TrueType/*.ttf ; do 
#        if [ -f $i ] ; then
#          NAME=${i##*/}
#          if [ ! -f "$NAME" ]; then 
##           echo "ln -s $i ."
#            ln -s $i . 
#          fi
#        fi
#      done
#    )
#    ( cd /usr/X11R7/lib/X11/fonts/TTF/ ;
#      for i in ../TrueType/*.ttc ; do
#        if [ -f $i ] ; then
#          NAME=${i##*/}  
#          if [ ! -f "$NAME" ]; then
##           echo "ln -s $i ."
#            ln -s $i .
#          fi
#        fi
#      done
#    )
#  fi
#fi
#%% end
( cd usr/share/fonts/TrueType ; rm -rf fonts.alias )
( cd usr/share/fonts/TrueType ; ln -sf fonts.alias_plamo fonts.alias )
#%% begin initialize 
#!/bin/sh
#
# rc.once.fontsonly:  X11 fonts intialization command.
#

MKBOLD=/usr/bin/qmkbold
GZIP=/bin/gzip
PCF2BDF=/usr/bin/pcf2bdf
BDFTOPCF=/usr/bin/bdftopcf
CHOWN=/bin/chown
MKFONTDIR=/usr/bin/mkfontdir
MKFONTSCALE=/usr/bin/mkfontscale


make_bold() {
  if [ -f $IN ] ; then
    echo -n "$OUT"
    $GZIP -c -d $IN | $PCF2BDF | $MKBOLD $1 $2 | $BDFTOPCF | $GZIP > $OUT
    $CHOWN root.wheel $OUT
    echo -n " "
  fi
}

if [ -d /usr/share/fonts/Bitmap ] ; then
  if [ -x $MKBOLD -a -x $GZIP -a -x $PCF2BDF -a -x $BDFTOPCF ] ; then
    echo "Making some bold fonts in /usr/share/fonts/Bitmap directory. "
    echo "Please wait... "
    ( cd /usr/share/fonts/Bitmap
    IN=5x10a.pcf.gz     ; OUT=5x10b.pcf.gz      ; make_bold
    IN=shnm6x12a.pcf.gz ; OUT=shnm6x12ab.pcf.gz ; make_bold -r -L
    IN=shnm7x14a.pcf.gz ; OUT=shnm7x14ab.pcf.gz ; make_bold -r -L
    IN=shnm8x16a.pcf.gz ; OUT=shnm8x16ab.pcf.gz ; make_bold -r -L
    IN=9x18m.pcf.gz     ; OUT=9x18b.pcf.gz      ; make_bold -r -L
    IN=9x18gm.pcf.gz    ; OUT=9x18gb.pcf.gz     ; make_bold -r -L
    IN=10x20gm.pcf.gz   ; OUT=10x20gb.pcf.gz    ; make_bold -r -L
    IN=12x24.pcf.gz     ; OUT=12x24b.pcf.gz     ; make_bold -r -L
    IN=13x26.pcf.gz     ; OUT=13x26b.pcf.gz     ; make_bold -r -L
    echo
    IN=5x10rk.pcf.gz    ; OUT=5x10rkb.pcf.gz    ; make_bold
    IN=shnm6x12r.pcf.gz ; OUT=shnm6x12rb.pcf.gz ; make_bold -r -L
    IN=shnm7x14r.pcf.gz ; OUT=shnm7x14rb.pcf.gz ; make_bold -r -L
    IN=shnm8x16r.pcf.gz ; OUT=shnm8x16rb.pcf.gz ; make_bold -r -L
    IN=9x18rkm.pcf.gz   ; OUT=9x18rkb.pcf.gz    ; make_bold -r -L
    IN=9x18grkm.pcf.gz  ; OUT=9x18grkb.pcf.gz   ; make_bold -r -L
    IN=10x20grkm.pcf.gz ; OUT=10x20grkb.pcf.gz  ; make_bold -r -L
    IN=12x24rk.pcf.gz   ; OUT=12x24rkb.pcf.gz   ; make_bold -r -L
    IN=13x26rk.pcf.gz   ; OUT=13x26rkb.pcf.gz   ; make_bold -r -L
    IN=min_16x32r.pcf.gz ; OUT=min_16x32rb.pcf.gz ; make_bold -r -L
    echo
    IN=knj10.pcf.gz          ; OUT=knj10b.pcf.gz          ; make_bold
    IN=knj10min.pcf.gz       ; OUT=knj10minb.pcf.gz       ; make_bold
    IN=shnmk12.pcf.gz        ; OUT=shnmk12b.pcf.gz        ; make_bold -r -L
    IN=shnmk12min.pcf.gz     ; OUT=shnmk12minb.pcf.gz     ; make_bold -r -L
    IN=shnmleftk14.pcf.gz    ; OUT=shnmleftk14b.pcf.gz    ; make_bold -r -L
    IN=shnmleftk14min.pcf.gz ; OUT=shnmleftk14minb.pcf.gz ; make_bold -r -L
    IN=shnmleftk16.pcf.gz    ; OUT=shnmleftk16b.pcf.gz    ; make_bold -r -L
    IN=shnmleftk16min.pcf.gz ; OUT=shnmleftk16minb.pcf.gz ; make_bold -r -L
    IN=k18gm.pcf.gz          ; OUT=k18gb.pcf.gz           ; make_bold -r -L
    IN=k18m.pcf.gz           ; OUT=k18b.pcf.gz            ; make_bold -r -L
    IN=k20gm.pcf.gz          ; OUT=k20gb.pcf.gz           ; make_bold -r -L
    IN=jiskan24.pcf.gz       ; OUT=jiskan24b.pcf.gz       ; make_bold -r -L
    IN=kanji26.pcf.gz        ; OUT=kanji26b.pcf.gz        ; make_bold -r -L
    IN=min_k32.pcf.gz        ; OUT=min_k32b.pcf.gz        ; make_bold -r -L
    )
    echo
    echo "done. "
  fi
fi

if [ -x $MKFONTDIR ]; then
  if [ -d /usr/share/fonts/Bitmap ]; then
    echo -n "Initializing  Bitmap fonts directory.."
    $MKFONTDIR /usr/share/fonts/Bitmap
    # $MKFONTSCALE /usr/X11R7/lib/X11/fonts/Bitmap
  fi
#  if [ -d /usr/X11R7/lib/X11/fonts/TrueType ]; then
#    echo -n "Initializing  TrueType fonts directory.."
#     $MKFONTSCALE /usr/X11R7/lib/X11/fonts/TrueType
#    $MKFONTDIR /usr/X11R7/lib/X11/fonts/TrueType
#  fi
  if [ -d /usr/share/fonts/freefont ]; then
    echo -n "Initializing  freefont fonts directory.."
    $MKFONTSCALE /usr/share/fonts/freefont
    $MKFONTDIR /usr/share/fonts/freefont
  fi
  if [ -d /usr/share/ghostscript/fonts ]; then
    echo -n "Initializing  ghostscript fonts directory.."
    $MKFONTDIR /usr/share/ghostscript/fonts
    # $MKFONTSCALE /usr/X11R7/lib/X11/fonts/ghostscript
  fi
  echo "done. "
fi

if [ -x /usr/bin/fc-cache ]; then
    fc-cache
fi

#if [ -x /usr/bin/fc-cache ]; then
#  if [ -d /usr/X11R7/lib/X11/fonts/TrueType ]; then
#    echo -n "Creating fonts.cache in TrueType fonts directory.."
#    /usr/X11R7/bin/fc-cache /usr/X11R7/lib/X11/fonts/TrueType
#  fi
#  if [ -d /usr/X11R7/lib/X11/fonts/ghostscript ]; then    
#    echo -n "Creating fonts.cache in ghostscript fonts directory.."
#    /usr/X11R7/bin/fc-cache /usr/X11R7/lib/X11/fonts/ghostscript                       
#  fi
#  if [ -d /usr/X11R7/lib/X11/fonts/Type1 ]; then         
#    echo -n "Creating fonts.cache in Type1 fonts directory.."        
#    /usr/X11R7/bin/fc-cache /usr/X11R7/lib/X11/fonts/Type1        
#  fi
#  echo "done. "
#fi
#if [ -d /usr/X11R7/lib/X11/fonts/TrueType ]; then
#  if [ -d /usr/X11R7/lib/X11/fonts/TTF ]; then
#    ( cd /usr/X11R7/lib/X11/fonts/TTF/ ; 
#      for i in ../TrueType/*.ttf ; do 
#        if [ -f $i ] ; then
#          NAME=${i##*/}
#          if [ ! -f "$NAME" ]; then 
##           echo "ln -s $i ."
#            ln -s $i . 
#          fi
#        fi
#      done
#    )
#    ( cd /usr/X11R7/lib/X11/fonts/TTF/ ;
#      for i in ../TrueType/*.ttc ; do
#        if [ -f $i ] ; then
#          NAME=${i##*/}  
#          if [ ! -f "$NAME" ]; then
##           echo "ln -s $i ."
#            ln -s $i .
#          fi
#        fi
#      done
#    )
#  fi
#fi
#%% end
#%% end
