/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.peer.FontPeer;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;
    private static final long serialVersionUID = -4206021311591459213L;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private FontPeer peer;

    public static Font decode(String fontspec) {
        String name = null;
        int style = 0;
        int size = 12;
        StringTokenizer st = new StringTokenizer(fontspec, "-");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (name == null) {
                name = token;
                continue;
            }
            if (token.toUpperCase().equals("BOLD")) {
                style = 1;
                continue;
            }
            if (token.toUpperCase().equals("ITALIC")) {
                style = 2;
                continue;
            }
            if (token.toUpperCase().equals("BOLDITALIC")) {
                style = 3;
                continue;
            }
            int tokenval = 0;
            try {
                tokenval = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (tokenval == 0) continue;
            size = tokenval;
        }
        return new Font(name, style, size);
    }

    public static Font getFont(String propname, Font defval) {
        String propval = System.getProperty(propname);
        if (propval != null) {
            return Font.decode(propval);
        }
        return defval;
    }

    public static Font getFont(String propname) {
        return Font.getFont(propname, null);
    }

    public Font(String name, int style, int size) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.pointSize = size;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return this.style == 1 || this.style == 3;
    }

    public boolean isItalic() {
        return this.style == 2 || this.style == 3;
    }

    public String getFamily() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public FontPeer getPeer() {
        if (this.peer != null) {
            return this.peer;
        }
        this.peer = Toolkit.getDefaultToolkit().getFontPeer(this.name, this.style);
        return this.peer;
    }

    public int hashCode() {
        return new String(this.name + this.size + this.style).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Font)) {
            return false;
        }
        Font f = (Font)obj;
        if (!f.name.equals(this.name)) {
            return false;
        }
        if (f.size != this.size) {
            return false;
        }
        return f.style == this.style;
    }

    public String toString() {
        return this.getClass().getName() + "(name=" + this.name + ",style=" + this.style + ",size=" + this.size + ")";
    }
}

