/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.dgc.DGCImpl;
import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.util.Hashtable;

public class UnicastServer
implements ProtocolConstants {
    private static Hashtable objects = new Hashtable();
    private static Hashtable refcache = new Hashtable();
    private static DGCImpl dgc;

    public static void exportObject(UnicastServerRef obj) {
        UnicastServer.startDGC();
        objects.put(obj.objid, obj);
        refcache.put(obj.myself, obj);
        obj.manager.startServer();
    }

    public static boolean unexportObject(UnicastServerRef obj, boolean force) {
        objects.remove(obj.objid);
        refcache.remove(obj.myself);
        obj.manager.stopServer();
        return true;
    }

    public static UnicastServerRef getExportedRef(Remote remote) {
        return (UnicastServerRef)refcache.get(remote);
    }

    private static synchronized void startDGC() {
        if (dgc == null) {
            try {
                dgc = new DGCImpl();
                dgc.exportObject(dgc);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void dispatch(UnicastConnection conn) throws Exception {
        if (conn.getDataInputStream().readUnsignedByte() != 80) {
            throw new Exception("bad method type");
        }
        UnicastServer.incomingMessageCall(conn);
    }

    private static void incomingMessageCall(UnicastConnection conn) throws IOException {
        Object returnval;
        ObjectInputStream in = conn.getObjectInputStream();
        ObjID objid = ObjID.read(in);
        int method = in.readInt();
        long hash = in.readLong();
        UnicastServerRef uref = (UnicastServerRef)objects.get(objid);
        int returncode = 1;
        Class returncls = null;
        if (uref != null) {
            try {
                returnval = uref.incomingMessageCall(conn, method, hash);
                returncls = uref.getMethodReturnType(method, hash);
            }
            catch (Exception e) {
                returnval = e;
                returncode = 2;
            }
        } else {
            returnval = new NoSuchObjectException("");
            returncode = 2;
        }
        conn.getDataOutputStream().writeByte(81);
        ObjectOutputStream out = conn.getObjectOutputStream();
        out.writeByte(returncode);
        new UID().write(out);
        if (returnval != null && returncls != null) {
            ((RMIObjectOutputStream)out).writeValue(returnval, returncls);
        } else {
            out.writeObject(returnval);
        }
        out.flush();
    }
}

