#!/bin/sh
export CFLAGS=''
export CXXFLAGS=''
export _POSIX2_VERSION='199209'
export PATH=$PATH:/opt/x86-64/bin

tar xjvf binutils-2.14.tar.bz2
mkdir binutils-build
cd binutils-build
../binutils-2.14/configure --prefix=/opt/x86-64 --target=x86_64-unknown-linux 
make -j4
make install
cd ..
rm -rf binutils-2.14/ binutils-build/

tar xjvf gcc-3.2.3.tar.bz2
mkdir gcc-build
cd gcc-build
export CFLAGS='-Dinhibit_libc'
../gcc-3.2.3/configure --prefix=/opt/x86-64 --target=x86_64-unknown-linux --enable-languages=c --disable-shared --disable-multilib --enable-threads=single
make -j4
make install
cd ..
rm -rf gcc-build/ gcc-3.2.3/

tar xjvf linux-2.4.23.tar.bz2
cd linux-2.4.23
make mrproper
yes "" | make config
make include/linux/version.h
mkdir -p /opt/x86-64/x86_64-unknown-linux/include
cp -r include/linux/ include/asm-x86_64/ /opt/x86-64/x86_64-unknown-linux/include 
ln -s asm-x86_64 /opt/x86-64/x86_64-unknown-linux/include/asm
cd ..
rm -rf linux-2.4.23
unset CFLAGS

tar xjvf glibc-2.3.1.tar.bz2
cd glibc-2.3.1
tar xjvf ../glibc-linuxthreads-2.3.1.tar.bz2
patch -Np1 -i ../glibc-2.3.2-sscanf-1.patch 
mkdir ../glibc-build
cd ../glibc-build
echo 'BUILD_CC=gcc' > configparms
echo 'CC=x86_64-unknown-linux-gcc' >> configparms 
../glibc-2.3.1/configure --prefix=/opt/x86-64 \
    --with-headers=/opt/x86-64/x86_64-unknown-linux/include \
    --without-cvs --enable-kernel=2.4 --enable-add-ons \
    --disable-profile \
    --build=i686-pc-linux-gnu --host=x86_64-unknown-linux
make -j4
make install
cd ..
rm -rf glibc-2.3.1/ glibc-build/
