#!/bin/sh
export LFS=/lfs
mount /dev/sda3 $LFS
if [ ! -e $LFS/proc -o ! -e $LFS/sys ] ; then
  mkdir -p $LFS/{proc,sys}
fi
mount -t proc proc $LFS/proc
mount -t sysfs sysfs $LFS/sys
mount -f -t ramfs ramfs $LFS/dev
mount -f -t tmpfs tmpfs $LFS/dev/shm
mount -f -t devpts -o gid=4,mode=620 devpts $LFS/dev/pts
chroot "$LFS" /tools/bin/env -i \
	HOME=/root TERM="$TERM" PS1='\u:\w\$ ' \
	PATH=/bin:/usr/bin:/sbin:/usr/sbin:/tools/bin \
	/tools/bin/bash --login +h
