/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.util.Properties;
import java.util.Vector;

public final class Security {
    private static Vector providers = new Vector();
    private static Properties secprops;

    private Security() {
    }

    private static void loadProviders(String baseUrl, String vendor) {
        if (baseUrl == null || vendor == null) {
            return;
        }
        String secfilestr = baseUrl + "/security/" + vendor + ".security";
        try {
            String name;
            InputStream fin = new URL(secfilestr).openStream();
            secprops = new Properties();
            secprops.load(fin);
            int i = 1;
            while ((name = secprops.getProperty("security.provider." + i)) != null) {
                Exception exception = null;
                try {
                    providers.addElement(Class.forName(name).newInstance());
                }
                catch (ClassNotFoundException x) {
                    exception = x;
                }
                catch (InstantiationException x) {
                    exception = x;
                }
                catch (IllegalAccessException x) {
                    exception = x;
                }
                if (exception != null) {
                    System.err.println("Error loading security provider " + name + ": " + exception);
                }
                ++i;
            }
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getAlgorithmProperty(String algName, String propName) {
        return null;
    }

    public static int insertProviderAt(Provider provider, int position) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("insertProvider." + provider.getName());
        }
        --position;
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            if (((Provider)providers.elementAt(i)).getName() != provider.getName()) continue;
            return -1;
        }
        if (position < 0) {
            position = 0;
        }
        if (position > max) {
            position = max;
        }
        providers.insertElementAt(provider, position);
        return position + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("removeProvider." + name);
        }
        Object p = null;
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            if (((Provider)providers.elementAt(i)).getName() != name) continue;
            providers.remove(i);
            break;
        }
    }

    public static Provider[] getProviders() {
        Object[] array = new Provider[providers.size()];
        providers.copyInto(array);
        return array;
    }

    public static Provider getProvider(String name) {
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            Provider p = (Provider)providers.elementAt(i);
            if (p.getName() != name) continue;
            return p;
        }
        return null;
    }

    public static String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("getProperty." + key);
        }
        return secprops.getProperty(key);
    }

    public static void setProperty(String key, String datnum) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setProperty." + key);
        }
        secprops.put(key, datnum);
    }

    static {
        String base = System.getProperty("gnu.classpath.home.url");
        Security.loadProviders(base, System.getProperty("gnu.classpath.vm.shortname"));
        Security.loadProviders(base, "classpath");
    }
}

