/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.PropertyPermission;

public final class System {
    private static Properties properties;
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;

    private System() {
    }

    public static void setIn(InputStream in) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setIn0(in);
    }

    public static void setOut(PrintStream out) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setOut0(out);
    }

    public static void setErr(PrintStream err) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setErr0(err);
    }

    public static synchronized void setSecurityManager(SecurityManager sm) {
        if (Runtime.securityManager != null) {
            Runtime.securityManager.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        Runtime.securityManager = sm;
    }

    public static SecurityManager getSecurityManager() {
        return Runtime.securityManager;
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    public static Properties getProperties() {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return properties;
    }

    public static void setProperties(Properties properties) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        if (properties == null) {
            properties = (Properties)Runtime.defaultProperties.clone();
        }
        System.properties = properties;
    }

    public static String getProperty(String key) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPropertyAccess(key);
        } else if (key.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return properties.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        SecurityManager sm = Runtime.securityManager;
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)properties.setProperty(key, value);
    }

    public static String getenv(String name) {
        throw new Error("getenv no longer supported, use properties instead: " + name);
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean finalizeOnExit) {
        Runtime.getRuntime();
    }

    public static void load(String filename) {
        Runtime.getRuntime().load(filename);
    }

    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary(libname);
    }

    public static String mapLibraryName(String libname) {
        return Runtime.nativeGetLibname("", libname);
    }

    static native boolean isWordsBigEndian();

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    static {
        Properties defaultProperties = Runtime.defaultProperties;
        if (defaultProperties.get("gnu.classpath.home.url") == null) {
            defaultProperties.put("gnu.classpath.home.url", "file://" + defaultProperties.get("gnu.classpath.home") + "/lib");
        }
        if (defaultProperties.get("gnu.classpath.vm.shortname") == null) {
            String value = defaultProperties.getProperty("java.vm.name");
            int index = value.lastIndexOf(32);
            if (index != -1) {
                value = value.substring(index + 1);
            }
            defaultProperties.put("gnu.classpath.vm.shortname", value);
        }
        defaultProperties.put("gnu.cpu.endian", System.isWordsBigEndian() ? "big" : "little");
        if (defaultProperties.get("java.io.tmpdir") == null) {
            defaultProperties.put("java.io.tmpdir", defaultProperties.get("java.tmpdir"));
        }
        properties = (Properties)Runtime.defaultProperties.clone();
        in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), true);
        err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);
    }
}

