/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class FileChannelImpl
extends FileChannel {
    public long address;
    public int length;
    public int fd;
    public MappedByteBuffer buf;
    public Object file_obj;

    private native long lengthInternal(int var1) throws IOException;

    public FileChannelImpl(int fd, Object obj) {
        this.fd = fd;
        this.file_obj = obj;
    }

    public long size() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.lengthInternal(this.fd);
    }

    protected void implCloseChannel() throws IOException {
        if (this.address != 0L) {
            FileChannelImpl.nio_unmmap_file(this.fd, this.address, this.length);
            this.address = 0L;
        }
        this.fd = 0;
        if (this.file_obj instanceof RandomAccessFile) {
            RandomAccessFile o = (RandomAccessFile)this.file_obj;
            o.close();
        } else if (this.file_obj instanceof FileInputStream) {
            FileInputStream o = (FileInputStream)this.file_obj;
            o.close();
        } else if (this.file_obj instanceof FileOutputStream) {
            FileOutputStream o = (FileOutputStream)this.file_obj;
            o.close();
        }
    }

    public int read(ByteBuffer dst) throws IOException {
        int s = (int)this.size();
        if (this.buf == null) {
            throw new EOFException("file not mapped");
        }
        for (int i = 0; i < s; ++i) {
            dst.put(this.buf.get());
        }
        return s;
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            result += (long)this.write(dsts[i]);
        }
        return result;
    }

    public int write(ByteBuffer src) throws IOException {
        int w = 0;
        if (this.buf == null) {
            throw new EOFException("file not mapped");
        }
        while (src.hasRemaining()) {
            this.buf.put(src.get());
            ++w;
        }
        return w;
    }

    public int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res = 0L;
        for (int i = offset; i < offset + length; ++i) {
            res += (long)this.write(srcs[i]);
        }
        return res;
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        if (mode != FileChannel.MapMode.READ_ONLY && mode != FileChannel.MapMode.READ_WRITE && mode != FileChannel.MapMode.PRIVATE || position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    static MappedByteBuffer create_direct_mapped_buffer(long address, long length) {
        return null;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public void force(boolean metaData) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        FileChannelImpl.nio_msync(this.fd, this.address, this.length);
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public FileLock lock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("not implemented");
    }

    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("not implemented");
    }

    public FileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("not implemented");
    }

    private static native long nio_mmap_file(int var0, long var1, int var3, int var4);

    private static native void nio_unmmap_file(int var0, long var1, int var3);

    private static native void nio_msync(int var0, long var1, int var3);
}

