/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.Messages;
import gnu.classpath.tools.appletviewer.PluginAppletWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;

class PluginAppletViewer {
    static HashMap appletWindows = new HashMap();
    private static BufferedReader pluginInputStream;
    private static BufferedWriter pluginOutputStream;

    PluginAppletViewer() {
    }

    static void start(InputStream inputStream, OutputStream outputStream) throws MalformedURLException, IOException {
        pluginInputStream = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        pluginOutputStream = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")));
        PluginAppletViewer.write("running");
        String message = PluginAppletViewer.read();
        PluginAppletWindow currentWindow = null;
        while (true) {
            if (message.startsWith("instance")) {
                String key = message.substring(9);
                if (appletWindows.get(key) == null) {
                    appletWindows.put(key, new PluginAppletWindow());
                }
                currentWindow = (PluginAppletWindow)appletWindows.get(key);
            } else if (message.startsWith("tag")) {
                int pos = message.indexOf(32, 4);
                String documentbase = message.substring(4, pos);
                String tag = message.substring(pos + 1);
                currentWindow.setParser(tag, documentbase);
            } else if (message.startsWith("handle")) {
                long handle = Long.parseLong(message.substring(7));
                currentWindow.setHandle(handle);
            } else if (message.startsWith("width")) {
                int width = Integer.parseInt(message.substring(6));
                currentWindow.setSize(width, currentWindow.getHeight());
            } else if (message.startsWith("height")) {
                int height = Integer.parseInt(message.substring(7));
                currentWindow.setSize(currentWindow.getWidth(), height);
            } else if (message.startsWith("destroy")) {
                appletWindows.remove(currentWindow);
                currentWindow.dispose();
            }
            message = PluginAppletViewer.read();
        }
    }

    static void write(String message) throws IOException {
        pluginOutputStream.write(message, 0, message.length());
        pluginOutputStream.newLine();
        pluginOutputStream.flush();
        System.err.println("  " + Messages.getString("PluginAppletViewer.AppletViewerWrote") + message);
    }

    static String read() throws IOException {
        String message = pluginInputStream.readLine();
        System.err.println("  " + Messages.getString("PluginAppletViewer.AppletViewerRead") + message);
        if (message == null || message.equals("shutdown")) {
            pluginInputStream.close();
            pluginOutputStream.close();
            System.err.println(Messages.getString("PluginAppletViewer.AppletViewerExiting"));
            System.exit(0);
        }
        return message;
    }
}

