/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    private static final long serialVersionUID = 1614381073220130939L;
    protected ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    protected SingleSelectionModel model;
    public static final int SCROLL_TAB_LAYOUT = 1;
    public static final int WRAP_TAB_LAYOUT = 0;
    protected int tabPlacement = 1;
    private transient int layoutPolicy;
    transient Vector tabs = new Vector();

    public JTabbedPane() {
        this(1, 0);
    }

    public JTabbedPane(int tabPlacement) {
        this(tabPlacement, 0);
    }

    public JTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        if (tabPlacement != 1 && tabPlacement != 3 && tabPlacement != 4 && tabPlacement != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (tabLayoutPolicy != 1 && tabLayoutPolicy != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        this.tabPlacement = tabPlacement;
        this.layoutPolicy = tabLayoutPolicy;
        this.setModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TabbedPaneUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = changeListeners.length - 2;
        while (i >= 0) {
            if (changeListeners[i] == ChangeListener.class) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])super.getListeners(ChangeListener.class);
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel m) {
        if (m != this.model) {
            SingleSelectionModel oldModel = this.model;
            if (oldModel != null && this.changeListener != null) {
                oldModel.removeChangeListener(this.changeListener);
            }
            this.model = m;
            if (this.model != null) {
                if (this.changeListener == null) {
                    this.changeListener = this.createChangeListener();
                }
                this.model.addChangeListener(this.changeListener);
            }
            this.firePropertyChange("model", oldModel, this.model);
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 1 && tabPlacement != 3 && tabPlacement != 4 && tabPlacement != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (tabPlacement != this.tabPlacement) {
            int oldPlacement = this.tabPlacement;
            this.tabPlacement = tabPlacement;
            this.firePropertyChange("tabPlacement", oldPlacement, this.tabPlacement);
        }
    }

    public int getTabLayoutPolicy() {
        return this.layoutPolicy;
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
        if (tabLayoutPolicy != 1 && tabLayoutPolicy != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        if (tabLayoutPolicy != this.layoutPolicy) {
            int oldPolicy = this.layoutPolicy;
            this.layoutPolicy = tabLayoutPolicy;
            this.firePropertyChange("tabLayoutPolicy", oldPolicy, this.layoutPolicy);
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    private void checkIndex(int index, int start, int end) {
        if (index < start || index >= end) {
            throw new IndexOutOfBoundsException("Index < " + start + " || Index >= " + end);
        }
    }

    public void setSelectedIndex(int index) {
        this.checkIndex(index, -1, this.tabs.size());
        if (index != this.getSelectedIndex()) {
            this.model.setSelectedIndex(index);
        }
    }

    public Component getSelectedComponent() {
        int selectedIndex = this.getSelectedIndex();
        Component selected = null;
        if (selectedIndex >= 0) {
            selected = this.getComponentAt(selectedIndex);
        }
        return selected;
    }

    public void setSelectedComponent(Component c) {
        if (c.getParent() == this) {
            this.setSelectedIndex(this.indexOfComponent(c));
        } else {
            this.setComponentAt(this.getSelectedIndex(), c);
        }
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (title == null) {
            title = "";
        }
        Page p = new Page(title, icon, component, tip);
        this.tabs.insertElementAt(p, index);
        if (component != null) {
            component.hide();
            super.add(component);
        }
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
            this.fireStateChanged();
        }
        this.revalidate();
        this.repaint();
    }

    public void addTab(String title, Icon icon, Component component, String tip) {
        this.insertTab(title, icon, component, tip, this.tabs.size());
    }

    public void addTab(String title, Icon icon, Component component) {
        this.insertTab(title, icon, component, null, this.tabs.size());
    }

    public void addTab(String title, Component component) {
        this.insertTab(title, null, component, null, this.tabs.size());
    }

    public Component add(Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(String title, Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(title, null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(Component component, int index) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, index);
        }
        return component;
    }

    public void add(Component component, Object constraints) {
        this.add(component, constraints, this.tabs.size());
    }

    public void add(Component component, Object constraints, int index) {
        if (component instanceof UIResource) {
            super.add(component);
        } else if (constraints instanceof String) {
            this.insertTab((String)constraints, null, component, null, index);
        } else {
            this.insertTab(component.getName(), constraints instanceof Icon ? (Icon)constraints : null, component, null, index);
        }
    }

    public void removeTabAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex >= index) {
            this.setSelectedIndex(selectedIndex - 1);
        }
        Component comp = this.getComponentAt(index);
        this.tabs.remove(index);
        if (comp != null) {
            Component[] children = this.getComponents();
            int i = children.length - 1;
            while (i >= 0) {
                if (children[i] == comp) {
                    super.remove(i);
                    comp.setVisible(true);
                    break;
                }
                --i;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void remove(Component component) {
        int index = this.indexOfComponent(component);
        if (index == -1) {
            Component[] cs = this.getComponents();
            int i = 0;
            while (i < cs.length) {
                if (cs[i] == component) {
                    super.remove(i);
                }
                ++i;
            }
        } else {
            this.removeTabAt(index);
        }
    }

    public void remove(int index) {
        this.removeTabAt(index);
    }

    public void removeAll() {
        this.setSelectedIndex(-1);
        int i = this.getTabCount() - 1;
        while (i >= 0) {
            this.removeTabAt(i);
            --i;
        }
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int getTabRunCount() {
        return ((TabbedPaneUI)this.ui).getTabRunCount(this);
    }

    public String getTitleAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getTitle();
    }

    public Icon getIconAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getIcon();
    }

    public Icon getDisabledIconAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getDisabledIcon();
    }

    public String getToolTipTextAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getTip();
    }

    public Color getForegroundAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getForeground();
    }

    public Color getBackgroundAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getBackground();
    }

    public Component getComponentAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getComponent();
    }

    public boolean isEnabledAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).isEnabled();
    }

    public int getMnemonicAt(int tabIndex) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(tabIndex)).getMnemonic();
    }

    public int getDisplayedMnemonicIndexAt(int tabIndex) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(tabIndex)).getDisplayedMnemonicIndex();
    }

    public Rectangle getBoundsAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((TabbedPaneUI)this.ui).getTabBounds(this, index);
    }

    public void setTitleAt(int index, String title) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setTitle(title);
    }

    public void setIconAt(int index, Icon icon) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setIcon(icon);
    }

    public void setDisabledIconAt(int index, Icon disabledIcon) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setDisabledIcon(disabledIcon);
    }

    public void setToolTipTextAt(int index, String toolTipText) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setTip(toolTipText);
    }

    public void setBackgroundAt(int index, Color background) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setBackground(background);
    }

    public void setForegroundAt(int index, Color foreground) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setForeground(foreground);
    }

    public void setEnabledAt(int index, boolean enabled) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setEnabled(enabled);
    }

    public void setComponentAt(int index, Component component) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setComponent(component);
    }

    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(tabIndex)).setDisplayedMnemonicIndex(mnemonicIndex);
    }

    public void setMnemonicAt(int tabIndex, int mnemonic) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(tabIndex)).setMnemonic(mnemonic);
    }

    public int indexOfTab(String title) {
        int index = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(i)).getTitle().equals(title)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexOfTab(Icon icon) {
        int index = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(i)).getIcon() == icon) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexOfComponent(Component component) {
        int index = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(i)).getComponent() == component) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexAtLocation(int x, int y) {
        return ((TabbedPaneUI)this.ui).tabForCoordinate(this, x, y);
    }

    public String getToolTipText(MouseEvent event) {
        int index = this.indexAtLocation(event.getX(), event.getY());
        return ((Page)this.tabs.elementAt(index)).getTip();
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer(super.paramString());
        sb.append(",tabPlacement=");
        if (this.tabPlacement == 1) {
            sb.append("TOP");
        }
        if (this.tabPlacement == 3) {
            sb.append("BOTTOM");
        }
        if (this.tabPlacement == 2) {
            sb.append("LEFT");
        }
        if (this.tabPlacement == 4) {
            sb.append("RIGHT");
        }
        return sb.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJTabbedPane ctx = new AccessibleJTabbedPane();
            this.addChangeListener(ctx);
            this.accessibleContext = ctx;
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long serialVersionUID = 7610530885966830483L;

        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            this.firePropertyChange("AccessibleSelection", null, source);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return JTabbedPane.this.getTabCount();
        }

        public Accessible getAccessibleChild(int i) {
            Page child = null;
            if (i >= 0 && i < JTabbedPane.this.tabs.size()) {
                child = (Page)JTabbedPane.this.tabs.get(i);
            }
            return child;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point p) {
            int tabIndex = JTabbedPane.this.indexAtLocation(p.x, p.y);
            if (tabIndex >= 0) {
                return this.getAccessibleChild(tabIndex);
            }
            return this.getAccessibleSelection(0);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int i) {
            Page result = null;
            int selected = JTabbedPane.this.getSelectedIndex();
            if (selected >= 0) {
                result = (Page)JTabbedPane.this.tabs.get(selected);
            }
            return result;
        }

        public boolean isAccessibleChildSelected(int i) {
            return i == JTabbedPane.this.getSelectedIndex();
        }

        public void addAccessibleSelection(int i) {
            JTabbedPane.this.setSelectedIndex(i);
        }

        public void removeAccessibleSelection(int i) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 497359819958114132L;

        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane.this.fireStateChanged();
        }
    }

    private class Page
    extends AccessibleContext
    implements Accessible {
        private String tip;
        private Component component;
        private transient Icon icon;
        private transient Icon disabledIcon;
        private transient boolean enabled = true;
        private transient String title;
        private transient Color bg;
        private transient Color fg;
        private transient int mnemonicKey;
        private transient int underlinedChar = -1;
        private static final long serialVersionUID = 1614381073220130939L;

        protected Page(String title, Icon icon, Component component, String tip) {
            this.title = title;
            this.icon = icon;
            this.component = component;
            this.tip = tip;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component c) {
            int i = JTabbedPane.this.indexOfComponent(this.component);
            JTabbedPane.this.insertTab(this.title, this.icon, c, this.tip, i);
            this.component = c;
            JTabbedPane.this.removeTabAt(i);
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public Color getBackground() {
            Color background = this.bg == null ? JTabbedPane.this.getBackground() : this.bg;
            return background;
        }

        public void setBackground(Color background) {
            this.bg = background;
        }

        public Color getForeground() {
            Color foreground = this.fg == null ? JTabbedPane.this.getForeground() : this.fg;
            return foreground;
        }

        public void setForeground(Color foreground) {
            this.fg = foreground;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String text) {
            this.title = text;
            if (this.title != null && this.title.length() <= this.underlinedChar) {
                this.setDisplayedMnemonicIndex(this.title.length() - 1);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getDisabledIcon() {
            if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
                this.setDisabledIcon(this.icon);
            }
            return this.disabledIcon;
        }

        public void setDisabledIcon(Icon disabledIcon) {
            this.disabledIcon = disabledIcon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getMnemonic() {
            return this.mnemonicKey;
        }

        public void setMnemonic(int key) {
            this.setMnemonic((char)key);
        }

        public void setMnemonic(char aChar) {
            this.mnemonicKey = aChar;
            if (this.title != null) {
                this.setDisplayedMnemonicIndex(this.title.indexOf(this.mnemonicKey));
            }
        }

        public int getDisplayedMnemonicIndex() {
            return this.underlinedChar;
        }

        public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
            if (index < -1 || this.title != null && index >= this.title.length()) {
                throw new IllegalArgumentException();
            }
            if (this.title == null || this.mnemonicKey == 0 || index > -1 && this.title.charAt(index) != this.mnemonicKey) {
                index = -1;
            }
            this.underlinedChar = index;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return this.title;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleContext parentCtx = JTabbedPane.this.getAccessibleContext();
            AccessibleStateSet state = parentCtx.getAccessibleStateSet();
            state.add(AccessibleState.SELECTABLE);
            if (this.component == JTabbedPane.this.getSelectedComponent()) {
                state.add(AccessibleState.SELECTED);
            }
            return state;
        }

        public int getAccessibleIndexInParent() {
            return JTabbedPane.this.indexOfTab(this.title);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int i) {
            return (Accessible)((Object)this.component);
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }
    }
}

