/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

public class JFrame
extends Frame
implements WindowConstants,
RootPaneContainer,
Accessible {
    public static final int EXIT_ON_CLOSE = 3;
    private static final long serialVersionUID = -3362141868504252139L;
    private static boolean defaultLookAndFeelDecorated;
    private int closeAction = 1;
    protected AccessibleContext accessibleContext;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;

    public JFrame() {
        super("");
        this.frameInit();
    }

    public JFrame(String title) {
        super(title);
        this.frameInit();
    }

    public JFrame(GraphicsConfiguration gc) {
        super(gc);
        this.frameInit();
    }

    public JFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.frameInit();
    }

    protected void frameInit() {
        this.enableEvents(72L);
        super.setLayout(new BorderLayout());
        this.setBackground(UIManager.getDefaults().getColor("control"));
        this.enableEvents(64L);
        this.getRootPane();
        if (JFrame.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.setRootPaneCheckingEnabled(true);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setJMenuBar(JMenuBar menubar) {
        this.getRootPane().setJMenuBar(menubar);
    }

    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.getRootPane().setLayeredPane(layeredPane);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        if (this.rootPane == null) {
            this.setRootPane(this.createRootPane());
        }
        return this.rootPane;
    }

    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = root;
        this.add((Component)this.rootPane, "Center");
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container contentPane) {
        this.getRootPane().setContentPane(contentPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component glassPane) {
        this.getRootPane().setGlassPane(glassPane);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void remove(Component comp) {
        if (comp == this.rootPane) {
            super.remove(this.rootPane);
        } else {
            this.getContentPane().remove(comp);
        }
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    public static void setDefaultLookAndFeelDecorated(boolean decorated) {
        defaultLookAndFeelDecorated = decorated;
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        return defaultLookAndFeelDecorated;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFrame();
        }
        return this.accessibleContext;
    }

    public int getDefaultCloseOperation() {
        return this.closeAction;
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer(super.paramString());
        sb.append(",defaultCloseOperation=");
        sb.append(SwingUtilities.convertWindowConstantToString(this.getDefaultCloseOperation()));
        sb.append(",rootPane=");
        if (this.rootPane != null) {
            sb.append(this.rootPane);
        }
        sb.append(",rootPaneCheckingEnabled=").append(this.rootPaneCheckingEnabled);
        return sb.toString();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            switch (this.closeAction) {
                case 3: {
                    System.exit(0);
                    break;
                }
                case 2: {
                    this.dispose();
                    break;
                }
                case 1: {
                    this.setVisible(false);
                    break;
                }
            }
        }
    }

    public void setDefaultCloseOperation(int operation) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && operation == 3) {
            sm.checkExit(0);
        }
        if (operation != 3 && operation != 2 && operation != 1 && operation != 0) {
            throw new IllegalArgumentException("operation must be EXIT_ON_CLOSE, HIDE_ON_CLOSE, DISPOSE_ON_CLOSE, or DO_NOTHING_ON_CLOSE");
        }
        this.closeAction = operation;
    }

    protected class AccessibleJFrame
    extends Frame.AccessibleAWTFrame {
        protected AccessibleJFrame() {
            super(JFrame.this);
        }
    }
}

