/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;

public interface DataLine
extends Line {
    public int available();

    public void drain();

    public void flush();

    public int getBufferSize();

    public AudioFormat getFormat();

    public int getFramePosition();

    public float getLevel();

    public long getLongFramePosition();

    public long getMicrosecondPosition();

    public boolean isActive();

    public boolean isRunning();

    public void start();

    public void stop();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info
    extends Line.Info {
        private int minBufferSize;
        private int maxBufferSize;
        private AudioFormat[] formats;

        public Info(Class<?> klass, AudioFormat fmt) {
            super(klass);
            this.minBufferSize = -1;
            this.maxBufferSize = -1;
            this.formats = new AudioFormat[]{fmt};
        }

        public Info(Class<?> klass, AudioFormat[] fmts, int minSize, int maxSize) {
            super(klass);
            this.minBufferSize = minSize;
            this.maxBufferSize = maxSize;
            this.formats = fmts;
        }

        public Info(Class<?> klass, AudioFormat fmt, int size) {
            super(klass);
            this.minBufferSize = size;
            this.maxBufferSize = size;
            this.formats = new AudioFormat[]{fmt};
        }

        public AudioFormat[] getFormats() {
            return this.formats;
        }

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public int getMinBufferSize() {
            return this.minBufferSize;
        }

        public boolean isFormatSupported(AudioFormat fmt) {
            int i = 0;
            while (i < this.formats.length) {
                if (fmt.matches(this.formats[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean matches(Line.Info o) {
            if (!super.matches(o) || !(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (this.minBufferSize < other.minBufferSize || this.maxBufferSize > other.maxBufferSize) {
                return false;
            }
            int i = 0;
            while (i < this.formats.length) {
                boolean ok = false;
                int j = 0;
                while (j < other.formats.length) {
                    if (this.formats[i].matches(other.formats[j])) {
                        ok = true;
                        break;
                    }
                    ++j;
                }
                if (!ok) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("formats: [");
            int i = 0;
            while (i < this.formats.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.formats[i].toString());
                ++i;
            }
            result.append("]; minBufferSize: ");
            result.append(this.minBufferSize);
            result.append("; maxBufferSize: ");
            result.append(this.maxBufferSize);
            return result.toString();
        }
    }
}

