/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.RE;
import gnu.java.util.regex.REMatch;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private CharSequence input;
    private CharIndexed inputCharIndexed;
    private int position;
    private int appendPosition;
    private REMatch match;

    Matcher(Pattern pattern2, CharSequence input) {
        this.pattern = pattern2;
        this.input = input;
        this.inputCharIndexed = RE.makeCharIndexed(input, 0);
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) throws IllegalStateException {
        this.assertMatchOp();
        sb.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        sb.append(RE.getReplacement(replacement, this.match, 512));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return sb;
    }

    public int end() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public int end(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex(group);
    }

    public boolean find() {
        boolean first = this.match == null;
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, this.position);
        if (this.match != null) {
            int endIndex = this.match.getEndIndex();
            if (!first && endIndex == this.position) {
                this.match = null;
                if (this.position < this.input.length() - 1) {
                    ++this.position;
                    return this.find(this.position);
                }
                return false;
            }
            this.position = endIndex;
            return true;
        }
        return false;
    }

    public boolean find(int start) {
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, start);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    public String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public String group(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.toString(group);
    }

    public String replaceFirst(String replacement) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, replacement, this.position, 512);
    }

    public String replaceAll(String replacement) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, replacement, this.position, 512);
    }

    public int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public boolean lookingAt() {
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, 0, 4096, null);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public boolean matches() {
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, 0, 4352, null);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                if (this.position == this.input.length()) {
                    return true;
                }
            }
            this.match = null;
        }
        return false;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.position = 0;
        this.match = null;
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.input = input;
        this.inputCharIndexed = RE.makeCharIndexed(input, 0);
        return this.reset();
    }

    public int start() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public int start(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex(group);
    }

    public boolean hitEnd() {
        return this.inputCharIndexed.hitEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[pattern=").append(this.pattern.pattern()).append(" region=").append("0").append(",").append(this.input.length()).append(" lastmatch=").append(this.match == null ? "" : this.match.toString()).append("]");
        return sb.toString();
    }

    private void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }
}

