/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;

final class FloatBufferImpl
extends FloatBuffer {
    private boolean readOnly;

    FloatBufferImpl(int capacity) {
        this(new float[capacity], 0, capacity, capacity, 0, -1, false);
    }

    FloatBufferImpl(float[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark);
        this.backing_buffer = buffer;
        this.array_offset = offset;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public FloatBuffer slice() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public FloatBuffer duplicate() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public FloatBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int p = this.position();
        int n = this.limit() - p;
        if (n > 0) {
            System.arraycopy(this.backing_buffer, this.array_offset + p, this.backing_buffer, this.array_offset, n);
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public float get() {
        this.checkForUnderflow();
        float result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public FloatBuffer put(float value) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public float get(int index) {
        this.checkIndex(index);
        return this.backing_buffer[index];
    }

    public FloatBuffer put(int index, float value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        this.backing_buffer[index] = value;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

