/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel = false;

    public void setColorModel(ColorModel model) {
        if (model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            IndexColorModel newCM = this.filterIndexColorModel((IndexColorModel)model);
            this.substituteColorModel(model, newCM);
            this.consumer.setColorModel(this.newmodel);
        } else {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void substituteColorModel(ColorModel oldcm, ColorModel newcm) {
        this.origmodel = oldcm;
        this.newmodel = newcm;
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel icm) {
        int len = icm.getMapSize();
        byte[] reds = new byte[len];
        byte[] greens = new byte[len];
        byte[] blues = new byte[len];
        byte[] alphas = new byte[len];
        icm.getAlphas(alphas);
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        int transparent = icm.getTransparentPixel();
        boolean needAlpha = false;
        int i = 0;
        while (i < len) {
            int rgb = this.filterRGB(-1, -1, icm.getRGB(i));
            alphas[i] = (byte)(rgb >> 24);
            if (alphas[i] != -1 && i != transparent) {
                needAlpha = true;
            }
            reds[i] = (byte)(rgb >> 16);
            greens[i] = (byte)(rgb >> 8);
            blues[i] = (byte)rgb;
            ++i;
        }
        IndexColorModel newIcm = needAlpha ? new IndexColorModel(icm.getPixelSize(), len, reds, greens, blues, alphas) : new IndexColorModel(icm.getPixelSize(), len, reds, greens, blues, transparent);
        return newIcm;
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int offset, int scansize) {
        int index = offset;
        int yp = 0;
        while (yp < h) {
            int xp = 0;
            while (xp < w) {
                pixels[index] = this.filterRGB(xp + x, yp + y, pixels[index]);
                ++index;
                ++xp;
            }
            index += scansize - w;
            ++yp;
        }
        this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, offset, scansize);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        if (model == this.origmodel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, offset, scansize);
        } else {
            int[] filtered = new int[w];
            int index = offset;
            int yp = 0;
            while (yp < h) {
                int xp = 0;
                while (xp < w) {
                    filtered[xp] = model.getRGB(pixels[index] & 0xFF);
                    ++index;
                    ++xp;
                }
                index += scansize - w;
                this.filterRGBPixels(x, y + yp, w, 1, filtered, 0, w);
                ++yp;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        if (model == this.origmodel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, offset, scansize);
        } else {
            int[] filtered = new int[w];
            int index = offset;
            int yp = 0;
            while (yp < h) {
                int xp = 0;
                while (xp < w) {
                    filtered[xp] = model.getRGB(pixels[index] & 0xFF);
                    ++index;
                    ++xp;
                }
                index += scansize - w;
                this.filterRGBPixels(x, y + yp, w, 1, filtered, 0, w);
                ++yp;
            }
        }
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

