/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.http.Authenticator;
import gnu.java.net.protocol.http.ByteArrayRequestBodyWriter;
import gnu.java.net.protocol.http.ChunkedInputStream;
import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import gnu.java.net.protocol.http.Credentials;
import gnu.java.net.protocol.http.HTTPConnection;
import gnu.java.net.protocol.http.HTTPDateFormat;
import gnu.java.net.protocol.http.Headers;
import gnu.java.net.protocol.http.LimitedLengthInputStream;
import gnu.java.net.protocol.http.RequestBodyWriter;
import gnu.java.net.protocol.http.Response;
import gnu.java.net.protocol.http.ResponseHeaderHandler;
import gnu.java.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class Request {
    protected final HTTPConnection connection;
    protected final String method;
    protected final String path;
    protected final Headers requestHeaders;
    protected RequestBodyWriter requestBodyWriter;
    protected Map<String, ResponseHeaderHandler> responseHeaderHandlers;
    protected Authenticator authenticator;
    private boolean dispatched;
    byte[] nonce;

    protected Request(HTTPConnection connection, String method, String path) {
        this.connection = connection;
        this.method = method;
        this.path = path;
        this.requestHeaders = new Headers();
        this.responseHeaderHandlers = new HashMap<String, ResponseHeaderHandler>();
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestURI() {
        return String.valueOf(this.connection.getURI()) + this.path;
    }

    public Headers getHeaders() {
        return this.requestHeaders;
    }

    public String getHeader(String name) {
        return this.requestHeaders.getValue(name);
    }

    public int getIntHeader(String name) {
        return this.requestHeaders.getIntValue(name);
    }

    public Date getDateHeader(String name) {
        return this.requestHeaders.getDateValue(name);
    }

    public void setHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public void setRequestBody(byte[] requestBody) {
        this.setRequestBodyWriter(new ByteArrayRequestBodyWriter(requestBody));
    }

    public void setRequestBodyWriter(RequestBodyWriter requestBodyWriter) {
        this.requestBodyWriter = requestBodyWriter;
    }

    public void setResponseHeaderHandler(String name, ResponseHeaderHandler handler) {
        this.responseHeaderHandlers.put(name, handler);
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Response dispatch() throws IOException {
        Response response;
        if (this.dispatched) {
            throw new ProtocolException("request already dispatched");
        }
        String version = this.connection.getVersion();
        int contentLength = -1;
        boolean retry = false;
        int attempts = 0;
        boolean expectingContinue = false;
        if (this.requestBodyWriter != null) {
            contentLength = this.requestBodyWriter.getContentLength();
            String expect = this.getHeader("Expect");
            if (expect != null && expect.equals("100-continue")) {
                expectingContinue = true;
            } else {
                this.setHeader("Content-Length", Integer.toString(contentLength));
            }
        }
        try {
            block2: do {
                retry = false;
                OutputStream out = this.connection.getOutputStream();
                String requestUri = this.path;
                if (this.connection.isUsingProxy() && !"*".equals(requestUri) && !"CONNECT".equals(this.method)) {
                    requestUri = this.getRequestURI();
                }
                String line = String.valueOf(this.method) + ' ' + requestUri + ' ' + version + "\r\n";
                out.write(line.getBytes("US-ASCII"));
                for (Headers.HeaderElement elt : this.requestHeaders) {
                    line = String.valueOf(elt.name) + ": " + elt.value + "\r\n";
                    out.write(line.getBytes("US-ASCII"));
                }
                out.write("\r\n".getBytes("US-ASCII"));
                if (this.requestBodyWriter != null && !expectingContinue) {
                    int len;
                    byte[] buffer = new byte[4096];
                    int count = 0;
                    this.requestBodyWriter.reset();
                    do {
                        if ((len = this.requestBodyWriter.write(buffer)) <= 0) continue;
                        out.write(buffer, 0, len);
                    } while (len > -1 && (count += len) < contentLength);
                }
                out.flush();
                do {
                    int sc;
                    if ((sc = (response = this.readResponse(this.connection.getInputStream())).getCode()) == 401 && this.authenticator != null) {
                        if (!this.authenticate(response, attempts++)) continue block2;
                        retry = true;
                        continue block2;
                    }
                    if (sc != 100) continue block2;
                } while (!expectingContinue);
                this.requestHeaders.remove("Expect");
                this.setHeader("Content-Length", Integer.toString(contentLength));
                expectingContinue = false;
                retry = true;
            } while (retry);
        }
        catch (IOException e) {
            this.connection.close();
            throw e;
        }
        return response;
    }

    Response readResponse(InputStream in) throws IOException {
        LineInputStream lis = new LineInputStream(in);
        String line = lis.readLine();
        if (line == null) {
            throw new ProtocolException("Peer closed connection");
        }
        if (!line.startsWith("HTTP/")) {
            throw new ProtocolException(line);
        }
        int len = line.length();
        int start = 5;
        int end = 6;
        while (line.charAt(end) != '.') {
            ++end;
        }
        int majorVersion = Integer.parseInt(line.substring(start, end));
        start = end + 1;
        end = start + 1;
        while (line.charAt(end) != ' ') {
            ++end;
        }
        int minorVersion = Integer.parseInt(line.substring(start, end));
        start = end + 1;
        end = start + 3;
        int code = Integer.parseInt(line.substring(start, end));
        String message = line.substring(end + 1, len - 1);
        Headers responseHeaders = new Headers();
        responseHeaders.parse(lis);
        this.notifyHeaderHandlers(responseHeaders);
        InputStream body = null;
        switch (code) {
            case 100: {
                break;
            }
            case 204: 
            case 205: 
            case 304: {
                body = this.createResponseBodyStream(responseHeaders, majorVersion, minorVersion, in, false);
                break;
            }
            default: {
                body = this.createResponseBodyStream(responseHeaders, majorVersion, minorVersion, in, true);
            }
        }
        Response ret = new Response(majorVersion, minorVersion, code, message, responseHeaders, body);
        return ret;
    }

    void notifyHeaderHandlers(Headers headers) {
        for (Headers.HeaderElement entry : headers) {
            ResponseHeaderHandler handler;
            if ("Set-Cookie".equalsIgnoreCase(entry.name)) {
                this.handleSetCookie(entry.value);
            }
            if ((handler = this.responseHeaderHandlers.get(entry.name)) == null) continue;
            handler.setValue(entry.value);
        }
    }

    private InputStream createResponseBodyStream(Headers responseHeaders, int majorVersion, int minorVersion, InputStream in, boolean mayHaveBody) throws IOException {
        long contentLength = -1L;
        boolean doClose = "close".equalsIgnoreCase(this.getHeader("Connection")) || "close".equalsIgnoreCase(responseHeaders.getValue("Connection")) || this.connection.majorVersion == 1 && this.connection.minorVersion == 0 || majorVersion == 1 && minorVersion == 0;
        String transferCoding = responseHeaders.getValue("Transfer-Encoding");
        if ("HEAD".equals(this.method) || !mayHaveBody) {
            in = new LimitedLengthInputStream(in, 0L, true, this.connection, doClose);
        } else if ("chunked".equalsIgnoreCase(transferCoding)) {
            in = new LimitedLengthInputStream(in, -1L, false, this.connection, doClose);
            in = new ChunkedInputStream(in, responseHeaders);
        } else {
            contentLength = responseHeaders.getLongValue("Content-Length");
            if (contentLength < 0L) {
                doClose = true;
            }
            in = new LimitedLengthInputStream(in, contentLength, contentLength >= 0L, this.connection, doClose);
        }
        String contentCoding = responseHeaders.getValue("Content-Encoding");
        if (contentCoding != null && !"identity".equals(contentCoding)) {
            if ("gzip".equals(contentCoding)) {
                in = new GZIPInputStream(in);
            } else if ("deflate".equals(contentCoding)) {
                in = new InflaterInputStream(in);
            } else {
                throw new ProtocolException("Unsupported Content-Encoding: " + contentCoding);
            }
            responseHeaders.remove("Content-Encoding");
        }
        return in;
    }

    boolean authenticate(Response response, int attempts) throws IOException {
        int si;
        String scheme;
        String challenge = response.getHeader("WWW-Authenticate");
        if (challenge == null) {
            challenge = response.getHeader("Proxy-Authenticate");
        }
        String string = scheme = (si = challenge.indexOf(32)) == -1 ? challenge : challenge.substring(0, si);
        if ("Basic".equalsIgnoreCase(scheme)) {
            Properties params = this.parseAuthParams(challenge.substring(si + 1));
            String realm = params.getProperty("realm");
            Credentials creds = this.authenticator.getCredentials(realm, attempts);
            String userPass = String.valueOf(creds.getUsername()) + ':' + creds.getPassword();
            byte[] b_userPass = userPass.getBytes("US-ASCII");
            byte[] b_encoded = Base64.encode(b_userPass).getBytes("US-ASCII");
            String authorization = String.valueOf(scheme) + " " + new String(b_encoded, "US-ASCII");
            this.setHeader("Authorization", authorization);
            return true;
        }
        if ("Digest".equalsIgnoreCase(scheme)) {
            Properties params = this.parseAuthParams(challenge.substring(si + 1));
            String realm = params.getProperty("realm");
            String nonce = params.getProperty("nonce");
            String qop = params.getProperty("qop");
            String algorithm = params.getProperty("algorithm");
            String digestUri = this.getRequestURI();
            Credentials creds = this.authenticator.getCredentials(realm, attempts);
            String username = creds.getUsername();
            String password = creds.getPassword();
            this.connection.incrementNonce(nonce);
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                byte[] COLON = new byte[]{58};
                md5.reset();
                md5.update(username.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(realm.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(password.getBytes("US-ASCII"));
                byte[] ha1 = md5.digest();
                if ("md5-sess".equals(algorithm)) {
                    byte[] cnonce = this.generateNonce();
                    md5.reset();
                    md5.update(ha1);
                    md5.update(COLON);
                    md5.update(nonce.getBytes("US-ASCII"));
                    md5.update(COLON);
                    md5.update(cnonce);
                    ha1 = md5.digest();
                }
                String ha1Hex = this.toHexString(ha1);
                md5.reset();
                md5.update(this.method.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(digestUri.getBytes("US-ASCII"));
                if ("auth-int".equals(qop)) {
                    byte[] hEntity = null;
                    md5.update(COLON);
                    md5.update(hEntity);
                }
                byte[] ha2 = md5.digest();
                String ha2Hex = this.toHexString(ha2);
                md5.reset();
                md5.update(ha1Hex.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(nonce.getBytes("US-ASCII"));
                if ("auth".equals(qop) || "auth-int".equals(qop)) {
                    String nc = this.getNonceCount(nonce);
                    byte[] cnonce = this.generateNonce();
                    md5.update(COLON);
                    md5.update(nc.getBytes("US-ASCII"));
                    md5.update(COLON);
                    md5.update(cnonce);
                    md5.update(COLON);
                    md5.update(qop.getBytes("US-ASCII"));
                }
                md5.update(COLON);
                md5.update(ha2Hex.getBytes("US-ASCII"));
                String digestResponse = this.toHexString(md5.digest());
                String authorization = String.valueOf(scheme) + " username=\"" + username + "\"" + " realm=\"" + realm + "\"" + " nonce=\"" + nonce + "\"" + " uri=\"" + digestUri + "\"" + " response=\"" + digestResponse + "\"";
                this.setHeader("Authorization", authorization);
                return true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
        }
        return false;
    }

    Properties parseAuthParams(String text) {
        int len = text.length();
        String key = null;
        StringBuilder buf = new StringBuilder();
        Properties ret = new Properties();
        boolean inQuote = false;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
            } else if (c == '=' && key == null) {
                key = buf.toString().trim();
                buf.setLength(0);
            } else if (c == ' ' && !inQuote) {
                String value = this.unquote(buf.toString().trim());
                ret.put(key, value);
                key = null;
                buf.setLength(0);
            } else if (c != ',' || i < len - 1 && text.charAt(i + 1) != ' ') {
                buf.append(c);
            }
            ++i;
        }
        if (key != null) {
            String value = this.unquote(buf.toString().trim());
            ret.put(key, value);
        }
        return ret;
    }

    String unquote(String text) {
        int len = text.length();
        if (len > 0 && text.charAt(0) == '\"' && text.charAt(len - 1) == '\"') {
            return text.substring(1, len - 1);
        }
        return text;
    }

    String getNonceCount(String nonce) {
        int nc = this.connection.getNonceCount(nonce);
        String hex = Integer.toHexString(nc);
        StringBuilder buf = new StringBuilder();
        int i = 8 - hex.length();
        while (i > 0) {
            buf.append('0');
            --i;
        }
        buf.append(hex);
        return buf.toString();
    }

    byte[] generateNonce() throws IOException, NoSuchAlgorithmException {
        if (this.nonce == null) {
            long time = System.currentTimeMillis();
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(Long.toString(time).getBytes("US-ASCII"));
            this.nonce = md5.digest();
        }
        return this.nonce;
    }

    String toHexString(byte[] bytes) {
        char[] ret = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            int c = bytes[i];
            if (c < 0) {
                c += 256;
            }
            ret[j++] = Character.forDigit(c / 16, 16);
            ret[j++] = Character.forDigit(c % 16, 16);
            ++i;
        }
        return new String(ret);
    }

    void handleSetCookie(String text) {
        CookieManager cookieManager = this.connection.getCookieManager();
        if (cookieManager == null) {
            return;
        }
        String name = null;
        String value = null;
        String comment = null;
        String domain = this.connection.getHostName();
        String path = this.path;
        int lsi = path.lastIndexOf(47);
        if (lsi != -1) {
            path = path.substring(0, lsi);
        }
        boolean secure = false;
        Date expires = null;
        int len = text.length();
        String attr = null;
        StringBuilder buf = new StringBuilder();
        boolean inQuote = false;
        int i = 0;
        while (i <= len) {
            block29: {
                char c;
                char c2 = c = i == len ? (char)'\u0000' : text.charAt(i);
                if (c == '\"') {
                    inQuote = !inQuote;
                } else if (!inQuote) {
                    if (c == '=' && attr == null) {
                        attr = buf.toString().trim();
                        buf.setLength(0);
                    } else if (c == ';' || i == len || c == ',') {
                        String val = this.unquote(buf.toString().trim());
                        if (name == null) {
                            name = attr;
                            value = val;
                        } else if ("Comment".equalsIgnoreCase(attr)) {
                            comment = val;
                        } else if ("Domain".equalsIgnoreCase(attr)) {
                            domain = val;
                        } else if ("Path".equalsIgnoreCase(attr)) {
                            path = val;
                        } else if ("Secure".equalsIgnoreCase(val)) {
                            secure = true;
                        } else if ("Max-Age".equalsIgnoreCase(attr)) {
                            int delta = Integer.parseInt(val);
                            Calendar cal = Calendar.getInstance();
                            cal.setTimeInMillis(System.currentTimeMillis());
                            cal.add(13, delta);
                            expires = cal.getTime();
                        } else if ("Expires".equalsIgnoreCase(attr)) {
                            HTTPDateFormat dateFormat = new HTTPDateFormat();
                            try {
                                expires = dateFormat.parse(val);
                            }
                            catch (ParseException parseException) {
                                buf.append(c);
                                break block29;
                            }
                        }
                        attr = null;
                        buf.setLength(0);
                        if (i == len || c == ',') {
                            Cookie cookie = new Cookie(name, value, comment, domain, path, secure, expires);
                            cookieManager.setCookie(cookie);
                        }
                        if (c == ',') {
                            name = null;
                            value = null;
                            comment = null;
                            domain = this.connection.getHostName();
                            path = this.path;
                            if (lsi != -1) {
                                path = path.substring(0, lsi);
                            }
                            secure = false;
                            expires = null;
                        }
                    } else {
                        buf.append(c);
                    }
                } else {
                    buf.append(c);
                }
            }
            ++i;
        }
    }
}

