/* vim: set shiftwidth=4 tabstop=8 softtabstop=4: */
/* $Id: sptprivate.h,v 1.21 2003/12/12 07:41:57 shinra Exp $ */

#ifndef SPTPRIVATE_H
#define SPTPRIVATE_H

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include "instpath.h"
#define SPT_USE_SOCKET
#define USE_MEMORY_DEBUG

#define UTMP_TYPE_NONE 0
#define UTMP_TYPE_BSD 1
#define UTMP_TYPE_SYSV 2
#define LASTLOG_TYPE_NONE 0
#define LASTLOG_TYPE_FILE 1
#define LASTLOG_TYPE_DIR 2

#if defined(lint) || defined(MAKEDEPEND)
# define NOCOMPILE
#endif

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__) \
    || defined(__APPLE__)
# define UTMP_TYPE UTMP_TYPE_BSD
#elif defined(HAVE_SETUTXENT) && defined(HAVE_UTMPX_H) && !defined(linux)
# define UTMP_TYPE UTMP_TYPE_SYSV
# define HAVE_UTMPX
#elif defined(HAVE_SETUTENT) && defined(HAVE_UTMP_H)
# define UTMP_TYPE UTMP_TYPE_SYSV
#else
# define UTMP_TYPE UTMP_TYPE_NONE
#endif

#if LASTLOG_TYPE != LASTLOG_TYPE_NONE && UTMP_TYPE == UTMP_TYPE_NONE \
    && !defined(NOCOMPILE)
# warn "lastlog support needs utmp support"
# define LASTLOG_TYPE LASTLOG_TYPE_NONE
#endif
#ifdef _PATH_LASTLOG
# undef CONF_LASTLOG_PATH
# define CONF_LASTLOG_PATH _PATH_LASTLOG
#endif

#if !defined(HAVE_PTY_SVR4) && !defined(HAVE_PTY_BSD) \
    && !defined(HAVE_PTY_PTC) && !defined(HAVE_PTY_CLONE) \
    && !defined(HAVE_PTY_SGI4) && !defined(HAVE_PTY_NUMERIC) \
    && !defined(HAVE_PTY_CYGWIN) && !defined(HAVE_PTY_CRAY) \
    && !defined(NOCOMPILE)
# error "none of pty types are detected"
#endif

/*
 * These feature test macros are more harmful than useful, especially
 * with autoconf. They hide even useful features such as updwtmpx()!
 * Why don't they distinguish *strict comformance* and *upward compatibility*?
 * Why aren't there both _XOPEN_SOURCE and _STRICT_XOPEN_SOURCE?
 */
#if 0
/* struct timespec and others */
#define _POSIX_C_SOURCE 199506L
/*
 * Some versions of FreeBSD fails to declare nanosleep() when
 * _POSIX_C_SOUCE is defined. This is a workaround for it.
 */
#ifdef __FreeBSD__
# include <osreldate.h>
# if __FreeBSD_version__ < 500000
#  include <sys/_posix.h>
#  define _P1003_1B_VISIBLE_HISTORICALLY
# endif
#endif

#ifdef HAVE_PTY_SVR4
/* grantpt,unlockpt,ptsname */
#define _XOPEN_SOURCE 500
#endif

/* rpc caddr_t, qaddr_t (not _BSD_SOURCE to avoid __FAVOR_BSD) */
#define _GNU_SOURCE
#endif

/*
 * However linux hides some necessary featurs such as caddr_t(for xdr),
 * grantpt/unlockpt/ptsname() without _GNU_SOURCE.
 * Not _XOPEN_SOURCE + _BSD_SOURCE because some POSIX features are overridden
 * by incompatible BSD functions if _BSD_SOURCE is defined.
 */
#ifdef linux
# define _GNU_SOURCE
#endif

#include <sys/types.h>
#include "cfuncs.h"
#include "libspt.h"
#include "sptint.h"
#include "sptconn.h"

#ifdef STDC_HEADERS
# include <string.h>
#else
char *STRCHR();
char *STRRCHR();
#endif
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#include <stdlib.h>
#include <assert.h>

#include <unistd.h>
#include <fcntl.h>
#include <sys/uio.h>
#include <errno.h>

#ifdef SPT_USE_SOCKET
# ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
# endif
# ifdef HAVE_SOCKLEN_T
typedef socklen_t spt_socklen_t;
# else
typedef int spt_socklen_t;
# endif
#endif

/* internal errors */
enum {
    SPT_IE_AGAIN = 10000,
    SPT_IE_PEERDEAD,
    SPT_IE_VIOLATION,
    SPT_IE_INVAL_PTY,
};

#define PTY_NAME_MAX 64
#define AGENT_MASTER_FD 3
#define AGENT_CONN_FD 4
#define QUOTE(x) #x
#define EVALQUOTE(x) QUOTE(x)
/* #define AGENT_BASENAME "sptagent" EVALQUOTE(SPT_PROTO_VERSION) */
#define AGENT_BASENAME "sptagent"
#define AGENT_PATH LIBEXEC_DIR "/" AGENT_BASENAME

#ifdef USE_DEBUG
# define DEBUG(x) x
#else
# define DEBUG(x)
#endif

extern int spt_set_agent_path(const char *path);
#endif /* SPTPRIVATE_H */
