// Q's C++ Library
// Copyright (c) 1996-1999 Hisashi HORIKAWA. All rights reserved.

#ifndef QSLIB_URI
#define QSLIB_URI

#include <string>
using namespace std;

//////////////////////////////////////////////////////////////////////
// URI

class URI
    // java.net.URL
    // RFC 2396 "Uniform Resource Identifiers (URI): Generic Syntax"
    //      URI = ( URI | URI ) [ "#" fragment ]
    //      generic URI = [ scheme ":" ] [ "//" authority ] path [ "?" query ]
    //      authority = [ userinfo "@" ] host [ ":" port ]
{
    string scheme, authority, path, query, fragment;
public:
    URI();
    URI(const URI& a);
    URI(const string& a);
    URI(const char* a);
    virtual ~URI();

    URI& operator = (const URI& a);

    string getScheme() const;
    string getAuthority() const;
    string getUserInfo() const;
    string getHost() const;
    int getPort() const;
    string getPath() const;
    string getQuery() const;
    string getFragment() const;
    void setFragment(const char* );

    URI resolve(const URI& ref) const;
        // URIβ
    string getRelative(const URI& base) const;
        // baseȤURIѴ
        // URI֤ʤȤ
    bool isDescendantOf(const URI& ) const;

    static string escape(const char* uri);
    static string unescape(const char* escaped_uri);

    string toLocal() const;
        // VFAT FS¸Ǥ褦URIʸ򥨥פ롣
        // "://" -> "$\\"
    string toString() const;

    static int compare(const URI& x, const URI& y);
    bool operator == (const URI& a) const;
    bool operator != (const URI& a) const;
    bool operator < (const URI& a) const;
private:
    int parse(const char* str);
};

//////////////////////////////////////////////////////////////////////
// FileName

class FileName
    // java.io.File
    //      filename = [ '//' host ] path file
    //      dir = ... '/'
    //      file = body [ '.' ext ]
    //      '.'ǻϤޤե̾ϡΤbodyȤư
{
    string host, dir, file;
public:
    FileName();
    FileName(const FileName& a);
    FileName(const string& a);
    FileName(const char* a);
    // FileName(const string& h, const string& p, const string& f);
    virtual ~FileName();

    FileName& operator = (const FileName& a);

    string getHost() const;
    string getPath() const; // ɬ'/'ǽ롣ɥ饤̾ޤ
        // URI::getPath()ϥե̾ޤबϴޤޤʤȤ
    string getFile() const;

    string getPath2() const;
    string getFile2() const;
        // "/hogehoge/"ΤȤ
        //      getPath() = "/hogehoge/", getFile() = ""
        //      getPath2() = "/", getFile2() = "hogehoge"   '/'դʤ

    string getBody() const;
    string getExt(bool normalize) const;
        // normalize = true -> ĥҤʸ֤

    FileName resolve(const FileName& ref) const;
    string getRelative(const FileName& base) const;
        // *thisbaseƱեλ""֤
    bool isDescendantOf(const FileName& ) const;

    string toString() const;

    static string escapeFile(const char* str);
        // ʸ'/', ':'򥨥פơե̾ȤƻȤ褦ˤ롣
    static string escapePath(const char* str);
        // ʸ':'򥨥פ롣'/'ϥפ
        // δؿͤȤäƿؤΥեǤ롣

    bool operator == (const FileName& a) const;
    bool operator < (const FileName& a) const;

private:
    int parse(const char* str);
};

#ifdef WIN32
extern off_t qGetFileSize(const char* filename);
extern bool isExistFile(const char* filename);
extern bool isDirectory(const char* filename);
#endif

#endif
