.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XDrawPoint __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XDrawPoint, XDrawPoints, XPoint \- draw points and points structure
.SH SYNTAX
.HP
int XDrawPoint\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^); 
.HP
int XDrawPoints\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, XPoint *\fIpoints\fP\^, int \fInpoints\fP\^, int \fImode\fP\^); 
.SH ARGUMENTS
.IP \fId\fP 1i
Specifies the drawable. 
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fImode\fP 1i
Specifies the coordinate mode. 
You can pass
.ZN CoordModeOrigin
or
.ZN CoordModePrevious .
.IP \fInpoints\fP 1i
Specifies the number of points in the array.
.IP \fIpoints\fP 1i
Specifies an array of points.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates where you want the point drawn.
.SH DESCRIPTION
The
.ZN XDrawPoint
function uses the foreground pixel and function components of the
GC to draw a single point into the specified drawable; 
.ZN XDrawPoints
draws multiple points this way.
.ZN CoordModeOrigin
treats all coordinates as relative to the origin,
and
.ZN CoordModePrevious
treats all coordinates after the first as relative to the previous point.
.ZN XDrawPoints
draws the points in the order listed in the array.
.LP
Both functions use these GC components: function, plane-mask,
foreground, subwindow-mode, clip-x-origin, clip-y-origin, and clip-mask.
.LP
.ZN XDrawPoint
can generate
.ZN BadDrawable ,
.ZN BadGC ,
and 
.ZN BadMatch 
errors.
.ZN XDrawPoints
can generate
.ZN BadDrawable ,
.ZN BadGC ,
.ZN BadMatch ,
and
.ZN BadValue 
errors.
.SH STRUCTURES
The
.ZN XPoint
structure contains:
.LP
.Ds 0
typedef struct {
        short x, y;
} XPoint;
.De
.LP
All x and y members are signed integers.
The width and height members are 16-bit unsigned integers.
You should be careful not to generate coordinates and sizes
out of the 16-bit ranges, because the protocol only has 16-bit fields
for these values.
.SH DIAGNOSTICS
.TP 1i
.ZN BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.ZN BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XDrawArc(__libmansuffix__),
XDrawLine(__libmansuffix__),
XDrawRectangle(__libmansuffix__)
.br
\fI\*(xL\fP
