/*
 * IBM Smart Capture Card driver.
 *
 * Copyright (c) 1996,1997
 *	 Koji OKAMURA and Takeshi OHASHI.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Koji OKAMURA
 *	and Takeshi OHASHI.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI OKAMURA, TAKESHI OHASHI AND
 * CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TAKESHI OHASHI OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Changed by Koji OKAMURA <oka@kobe-u.ac.jp>
 * Changed by Takeshi OHASHI <ohashi@mickey.ai.kyutech.ac.jp>
 * Version 0.40, Sep 28, 1997.
 *
 */

typedef struct iscc_geomet {
  int  width;   
  int  height;   
} iscc_geomet_t ;

typedef struct iscc_color {
  int brightness;
  int contrast;
  int saturation;
  int hue;
} iscc_color_t ;

typedef struct iscc_tv {
  int tuntype;
  int channel;
  int fine;
  int country;
} iscc_tv_t ;

typedef struct iscc_card {
  int             mode;
  iscc_geomet_t    geomet;
  int             format;
  int             spdmode;
  iscc_tv_t        tv;
  iscc_color_t     color;
  int             intput;
} iscc_card_t;

#define ISCCSETMODE		_IOW('s', 1, int)
#define ISCCGETMODE		_IOR('s', 2, int)
#define ISCCSETGEO		_IOW('s', 3, iscc_geomet_t)
#define ISCCGETGEO		_IOR('s', 4, iscc_geomet_t)
#define ISCCSETFMT		_IOW('s', 5, int)
#define ISCCGETFMT		_IOR('s', 6, int)
#define ISCCSETSPDMODE		_IOW('s', 7, int)
#define ISCCGETSPDMODE		_IOR('s', 8, int)
#define ISCCSETTVCHANNEL	_IOW('s', 9, iscc_tv_t)
#define ISCCGETTVCHANNEL	_IOR('s',10, iscc_tv_t)
#define ISCCSETCOLOR		_IOW('s',11, iscc_color_t)
#define ISCCGETCOLOR		_IOR('s',12, iscc_color_t)
#define ISCCCAPTURE		_IOW('s',13, int)

#define ISCC_PAL   0
#define ISCC_NTSC  1

#define ISCC_NTSCWIDTH  640
#define ISCC_NTSCHEIGHT 240
#define ISCC_PALWIDTH   768
#define ISCC_PALHEIGHT  288

#define	ISCC_YUV422		0
#define	ISCC_YUV444		1
#define	ISCC_YUV411		2
#define	ISCC_YUVDPCM		3
#define	ISCC_RGB888N		4
#define	ISCC_RGB888		5
#define	ISCC_RGB565		6
#define	ISCC_RGB555		7

#define ISCC_SLOW 1
#define ISCC_FAST 0

#define	ISCC_DEFBRIGHTNESS	 150
#define	ISCC_DEFCONTRAST	          40
#define	ISCC_DEFSATURATION	2800
#define	ISCC_DEFHUE		2048

#define ISCC_MAXBRIGHTNESS        255
#define ISCC_MAXCONTRAST           63
#define ISCC_MAXSATURATION       4095
#define ISCC_MAXHUE              4095

#define ISCC_MINCHANNELJP           1
#define ISCC_MAXCHANNELJP          62
#define ISCC_MINCHANNELUS           2
#define ISCC_MAXCHANNELUS          69
