/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include "test_string.h"

static boolean wcwidth_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcswidth_test ( answer *, wc_answer *, boolean, boolean );
static boolean strcat_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcscat_test ( answer *, wc_answer *, boolean, boolean );
static boolean strncat_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcsncat_test ( answer *, wc_answer *, boolean, boolean );
static boolean strchr_test ( answer *, wc_answer *, boolean, boolean );
static boolean strrchr_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcschr_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcsrchr_test ( answer *, wc_answer *, boolean, boolean );
static boolean strcmp_test ( answer *, wc_answer *, boolean, boolean );
static boolean strncmp_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcscmp_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcsncmp_test ( answer *, wc_answer *, boolean, boolean );
static boolean strspn_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcsspn_test ( answer *, wc_answer *, boolean, boolean );
static boolean strcspn_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcscspn_test ( answer *, wc_answer *, boolean, boolean );
static boolean strstr_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcswcs_test ( answer *, wc_answer *, boolean, boolean );
static boolean strpbrk_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcspbrk_test ( answer *, wc_answer *, boolean, boolean );
//static boolean strtok_test ( answer *, wc_answer *, boolean, boolean );
//static boolean strtok_r_test ( answer *, wc_answer *, boolean, boolean );
static boolean wcstok_test ( answer *, wc_answer *, boolean, boolean );

void
api_table_create ( const api_table *tp )
{
  api_table_add (tp, "wcwidth", wcwidth_test);
  api_table_add (tp, "wcswidth", wcswidth_test);
  api_table_add (tp, "strcat", strcat_test);
  api_table_add (tp, "wcscat", wcscat_test);
  api_table_add (tp, "strncat", strncat_test);
  api_table_add (tp, "wcsncat", wcsncat_test);
  api_table_add (tp, "strchr", strchr_test);
  api_table_add (tp, "strrchr", strrchr_test);
  api_table_add (tp, "wcschr", wcschr_test);
  api_table_add (tp, "wcsrchr", wcsrchr_test);
  api_table_add (tp, "strcmp", strcmp_test);
  api_table_add (tp, "strncmp", strncmp_test);
  api_table_add (tp, "wcscmp", wcscmp_test);
  api_table_add (tp, "wcsncmp", wcsncmp_test);
  api_table_add (tp, "strspn", strspn_test);
  api_table_add (tp, "wcsspn", wcsspn_test);
  api_table_add (tp, "strcspn", strcspn_test);
  api_table_add (tp, "wcscspn", wcscspn_test);
  api_table_add (tp, "strstr", strstr_test);
  api_table_add (tp, "wcswcs", wcswcs_test);
  api_table_add (tp, "wcsstr", wcswcs_test);
  api_table_add (tp, "strpbrk", strpbrk_test);
  api_table_add (tp, "wcspbrk", wcspbrk_test);
  //  api_table_add (tp, "strtok", strtok_test);
  //  api_table_add (tp, "strtok_r", strtok_r_test);
  api_table_add (tp, "wcstok", wcstok_test);
}

/**********************************************************************
*                                                                     *
* int test_apis( answer ans )                                         *
*                                                                     *
***********************************************************************/

/*
 * TEST: int  wcwidth ( wint_t wc )
 */

static boolean
wcwidth_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s)", ansp->api_name, ansp->param[0]);

  retval = wcwidth (wc_ansp->param[0][0]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int  wcswidth ( const wchar_t *pwcs, size_t n )
 */

static boolean
wcswidth_test ( answer * ansp,
		wc_answer * wc_ansp,
		boolean genans_flag,
		boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%d)", ansp->api_name, ansp->param[0],
	   atoi (ansp->param[1]));

  retval = wcswidth (wc_ansp->param[0], atoi (ansp->param[1]));
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: char * strcat ( char *ws1, const char *ws2 )
 */

static boolean
strcat_test (answer * ansp, wc_answer * wc_ansp,
	   boolean genans_flag, boolean verbose_flag)
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  tmpsize = stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + padding;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  stringcpy (result_string, ansp->param[0]);
  strcat (result_string, ansp->param[1]);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: wchar_t * wcscat (wchar_t *ws1, const wchar_t *ws2)
 */

static boolean
wcscat_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  tmpsize = wstringlen (wc_ansp->param[0]) + wstringlen (wc_ansp->param[1]) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, wc_ansp->param[0]);
  wcscat (result_wstring, wc_ansp->param[1]);

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: char * strncat ( char *ws1, const char *ws2, size_t n )
 */

static boolean
strncat_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1], ansp->param[2]);

  tmpsize = stringlen (ansp->param[0]) + atoi (ansp->param[2]) + padding;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  stringcpy (result_string, ansp->param[0]);
  strncat (result_string, ansp->param[1], atoi (ansp->param[2]));

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

  /*
   * TEST: wchar_t * wcsncat ( wchar_t *ws1, const wchar_t *ws2, size_t n)
   */

static boolean
wcsncat_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s, %s)", ansp->api_name, ansp->param[0],
	   ansp->param[1], ansp->param[2]);

  tmpsize = wstringlen (wc_ansp->param[0]) + atoi (ansp->param[2]) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, wc_ansp->param[0]);
  wcsncat (result_wstring, wc_ansp->param[1], atoi (ansp->param[2]));

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: char * strchr ( const char *ws, int wc )
 */

static boolean
strchr_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  char *retp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%c)", ansp->api_name, ansp->param[0],
	   ansp->param[1][0]);

  retp = strchr (ansp->param[0], ansp->param[1][0]);
  if (retp == NULL)
    {
      retp = "NULL" ;
    }

  tmpsize = stringlen (retp) + padding;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  stringcpy (result_string, retp);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: wchar_t * wcschr (const wchar_t *ws, wint_t wc)
 */

static boolean
wcschr_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  wchar_t *retwp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  retwp = wcschr (wc_ansp->param[0], wc_ansp->param[1][0]);
  if (retwp == NULL)
    {
      retwp = L"NULL";
    }

  tmpsize = wstringlen (retwp) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, retwp);

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: char * strrchr (const char *ws, int c )
 */

static boolean
strrchr_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  char *retp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%c)", ansp->api_name, ansp->param[0],
	   ansp->param[1][0]);
  retp = strrchr (ansp->param[0], ansp->param[1][0]);
  if (retp == NULL)
    {
      retp = "NULL";
    }

  tmpsize = stringlen (retp) + padding;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  stringcpy (result_string, retp);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: wchar_t * wcsrchr ( const wchar_t *ws, wint_t wc)
 */

static boolean
wcsrchr_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  wchar_t *retwp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  retwp = wcsrchr (wc_ansp->param[0], wc_ansp->param[1][0]);
  if (retwp == NULL)
    {
      retwp = L"NULL";
    }

  tmpsize = wstringlen (retwp) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, retwp);

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int strcmp ( const char *ws1, const char *ws2 )
 */

static boolean
strcmp_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = strcmp (ansp->param[0], ansp->param[1]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  if (stringeq (result_string, "0") == stringeq (ansp->result, "0"))
    {
      result = true;
    }
  else
    {
      result = false;
    }

  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int wcscmp (const wchar_t *ws1, const wchar_t *ws2 )
 */

static boolean
wcscmp_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = wcscmp (wc_ansp->param[0], wc_ansp->param[1]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  if (stringeq (result_string, "0") == stringeq (ansp->result, "0"))
    {
      result = true;
    }
  else
    {
      result = false;
    }

  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int  strncmp ( const char *ws1, const char *ws2, size_t n )
 */

static boolean
strncmp_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1], ansp->param[2]);

  retval = strncmp (ansp->param[0], ansp->param[1], atoi (ansp->param[2]));
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  if (stringeq (result_string, "0") == stringeq (ansp->result, "0"))
    {
      result = true;
    }
  else
    {
      result = false;
    }

  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: int  wcsncmp ( const wchar_t *ws1, const wchar_t *ws2, size_t n )
 */

static boolean
wcsncmp_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1], ansp->param[2]);

  retval = wcsncmp (wc_ansp->param[0], wc_ansp->param[1], atoi (ansp->param[2]));
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  if (stringeq (result_string, "0") == stringeq (ansp->result, "0"))
    {
      result = true;
    }
  else
    {
      result = false;
    }

  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: size_t  strcspn (const char *ws1, const char *ws2)
 */

static boolean
strcspn_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = strcspn (ansp->param[0], ansp->param[1]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: size_t  wcscspn ( const wchar_t *ws1, const wchar_t *ws2)
 */

static boolean
wcscspn_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = wcscspn (wc_ansp->param[0], wc_ansp->param[1]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST:  char * strpbrk ( const char *ws1, const char *ws2 )
 */

static boolean
strpbrk_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  char *retp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  retp = strpbrk (ansp->param[0], ansp->param[1]);
  if (retp == NULL)
    {
      retp = "NULL";
    }

  tmpsize = stringlen (retp) + padding;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  stringcpy (result_string, retp);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST:  wchar_t * wcspbrk ( const wchar_t *ws1, const wchar_t *ws2 )
 */

static boolean
wcspbrk_test ( answer * ansp,
	       wc_answer * wc_ansp,
	       boolean genans_flag,
	       boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  wchar_t *retwp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  retwp = wcspbrk (wc_ansp->param[0], wc_ansp->param[1]);
  if (retwp == NULL)
    {
      retwp = L"NULL";
    }

  tmpsize = wstringlen (retwp) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, retwp);

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: size_t strspn ( const char *ws1, const char *ws2 )
 */

static boolean
strspn_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = strspn (ansp->param[0], ansp->param[1]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: size_t wcsspn ( const wchar_t *ws1, const wchar_t *ws2 )
 */

static boolean
wcsspn_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  size_t tmpsize;
  size_t padding = 5;
  int retval;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);

  retval = wcsspn (wc_ansp->param[0], wc_ansp->param[1]);
  tmpsize = count_digit (retval) + 1;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  sprintf (result_string, "%d", retval);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: char * strstr ( const char *ws1, const char *ws2 )
 */

static boolean
strstr_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  boolean result;
  char *retp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  retp = strstr (ansp->param[0], ansp->param[1]);
  if (retp == NULL)
    {
      retp = "NULL";
    }

  tmpsize = stringlen (retp) + padding;
  result_string = (char *) mem_calloc (tmpsize, sizeof (char));
  stringcpy (result_string, retp);

  result = stringeq (result_string, ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: wchar_t * wcswcs ( const wchar_t *ws1, const wchar_t *ws2 )
 * TEST: wchar_t * wcsstr ( const wchar_t *ws1, const wchar_t *ws2 )
 */

static boolean
wcswcs_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  wchar_t *retwp;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  retwp = wcsstr (wc_ansp->param[0], wc_ansp->param[1]);
  if (retwp == NULL)
    {
      retwp = L"NULL";
    }

  tmpsize = wstringlen (retwp) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, retwp);

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}

/*
 * TEST: wchar_t * wcstok ( wchar_t *ws1, const wchar_t *ws2, wchar_t **ptr )
 */
/* under construction */

static boolean
wcstok_test ( answer * ansp,
	      wc_answer * wc_ansp,
	      boolean genans_flag,
	      boolean verbose_flag )
{
  char *test_case;
  char *result_string;
  wchar_t *result_wstring;
  boolean result;
  wchar_t *retwp;
  wchar_t *savep;
  size_t tmpsize;
  size_t padding = 5;

  tmpsize = stringlen (ansp->api_name) + stringlen (ansp->param[0]) + stringlen (ansp->param[1]) + stringlen (ansp->param[2]) + padding;
  test_case = (char *) mem_calloc (tmpsize, sizeof (char));

  sprintf (test_case, "%s(%s,%s)", ansp->api_name, ansp->param[0],
	   ansp->param[1]);
  /* first */
  retwp = wcstok (wc_ansp->param[0], wc_ansp->param[1], &savep);
  if (retwp == NULL)
    {
      retwp = L"NULL";
    }

  tmpsize = wstringlen (retwp) + padding;
  result_wstring = (wchar_t *) mem_calloc (tmpsize, sizeof (wchar_t));
  wstringcpy (result_wstring, retwp);
  wstringcat (result_wstring, L",");

  /* second */
  retwp = wcstok (NULL, wc_ansp->param[1], &savep);
  if (retwp == NULL)
    {
      retwp = L"NULL";
    }
  wstringcat (result_wstring, retwp);

  convert_wcsmbs (&result_string, result_wstring);

  result = wstringeq (result_wstring, wc_ansp->result);
  display_result (ansp, test_case, result_string, ansp->result,
		  result, genans_flag, verbose_flag);

  mem_free ((void *) result_string);
  mem_free ((void *) result_wstring);
  mem_free ((void *) test_case);

  return (result);
}
