/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <string.h>
#include <limits.h>

/**********************************************************************
*                                                                     *
*  int  xstr2ul ( char *str,char *rstr)                               *
*                                                                     *
*  Converts 2 consecutive hexadecimal numbers into unsigned long.     *
*                                                                     *
***********************************************************************/

int
xstr2ul (char *str, char *rstr)
{
  int len, j;
  char tmp[3];
  len = stringlen (str);

  tmp[2] = (char) NULL;
  for (j = 0; j < len; j += 2)
    {
      tmp[0] = str[j];
      tmp[1] = str[j + 1];
      rstr[j / 2] = (unsigned char) strtoul (tmp, NULL, 16);
    }
  rstr[j / 2] = (char) NULL;

  return (0);
}

/**********************************************************************
*                                                                     *
*  int  ul2xstr ( char *str,char *rstr)                               *
*                                                                     *
*  Converts unsigned long int to consecutive hexadecimal numbers      *
*                                                                     *
***********************************************************************/

int
ul2xstr (char *str, char *rstr)
{
  int len, i;
  char tmp[MB_LEN_MAX+1];
  char tmp2[MB_LEN_MAX+1] = "\0";
  len = stringlen (str);

  for (i = 0; i < len; i++)
    {
      sprintf (tmp, "%02X", (unsigned char) str[i]);
      stringcat (tmp2, tmp);
    }
  stringcpy (rstr, tmp2);

  return (0);
}
