/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include "glibctest.h"

/**********************************************************************
*                                                                     *
*  void print_format_help ( char *api_name )                          *
*                                                                     *
***********************************************************************/

int
print_format_help (char *api_name)
{
  int i, j, tmp, idx;
  int count = 0;
  int found = 0;
  char *api;
  char *bufp;

  for (i = 0; apilist[i].api[0] != '\0'; i++)
    {
      bufp = apilist[i].api;
      idx = 0;
      while (*(bufp+idx) != ' ')
	{
	  idx++;
	}
      api = (char *) mem_calloc (idx + 1, sizeof (char));
      for (j=0; j < idx ; j++)
        {
          api[j] = bufp[j];
        }
      api[j] = (char) NULL;
      if (stringeqn (api, api_name, stringlen (api_name)))
	{
	  found = i;
	  count++;
	}
      mem_free ((void *) api);
    }

  if (count == 1)
    {
      fprintf (stderr, "help: %s\n", apilist[found].api);
      return (EMPTYLINE);
    }
  else if (count > 1)
    {
      fprintf (stderr, OOPSSTR);
      fprintf (stderr, " Ambiguous: %s\n", api_name);
      return (EMPTYLINE);
    }
  else
    {				/* count == 0 */
      /* Unknown API */
      fprintf (stderr, OOPSSTR);
      fprintf (stderr, " %s: unknown API or cannot test this.\n", api_name);
      return (INSUFFICIENTLINE);
    }
}
