/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>

/****************************************************************
 *                                                              *
 * void * mem_alloc ( int n )                                   *
 *                                                              *
 * @arg  int     n ; size of requiared memory                   *
 *                                                              *
 * @return pointer of void                                      *
 *                                                              *
 ****************************************************************/

void *
mem_alloc ( size_t n )
{
  void *p;

  p = calloc (1,n);

  if (p)
    {
      return (p);
    }
  else
    {
      perror ("Error: malloc");
      exit (1);
    }
}

void *
mem_calloc ( size_t nmemb, size_t size )
{
  void *p;

  p = calloc (nmemb, size);

  if (p)
    {
      return (p);
    }
  else
    {
      perror ("Error: calloc");
      exit (1);
    }
}
