/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "indexedlist.h"

indexedlist *
indexedlist_init ( const int total_num,
		   void (*data_display) ( void * ),
		   void (*data_free) ( void * ) )
{
  int i;
  indexedlist *list;

  list = (indexedlist *) malloc (sizeof (indexedlist));
  list->total_num = total_num;
  list->listp =
    (indexedlist_data *) mem_alloc (list->total_num *
				   sizeof (indexedlist_data));
  list->data_display = data_display;
  list->data_free = data_free;

  for (i = 0; i < list->total_num; i++)
    {
      list->listp[i].datap = (void *) NULL;
    }

  return (list);
}

void
indexedlist_add ( const indexedlist * list, const int idx, void *datap)
{
  list->listp[idx].datap = datap;
}

void *
indexedlist_search ( const indexedlist * list, const int idx )
{
  return (list->listp[idx].datap);
}

void
indexedlist_free ( indexedlist * list )
{
  int i;

  for (i = 0; i < list->total_num; i++)
    {
      if (list->data_free)
	{
	  list->data_free (list->listp[i].datap);
	}
      free (list->listp[i].datap);
    }

  free (list->listp);
  free (list);
}

void
indexedlist_display (const indexedlist * list)
{
  int i;

  for (i = 0; i < list->total_num; i++)
    {
      printf ("%d ", i);
      list->data_display (list->listp[i].datap);
      printf ("\n");
    }
}

int
indexedlist_get_total_num ( const indexedlist * list )
{
  return (list->total_num);
}

int
end_of_indexedlist ( const indexedlist * list, const int idx )
{
  return (idx == list->total_num ? 1 : 0);
}
