/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "glibctest.h"

char *
get_oneline ( FILE * fp, char ** bufp )
{
  char tmpline[32];
  char *tmpbufp, *tmpbufpnew, *tmpbufpold;
  size_t maxlinelen = 32;
  size_t incr_unit = 32;
  size_t len;

  /* buffline initialize */
  tmpbufp = (char *) mem_alloc (maxlinelen * sizeof (char));

  while (true)
    {
      if ( (!feof (fp)) && (!ferror (fp)) )
	{
	  fgetstr (tmpline, 32, fp);
	  len = stringlen(tmpline);
	  if ( tmpline[len-1] != '\n' )
	    {
	      tmpbufpold = tmpbufp;
	      maxlinelen += incr_unit;
	      tmpbufp = (char *) mem_alloc (maxlinelen * sizeof (char));
	      memcpy (tmpbufp, tmpbufpold, maxlinelen - incr_unit );
	      mem_free ((void *) tmpbufpold);
	      stringcat (tmpbufp, tmpline);
	    }
	  else
	    {
	      tmpline[len-1] = (char) NULL;
	      stringcat (tmpbufp, tmpline);
	      *bufp = tmpbufp;
	      return (tmpbufp);
	    }
	}
      else
	{
	  *bufp = tmpbufp;
	  return (NULL);
	}
    }

}
