/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include <stdio.h>

void
extract_realkey (char **keyp, const char *buf, const char escape_char)
{
  int i, j;
  int idx, tmp;

  idx = 0;
  while (*(buf+idx) != '<')
    idx++;

  tmp = idx++;
  while (*(buf+idx) != '>')
    {
      idx += (*(buf+idx) == escape_char) ? 2 : 1;
    }
  idx++;
  *keyp = (char *) mem_calloc (idx - tmp + 1, sizeof (char));
  for (i=tmp, j=0; i < idx; i++, j++)
    {
      *((*keyp)+j) = buf[i];
    }
  *((*keyp)+j) = (char) NULL;
}
