/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include <stdio.h>
#include <locale.h>

void
display_string ( char * string )
{
  FILE *out_fp;
  char outfilename[32];

  sprintf (outfilename, "log.%s", getenv ("LANG"));
  out_fp = fopen (outfilename, "a");

  fprintf (out_fp, "%s", string);

  fclose (out_fp);
}

void
display (char *api_name,
	 char *result_string,
	 char *expected_result,
	 boolean result, boolean genans_flag, boolean verbose_flag)
{
  int i;
  answer tmp;
  char *tmpcase;
  char *tmpsys;
  char *tmpexp;
  FILE *out_fp;
  char outfilename[32];
  
  replace_char_to_tag (&tmpsys, result_string);

  if (genans_flag)
    {
      out_fp = stdout;
      fprintf (out_fp, "%s", tmpsys);
      fprintf (out_fp, "\n");
    }
  else
    {
      sprintf (outfilename, "log.%s", getenv ("LANG"));
      out_fp = fopen (outfilename, "a");
      if (stringeq (expected_result, "NULL")
	  && stringeq (result_string, "(null)"))
	{
	  fprintf (out_fp, SUCCSTR);
	  if (verbose_flag)
	    {
	      fprintf (stderr, SUCCSTR);
	    }
	  result = true;
	}
      else
	{
	  if (result)
	    {
	      fprintf (out_fp, SUCCSTR);
	      if (verbose_flag)
		{
		  fprintf (stderr, SUCCSTR);
		}
	    }
	  else
	    {
	      fprintf (out_fp, FAILSTR);
	      if (verbose_flag)
		{
		  fprintf (stderr, FAILSTR);
		}
	    }
	}

      replace_char_to_tag (&tmpcase, api_name);
      replace_char_to_tag (&tmpexp, expected_result);

      if (result)
	{
	  fprintf (out_fp, " %s sys[%s] =  exp[%s]", tmpcase, tmpsys, tmpexp);
	  if (verbose_flag)
	    {
	      fprintf (stderr, " %s sys[%s] =  exp[%s]", tmpcase, tmpsys, tmpexp);
	    }
	}
      else
	{
	  fprintf (out_fp, " %s sys[%s] != exp[%s]", tmpcase, tmpsys, tmpexp);
	  if (verbose_flag)
	    {
	      fprintf (stderr, " %s sys[%s] != exp[%s]", tmpcase, tmpsys, tmpexp);
	    }
	}
      mem_free ((void *)tmpcase);
      mem_free ((void *)tmpexp);

      fprintf (out_fp, "\n");
      if (verbose_flag)
	{
	  fprintf (stderr, "\n");
	}
      fclose (out_fp);
    }

  mem_free ((void *)tmpsys);

}
