/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include <stdio.h>
#include "glibctest.h"
#include "hash.h"

typedef struct _api_table_item {
  apitest_t funcp;
} api_table_item;

static void
api_table_data_display ( void *ptr )
{
  printf (" addr[%x]", (apitest_t)ptr);
}

static void
api_table_data_free ( void *ptr )
{
  return;
}

api_table *
api_table_init ( const int num )
{
  api_table *tp;

  tp = (api_table *) mem_alloc (sizeof (api_table));
  tp->tablep = hashtable_init (num, api_table_data_display, api_table_data_free);

  return (tp);
}

void
api_table_free ( api_table * ptr )
{
  hashtable_free (ptr->tablep);
  mem_free ((void *)ptr);
}

void
api_table_add ( const api_table *tp, const char *api_name, apitest_t funcp )
{
  api_table_item *ptr;

  ptr = (api_table_item *)mem_alloc (sizeof (api_table_item));

  ptr->funcp = funcp;
  /*  fprintf (stderr, "api: %s registered.\n", api_name); */
  hashtable_insert (tp->tablep, api_name, (void *)ptr);
}

boolean
api_table_select ( api_table *tp,
		   answer *ansp,
		   wc_answer *wc_ansp,
		   boolean genans_flag,
		   boolean verbose_flag )
{
  api_table_item *ptr;
  boolean result;

  /*  fprintf (stderr, "search start.[%s]\n", ansp->api_name); */
  ptr = (api_table_item *) hashtable_search (tp->tablep, ansp->api_name);
  /*  fprintf (stderr, "search done. [%x]\n", ptr); */

  if (ptr)
    {
      /*      fprintf (stderr, "[%s] selected.\n", ansp->api_name); */
      result = (ptr->funcp) (ansp, wc_ansp, genans_flag, verbose_flag);
    }
  else
    {
      fprintf (stderr, "select_api(%s) : No such api_name registered.\n", ansp->api_name);
      result = false;
    }

  return (result);
}
