/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "glibctest.h"
#include "test_iswc.h"
#include "charmap.h"
#include "lcctype.h"
#include "charmaphash.h"

const char *predefined_class[] = {
  "upper", "lower", "alpha", "alnum", "digit", "xdigit",
#ifdef HAVE_ISWBLANK
  "blank",
#endif
  "space", "cntrl", "punct", "graph", "print", (char *) NULL
};

const char *predefined_conv[] = {
  "toupper", "tolower", (char *) NULL
};

supported_API apilist[] = {
  {"iswupper <wchar> - - <value>",
   "test whether a wide-character belongs to class 'upper'."},
  {"iswlower <wchar> - - <value>",
   "test whether a wide-character belongs to class 'lower'."},
  {"iswalpha <wchar> - - <value>",
   "test whether a wide-character belongs to class 'alpha'."},
  {"iswdigit <wchar> - - <value>",
   "test whether a wide-character belongs to class 'digit'."},
  {"iswalnum <wchar> - - <value>",
   "test whether a wide-character belongs to class 'alpha' or 'digit'."},
  {"iswxdigit <wchar> - - <value>",
   "test whether a wide-character belongs to class 'xdigit'."},
#ifdef HAVE_ISWBLANK
  {"iswblank <wchar> - - <value>",
   "test whether a wide-character belongs to class 'blank'."},
#endif
  {"iswspace <wchar> - - <value>",
   "test whether a wide-character belongs to class 'space'."},
  {"iswcntrl <wchar> - - <value>",
   "test whether a wide-character belongs to class 'cntrl'."},
  {"iswpunct <wchar> - - <value>",
   "test whether a wide-character belongs to class 'punct' (not including space and alnum)."},
  {"iswgraph <wchar> - - <value>",
   "test whether a wide-character belongs to class 'graph' (not including space)."},
  {"iswprint <wchar> - - <value>",
   "test whether a wide-character belongs to class 'print' (including space)."},
  {"iswctype <wchar> <type> - <value>",
   "test whether a wide-character belongs to class <type>."},

  {"towupper <wchar> - - <value>",
   "convert a wide character to uppercase."},
  {"towlower <wchar> - - <value>",
   "convert a wide character to upperlower."},
  {"towctrans <wchar> <type> - <value>",
   "wide-character transliteration."},
  {"\0", "\0"}
};

int
interactive_test ( api_table *tp, params *prmp )
{
  answer *ansp;
  wc_answer *wc_ansp;
  int case_cnt = 0;
  int error_cnt = 0;
  boolean result;

  int status;
  boolean genans_local = false;

  /*
   * Main Loop
   */
  while (true)
    {
      ansp = (answer *) mem_alloc (sizeof (answer));
      wc_ansp = (wc_answer *) mem_alloc (sizeof (wc_answer));

      print_prompt (prmp);
      status = input_reader (stdin, ansp, wc_ansp, &genans_local);
      if (status == (int) NULL)
	{
          mem_free ((void *)ansp);
          mem_free ((void *)wc_ansp);
	  break;
	}
      if (status == EMPTYLINE || status == INSUFFICIENTLINE)
	{
          mem_free ((void *)ansp);
          mem_free ((void *)wc_ansp);
	  continue;
	}

      result = api_table_select (tp, ansp, wc_ansp,
                                 (genans_local || prmp->genans_global),
                                 prmp->verbose_flag);
      error_cnt += (result == false) ? 1 : 0;
      case_cnt++;

      genans_local = false;
      free_ans (ansp, wc_ansp);
    }

  result_report (case_cnt, error_cnt, "");

  return (0);

}

int
main (int argc, char *argv[])
{
  int opt = 1;
  api_table *tp;
  charmap *cmp;
  params prm;
  lc_ctype *lcp;
  charmap_hash *cmhash;

  system_info ();

  /*
   * Option Check
   */

  getparams_iswc (argc, argv, &prm);

  /*
   * API test function register
   */

  tp = api_table_init (30);
  api_table_create (tp);

  if ( prm.input_fp == stdin)
    {
      interactive_test (tp, &prm);
    }
  else
    {
      /*
       * Charmap
       */
      cmp = charmap_init (prm.ans_fp);
      fprintf (stderr, "scanned Charmap file (%d chars).\n",
	       cmp->listp->total_num);
      /* display_charmap (cmp); */

      /*
       * Convert to Hash table
       */
      cmhash = charmap_hash_init (cmp);
      fprintf (stderr, "transformed charmap into hashtable (size %d).\n",
	       cmhash->tablep->table_max);
      /*      charmap_hash_display (cmhash); */

      lcp = lc_ctype_init (prm.input_fp);
      fprintf (stderr, "created LC_CTYPE hash table.\n");
      /*      lc_ctype_display (lcp); */
  
      fprintf (stderr, "testing APIs ... ");

      test_apis_wc (tp, lcp, cmp, cmhash, prm.verbose_flag);

      charmap_free (cmp);
      charmap_hash_free (cmhash);
      lc_ctype_free (lcp);

      fprintf (stderr, "\n");
    }

  api_table_free (tp);

  return (0);
}
