/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#ifndef _LC_CTYPE_H_
#define _LC_CTYPE_H_

#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <ctype.h>
#include <wchar.h>
#include <wctype.h>
#include "hash.h"

#define SYMBOL_NOT_FOUND      100

#define TMPFILE "tmpXXX.YYY"

typedef struct _lc_ctype_char
{
  char *symbol1;
  char *symbol2;
}
lc_ctype_char;

typedef struct _lc_ctype_data
{
  char *classname;
  hashtable *hashtable;
  int conv_flag;
  int total_num;
}
lc_ctype_data;

typedef struct _lc_ctype
{
  char escape_char;
  char comment_char;
  char *repertoiremap;
  FILE *fp;
  lc_ctype_data *classp;
  char **userdefined_class;
  int userdefined_class_num;
  char **userdefined_conv;
  int userdefined_conv_num;
  int total_num;
}
lc_ctype;

extern lc_ctype * lc_ctype_init ( FILE * );
extern void file_process ( FILE * );
extern void lc_ctype_display ( lc_ctype * );
extern void lc_ctype_free ( lc_ctype * );
extern int lc_ctype_get_total_num ( lc_ctype * );
extern char * lc_ctype_search_toxxx ( const lc_ctype *, const char *, const char * );
extern boolean lc_ctype_search_wctype ( lc_ctype *, const char *, const char * );

#endif
