/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */
#include "charmaphash.h"

void
charmap_hash_resolv ( charmap_hash *cmhash, char *keysym, char *code )
{
  charmapdata *ptr;
  char *key;

  extract_realkey (&key, keysym, cmhash->escape_char);
  ptr = hashtable_search (cmhash->tablep, key);

  if (ptr == NULL)
    {
      code = (char *) NULL;
    }
  else
    {
      stringcpy (code, ptr->code);
    }
  mem_free ((void *) key);
}

charmap_hash *
charmap_hash_init ( charmap *cmp )
{
  int i;
  charmapdata *ptr, *newptr;
  char *key;
  charmap_hash *cmhash;

  cmhash = (charmap_hash *) mem_alloc (sizeof (charmap_hash));
  cmhash->tablep = hashtable_init (cmp->listp->total_num, cmp->listp->data_display, cmp->listp->data_free);
  cmhash->escape_char = cmp->escape_char;

  for (i = 0; !end_of_charmap (cmp, i); i++)
    {
      ptr = cmp->listp->listp[i].datap;
      newptr = (charmapdata *)mem_alloc(sizeof (charmapdata));
      stringpcpy (&(newptr->symbol), ptr->symbol);
      stringpcpy (&(newptr->code), ptr->code);
      extract_realkey (&key, newptr->symbol, cmp->escape_char);
      hashtable_insert (cmhash->tablep, key, newptr);
      mem_free ((void *) key);
    }

  return (cmhash);
}

void
charmap_hash_free ( charmap_hash *cmhash )
{
  hashtable_free (cmhash->tablep);
  mem_free ((void *)cmhash);
}

void
charmap_hash_display ( charmap_hash *cmhash )
{
  hashtable_display (cmhash->tablep);
}
