/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#ifndef _HASH_H_
#define _HASH_H_

#include <stdio.h>
#include <stdlib.h>

typedef struct _hashtable_data {
  char *key;
  void *datap;
  struct _hashtable_data *nextp;
} hashtable_data;

typedef struct _hashtable {
  hashtable_data *tablep;
  int total_num;
  int table_max;
  void (*data_display) ( void * );
  void (*data_free) ( void * );
} hashtable;

extern int find_prime ( int );
extern hashtable * hashtable_init ( const int, void (*) ( void * ), void (*) ( void * ) );
extern void * hashtable_search ( const hashtable *, const char * );
extern void hashtable_insert ( const hashtable *, const char *, void * );
extern void hashtable_free ( hashtable * );
extern void hashtable_data_free ( void * );
extern void hashtable_display ( const hashtable * );
extern void hashtable_data_display ( const void * );
extern int end_of_hashtable ( const hashtable *, const int );

#endif
