/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#ifndef _CHARMAP_H_
#define _CHARMAP_H_

#include <limits.h>
#ifndef _STDIO_H
#include <stdio.h>
#endif
#include <stdlib.h>
#include "indexedlist.h"

#define CHARMAP_IDX_ERROR 100

typedef struct _charmap_data {
  char *symbol;
  char *code;
} charmapdata;

typedef struct _charmap {
  char *code_set_name;
  char escape_char;
  char comment_char;
  int mb_cur_min;
  int mb_cur_max;
  FILE *fp;
  indexedlist *listp;
} charmap;

/* extern charmap * charmap_init ( const char * ); */
extern charmap * charmap_init ( FILE * );
extern void charmap_free ( charmap * );
extern void charmap_display ( charmap * );
extern int charmap_get_data ( const charmap *, const int, char **, char ** );
extern int charmap_get_mb_cur_max ( const charmap * );
extern int charmap_get_total_num ( const charmap * );
extern char charmap_get_escape_char ( const charmap * );
extern char charmap_get_comment_char ( const charmap * );

#endif
