/*
 *
 * This software is subject to the terms of the IBM Public License.
 * You must accept the terms of this license to use this software.
 *
 *  Copyright (C) 2000, International Business Machines Corporation
 * and others.  All Rights Reserved.
 *
 *  Version : 1.0 (2000-07-19)
 *
 *  Author  :   Tadayuki Yoshida <tadayuki@jp.ibm.com>
 *
 */

#include "glibctest.h"
#include "test_coll.h"

supported_API apilist[] = {
  {"int strcoll ( const char *, const char * )",
   "compare two multibyte stirngs using the current locale."}
  ,
  {"int wcscoll ( const wchar_t *, const wchar_t * )",
   "compare two wide-character strings using the current locale."}
  ,
  {"\0", "\0"}
};

int
main (int argc, char *argv[])
{
  char **test_strings, **ans_strings;
  wchar_t **test_wstrings, **ans_wstrings;
  params *prmp;
  boolean result;
  int error_cnt;
  char *bufp;
  int rand1, rand2;
  int len1, len2;
  char *swaptmp;

  char *test_str;
  char *test_ans;
  size_t tmpsize;

  int i, j;
  size_t num_of_item = 0;

  /* start process here. */

  system_info ();

  /*
   * Option Check
   */

  prmp = (params *)mem_alloc (sizeof (params));
  getparams_coll (argc, argv, prmp);

  /*
   * Counting number of lines
   */
  while (get_oneline (prmp->ans_fp, &bufp))
    {
      if ( iscommentline (bufp, '#') == false )
	{
	  num_of_item++;
	}
      mem_free ((void *) bufp);
    }
  mem_free ((void *) bufp);

  rewind (prmp->ans_fp);

  /*
   * Memory allocation
   */
  test_strings = (char **) mem_calloc (num_of_item, sizeof (char *));
  ans_strings = (char **) mem_calloc (num_of_item, sizeof (char *));

  if (!prmp->genans_global)
    {
      test_wstrings =
	(wchar_t **) mem_calloc (num_of_item, sizeof (wchar_t *));
      ans_wstrings =
	(wchar_t **) mem_calloc (num_of_item, sizeof (wchar_t *));
    }

  /*
   * Reading strings from answer file
   */

  bufp = (char *)NULL;
  i=0;
  while (get_oneline (prmp->ans_fp, &bufp) != NULL)
    {
      j=0;
      if ( iscommentline (bufp, '#') )
	{
	  mem_free ((void *) bufp);
          continue;
	}
      else
	{
	  (void *) set_token_from_buf (bufp, &(ans_strings[i]));
	  stringpcpy (&(test_strings[i]), ans_strings[i]);

	  if (!prmp->genans_global)
	    {
	      convert_mbswcs (&(ans_wstrings[i]), ans_strings[i]);
	      convert_mbswcs (&(test_wstrings[i]), test_strings[i]);
	    }
	  i++;
	  mem_free ((void *) bufp);
	}
    }

  mem_free ((void *) bufp);
  fclose (prmp->ans_fp);

  /*
   * Random Sort to generate test_strings
   */
  if (!prmp->genans_global)
    {
      srand (time (NULL));
      for (i=0; i<num_of_item; i++)
	{
	  rand1 = (int) (((float)num_of_item) * rand ()/(RAND_MAX + 1.0));
	  rand2 = (int) (((float)num_of_item) * rand ()/(RAND_MAX + 1.0));
	  swaptmp = test_strings[rand1];
	  test_strings[rand1] = test_strings[rand2];
	  test_strings[rand2] = swaptmp;
	}
    }

  display_string ("===== auto-generated input strings =====\n");
  if (prmp->verbose_flag)
    {
      fprintf (stderr, "===== auto-generated input strings =====\n");
    }
  for (i=0; i<num_of_item; i++)
    {
      display_string (test_strings[i]);
      display_string ("\n");
      if (prmp->verbose_flag)
	{
	  fprintf (stderr, "%s\n", test_strings[i]);
	}
    }

  display_string ("========= collation result =============\n");
  if (prmp->verbose_flag)
    {
      fprintf (stderr, "========= collation result =============\n");
    }

  /*
   * Sorting
   */

  string_sort (test_strings, num_of_item);

  if (!prmp->genans_global)
    {
      wstring_sort (test_wstrings, num_of_item);
    }

  if (prmp->genans_global)
    {
      for (i = 0; i < num_of_item; i++)
	{
	  fprintf (stdout, "%s\n", test_strings[i]);
	  mem_free ((void *) test_strings[i]);
	}
      mem_free ((void *) test_strings);
      return (0);
    }

  /*
   * Examine
   */

  error_cnt = 0;
  for (i = 0; i < num_of_item; i++)
    {
      result = stringeq (test_strings[i], ans_strings[i]);
      display ("strcoll", test_strings[i], ans_strings[i],
	       result, prmp->genans_global, prmp->verbose_flag);
      error_cnt += !result;
      mem_free ((void *) test_strings[i]);
      mem_free ((void *) ans_strings[i]);
    }
  mem_free ((void *) test_strings);
  mem_free ((void *) ans_strings);

  display_string ("\n");
  if (prmp->verbose_flag)
    {
      fprintf (stderr, "\n");
    }

  for (i = 0; i < num_of_item; i++)
    {
      convert_wcsmbs (&test_str, test_wstrings[i]);
      convert_wcsmbs (&test_ans, ans_wstrings[i]);
      result = wstringeq (test_wstrings[i], ans_wstrings[i]);
      display ("wcscoll", test_str, test_ans, result,
	       prmp->genans_global, prmp->verbose_flag);
      error_cnt += !result;
      mem_free ((void *) test_str);
      mem_free ((void *) test_ans);
      mem_free ((void *) test_wstrings[i]);
      mem_free ((void *) ans_wstrings[i]);
    }
  mem_free ((void *) test_wstrings);
  mem_free ((void *) ans_wstrings);
  mem_free ((void *) prmp);

  result_report (num_of_item * 2, error_cnt, "");

  return (0);
}

/*  end of test_coll.c */
