#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <locale.h>
#include <unistd.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define T_COLL 0
#define T_LANG 1
#define T_ISWC 2
#define T_MBSTOWCS 3
#define T_MBTOWC 4
#define T_ICONV 5
#define T_PRINTF 6
#define T_STRING 7

gchar *locale;
gint modules[8] = {0,0,0,0,0,0,0,0};
gchar *btnlist[8] = {
	 "checkbutton1", "checkbutton2", "checkbutton3", "checkbutton4",
	 "checkbutton5", "checkbutton6", "checkbutton7", "checkbutton8"
	 };
gint	testcasemode = 0;
gint	verboseflag = 1;
gint	printprompt = 1;
gint	generateflag = 0;
char *dirname[8] = {
	"coll", "lang", "iswc", "mbstowcs",
	"mbtowc", "iconv", "printf", "string"
	};

gchar *fileentlist[16] = {
	"fileentry1", "",
	"fileentry2", "",
	"fileentry3", "fileentry10",
	"fileentry4", "",
	"fileentry5", "fileentry11",
	"", "",
	"fileentry7", "",
	"fileentry8", ""
	};

GtkWidget *testcase;

void
print_modules_sw (void)
{
/*
	int i;
	
	printf ("modules = ");
	for (i=0; i<7; i++)
		{
			printf ("%d,", modules[i]);
		}
	printf ("%d\n", modules[7]);
*/
}

void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_main_quit ();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *about;
	about = create_about1 ();
	gtk_widget_show (about);
}


void
on_combo_entry1_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	locale = gtk_entry_get_text (GTK_ENTRY (editable));
/*	printf("Locale changed %s.\n", locale); */
	setlocale (LC_ALL, (char *)locale);
	gtk_set_locale ();
}


void
on_radiobutton4_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	int i;
	GtkToggleButton *btn;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{
/*			printf ("Select All Above.\n"); */

			for (i=0; i<8; i++)
				{
					btn = (GtkToggleButton *)lookup_widget (GTK_WIDGET (togglebutton), btnlist[i]);
					gtk_toggle_button_set_state (btn, TRUE);
					gtk_widget_set_sensitive ((GtkWidget *)btn, FALSE);
				}
			print_modules_sw ();
		}	
}


void
on_radiobutton3_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	int i;
	GtkToggleButton *btn;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
/*  			printf ("Select Individual.\n"); */
			for (i=0; i<8; i++)
				{
					btn = (GtkToggleButton *)lookup_widget (GTK_WIDGET (togglebutton), btnlist[i]);
					gtk_widget_set_sensitive ((GtkWidget *)btn, TRUE);
				}
			print_modules_sw ();
  		}
}


void
on_checkbutton1_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("collation checked.\n"); */
  modules[0] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton2_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("language checked.\n"); */
  modules[1] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton3_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("iswcxxx checked\n"); */
  modules[2] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton4_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("mbstowcs checked.\n"); */
  modules[3] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton5_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("mbtowc checked.\n"); */
  modules[4] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton6_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("iconv checked.\n"); */
  modules[5] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton7_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("printf checked.\n"); */
  modules[6] ^= 1;
  print_modules_sw ();
}


void
on_checkbutton8_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*  printf ("string checked.\n"); */
  modules[7] ^= 1;
  print_modules_sw ();
}


void
on_radiobutton1_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkToggleButton *tbtn;
	GtkButton *btn;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
/*  			printf ("Automated selected.\n"); */
			testcasemode = 0;
			tbtn = (GtkToggleButton *)lookup_widget (GTK_WIDGET (togglebutton), "checkbutton9");
			gtk_widget_set_sensitive ((GtkWidget *)tbtn, FALSE);
			btn = (GtkButton *)lookup_widget (GTK_WIDGET (togglebutton), "button6");
			gtk_widget_set_sensitive ((GtkWidget *)btn, FALSE);
  		}
}


void
on_radiobutton8_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkToggleButton *tbtn;
	GtkButton *btn;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
/*  			printf ("Manual selected.\n"); */
			testcasemode = 1;
			tbtn = (GtkToggleButton *)lookup_widget (GTK_WIDGET (togglebutton), "checkbutton9");
			gtk_widget_set_sensitive ((GtkWidget *)tbtn, FALSE);
			btn = (GtkButton *)lookup_widget (GTK_WIDGET (togglebutton), "button6");
			gtk_widget_set_sensitive ((GtkWidget *)btn, TRUE);
  		}
}


void
on_button6_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	testcase = create_testcasefile ();
	gtk_widget_show (testcase);
/*
	printf ("Browse... pressed\n");
*/
}


void
on_radiobutton5_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkToggleButton *tbtn;
	GtkButton *btn;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
/*  			printf ("Interactive selected.\n"); */
			testcasemode = 2;
			tbtn = (GtkToggleButton *)lookup_widget (GTK_WIDGET (togglebutton), "checkbutton9");
			gtk_widget_set_sensitive ((GtkWidget *)tbtn, TRUE);
			btn = (GtkButton *)lookup_widget (GTK_WIDGET (togglebutton), "button6");
			gtk_widget_set_sensitive ((GtkWidget *)btn, FALSE);
  		}
}


void
on_radiobutton6_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
			verboseflag = 1;
/*  			printf ("Verbose selected.\n"); */
  		}
}


void
on_radiobutton7_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
/*  			printf ("Silent selected.\n"); */
			verboseflag = 0;
  		}
}


void
on_checkbutton9_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	printprompt ^= 1;
/*
	if (printprompt)
		{
			printf ("Prompt selected.\n");
		}
	else
		{
			printf ("Prompt deselected.\n");
		}
*/
}


void
on_combo_entry2_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
/*
	gchar *man;
	man = gtk_entry_get_text (GTK_ENTRY (editable));
	printf("target %s.\n", man);
*/
}


void
on_button4_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *man;
	GtkEntry *ent;
	char command[64];

	ent = (GtkEntry *)lookup_widget (GTK_WIDGET (button), "combo_entry2");
	man = gtk_entry_get_text (GTK_ENTRY (ent));

	sprintf (command, "xterm -e man -M ./man %s 2> /dev/null \n", man);
	system (command);
}


void
on_button5_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	char command[16] = "";
	char options[16] = "";
	char filenames[256] = "";
	char exec[512] = "";
	char pwd[256] = "";
	char wd[256] = "";
	char *filename = "";
	GnomeFileEntry *filesel;
	GnomeEntry *entry;
	char *fromcode;
	char *tocode;
	
	printf ("Test start.\n");

	getcwd (pwd, 256);
	for (i=0; i<8; i++)
		{
			strcpy (command, "");
			strcpy (filenames, "");
			strcpy (options, "");

			if (!verboseflag) strcat (options, "-s ");

			if (generateflag) strcat (options, "-g ");

			if (modules[i])
				{

					switch (testcasemode)
					{
						case 0: {
							strcat (command, "./runtest.sh");
							break;					
						}
						case 1: {
                                   if ( i == T_ICONV )
                                   {
								/* get file name */
								entry = GNOME_ENTRY (lookup_widget (GTK_WIDGET (testcase), "entry1"));
								fromcode = gtk_entry_get_text (GTK_ENTRY(gnome_entry_gtk_entry(entry)));
								entry = GNOME_ENTRY (lookup_widget (GTK_WIDGET (testcase), "entry2"));
								tocode = gtk_entry_get_text (GTK_ENTRY(gnome_entry_gtk_entry(entry)));
								strcpy (command, "./test_iconv");
								sprintf (filenames, "-f ./ans/%s -a ./ans/%s %s %s", fromcode, tocode, fromcode, tocode);					
								if (generateflag) {
									sprintf (filenames, "%s > %s ", filenames, tocode);
								}
                                   }
                                   else
                                   {
								strcat (command, "./test_");
								strcat (command, dirname[i]);
								/* get file name */
								filesel = GNOME_FILE_ENTRY (lookup_widget (GTK_WIDGET (testcase), fileentlist[i*2]));
								filename = gnome_file_entry_get_full_path (GNOME_FILE_ENTRY(filesel), TRUE);
								strcat (filenames, "-f ");
								strcat (filenames, filename);
								if (strcmp (fileentlist[i*2+1], "") != 0){
									filesel = GNOME_FILE_ENTRY (lookup_widget (GTK_WIDGET (testcase), fileentlist[i*2+1]));
									filename = gnome_file_entry_get_full_path (GNOME_FILE_ENTRY(filesel), TRUE);
									strcat (filenames, " -a ");
									strcat (filenames, filename);
								}					
								if (generateflag) {
									sprintf (filenames, "%s > log.%s ", filenames, locale);
								}
							}
							break;
						}
						case 2: {
							strcat (command, "./test_");
							strcat (command, dirname[i]);
							strcat (options, "-i ");
							if (printprompt)
								{
									strcat (options, "-p ");
								}
							else
								{
									strcat (options, "");
							}
							break;
						}
						default: {
							fprintf (stderr, " %d ? no such mode.\n", testcasemode);
						}
					}

					sprintf (wd, "%s/%s", pwd, dirname[i]);
					chdir (wd);
					printf ("[cd %s]\n", wd);
					sprintf (exec, "env LANG=%s %s %s %s", locale, command, options, filenames);
					printf ("[%s]\n", exec);
					system (exec);
					chdir (pwd);
				}
		}
	printf ("Test end.\n");

}


void
on_radiobutton9_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkToggleButton *tbtn;
	GtkButton *btn;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		{	
/*  			printf ("Manual selected.\n"); */
			testcasemode = 3;
			tbtn = (GtkToggleButton *)lookup_widget (GTK_WIDGET (togglebutton), "checkbutton9");
			gtk_widget_set_sensitive ((GtkWidget *)tbtn, FALSE);
			btn = (GtkButton *)lookup_widget (GTK_WIDGET (togglebutton), "button6");
			gtk_widget_set_sensitive ((GtkWidget *)btn, FALSE);
  		}
}


void
on_checkbutton10_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	generateflag ^= 1;
}


void
on_button7_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide (testcase);
}
