/*
 * 
 * copywrite 2003-4 under GNU/GPL which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>

#include <dirent.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <utime.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "glade_remove_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "countfiles.h"

#include "cpy.h"
#include "entry.h"
#include "icons.h"
#include "misc.h"
#include "monitor.h"
#include "remove.h"
#include "uri.h"
#include "widgets.h"

/* signal handling */
#ifndef HAVE_SIGNAL
#ifndef HAVE_SIGACTION
#error "This program needs signals to work!"
#endif
#endif

/* XXX: should be determined in a dynamic way... */
#define PIPE_BLOCK 250000

#define MAX_LINE_SIZE (_POSIX_PATH_MAX*3)
#define CHILD_FILE_LENGTH 64

#ifndef GLOB_TILDE
#define GLOB_TILDE 0x0
#endif

#ifndef GLOB_PERIOD
#define GLOB_PERIOD 0
#endif
extern char child_file[_POSIX_PATH_MAX];

static GtkWidget *count_label;
static gboolean count_cancelled;
static GtkWidget *countW = NULL;
static int counttimer, countT, smallcount;
static long long sizeT;



G_MODULE_EXPORT
int recursive_count_files (char *path)
{
    DIR *directory;
    struct dirent *dir;
    char fullpath[_POSIX_PATH_MAX];
    struct stat st;

    directory = opendir(path);
    if(!directory)
    {
	return -1;
    }
	/*fprintf(stderr,"dbg:%s file=%d size=%ld\n",path,countT,sizeT);*/
    while((dir = readdir(directory)) != NULL && !count_cancelled)
    {
	if(strcmp(dir->d_name, ".") == 0 || strcmp(dir->d_name, "..") == 0)
	    continue;
	if(strlen(path) + strlen(dir->d_name) + 2 > _POSIX_PATH_MAX)
	{
	    printf("DBG:%s/%s\n", path, dir->d_name);
	    assert_not_reached();
	}
	sprintf(fullpath, "%s/%s", path, dir->d_name);
	countT++;
	if (lstat(fullpath, &st) != -1) {
	  smallcount++;
	  sizeT += st.st_size;
	}
	if(S_ISDIR(st.st_mode))
	    recursive_count_files(fullpath);
	else if(smallcount & 0x100)
	{
	    smallcount = 0;
	    sprintf(fullpath, "%d %s", countT, _("files"));
	    gtk_label_set_text((GtkLabel *) count_label, fullpath);
    	    process_pending_gtk();
	}
    }
    closedir(directory);
    return (1);
}

static gint ParentCount(gpointer data)
{
    FILE *tfile;
    char *line, *source;
    int type;
    struct stat st;

    g_source_remove(counttimer);
    counttimer = 0;
    smallcount = 0;
    countT = 0;
    sizeT = 0;
    line = (char *)malloc(MAX_LINE_SIZE);
    if(!line)
	assert_not_reached();
    tfile = fopen(child_file, "r");
    if(!tfile)
	assert_not_reached();
    D(printf("DBG: opened %s\n",child_file);)
    while(fgets(line, MAX_LINE_SIZE - 1, tfile) && !feof(tfile) && !count_cancelled)
    {
	type = atoi(strtok(line, "\t"));
	source = strtok(NULL, "\t");
	recursive_count_files(source);
	countT++;
	if (lstat(source, &st) != -1) {
	  sizeT += st.st_size;
	}
	/*fprintf(stderr,"dbg:%s file=%d size=%ld\n",line,countT,sizeT);*/
	sprintf(line, "%s %s", _("Counted"), sizetag((off_t)sizeT, countT));
	print_status("xfce/info", line, NULL);
    }
    fclose(tfile);
    g_free(line);
    line=NULL;
    gtk_main_quit();
    return FALSE;
}


static void cb_count_destroy(GtkWidget * widget, gpointer data)
{
    count_cancelled = TRUE;	/* for user destruction */
    countW = NULL;
}
static void cb_count_cancel(GtkWidget * widget, gpointer data)
{
    count_cancelled = TRUE;	/* for user destruction */
    gtk_widget_destroy(countW);
    countW = NULL;
}

static void count_window(void)
{
    GtkWidget *cancel;
    count_cancelled = FALSE;
    countW = gtk_dialog_new();

    gtk_window_set_position(GTK_WINDOW(countW), GTK_WIN_POS_MOUSE);
    gtk_window_set_modal(GTK_WINDOW(countW), TRUE);
    count_label = gtk_label_new(_("Counting files"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(countW)->vbox), count_label, TRUE, TRUE, 3);

    count_label = gtk_label_new(".........................................");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(countW)->vbox), count_label, TRUE, TRUE, 3);

    cancel = gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(countW)->action_area), cancel, FALSE, FALSE, 3);
    g_signal_connect(G_OBJECT(cancel), "clicked", (GCallback)cb_count_cancel, NULL);

    gtk_widget_realize(countW);

    /*if (preferences&SMALL_DIALOGS) 
       gdk_window_set_decorations (countW->window,GDK_DECOR_BORDER); */

    if(tree_details->window)
	gtk_window_set_transient_for(GTK_WINDOW(countW), GTK_WINDOW(tree_details->window));
    g_signal_connect(GTK_OBJECT(countW), "destroy", (GCallback)cb_count_destroy, NULL);
    gtk_widget_show_all(countW);
    gdk_flush();
    /* add timeout */
    counttimer = g_timeout_add_full(0, 260, (GtkFunction) ParentCount,NULL, NULL);


    gtk_main();
    if(countW)
    {
	gtk_widget_destroy(countW);
	count_cancelled = FALSE;
    }
    return;
}



G_MODULE_EXPORT
void on_countfiles_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    gchar *fname;
    if ((fname=PlainTmpList(treeview,selection))==NULL) assert_not_reached();
    strcpy(child_file, fname);
    g_free(fname);
    count_window();
    unlink(child_file);
    return;
}

