"<HTML> <HEAD>",
"<TITLE>XImtool On-Line Help Summary</TITLE>",
"</HEAD> <BODY>",
"<H2>Welcome to XImtool V1.3</H2>",
"",
"XImtool is an image display server developed by the IRAF Project at the",
"National Optical Astronomy Observatories.  To view images you need",
"client software (such as IRAF) to load images into the display, or it can",
"load images directly when run as a standalone task.",
"<p>",
"More <a href=#toc>detailed help</a> is available on the following topics:",
"<dl><dl>",
"<dt>Basic Usage:</dt>",
"<ul>",
"<li><A HREF=\"#basic\">Getting Started</A> -- The basics. </li>",
"<li><A HREF=\"#gui\">GUI Overview</A> -- What it looks like. </li>",
"<li><A HREF=\"#mouse\">Mouse Operations</A> -- Doing stuff. </li>",
"<li><A HREF=\"#keystroke\">Keystroke Accelerators</A> -- Keystroke summary.</li>",
"<li><A HREF=\"#markers\">Markers</A> -- Panner/WCS markers, general markers.</li>",
"<li><A HREF=\"#control\">Control Panel</A> -- Operating the Control panel.</li>",
"<li><A HREF=\"#load\">Load Panel</A> -- Load panel operation and options.</li>",
"<li><A HREF=\"#save\">Save Panel</A> -- Save panel operation and options.</li>",
"<li><A HREF=\"#print\">Print Panel</A> -- Print panel operation and options.</li>",
"<li><A HREF=\"#info\">Info Panel</A> -- Information panel.</li>",
"</ul></dl></dl>",
"<dl><dl>",
"<dt>Advanced Features:</dt>",
"<ul>",
"<li><A HREF=\"#comline\">Command-line Options</A> -- Startup flags. </li>",
"<li><A HREF=\"#client\">Client Connections</A> -- Use as a display server. </li>",
"<li><A HREF=\"#framebuf\">Frame Buffers</A> -- Explanation of Frame buffers. </li>",
"<li><A HREF=\"#pprinter\">Printer Configurations</A> -- Configuring output devices. </li>",
"<li><A HREF=\"#tclshell\">TclShell</A> -- Expert-mode interactive shell.</li>",
"</ul></dl></dl>",
"<p>",
"Please contact <i>iraf@noao.edu</i> with comments, bugs, or suggestions.",
"More detailed documentation is also available in the man page for this",
"task.",
"<p>",
"<hr>",
"",
"<a name=#toc> <h2>Table of Contents:</h2> </a>",
"<pre>",
"        <A HREF=\"#basic\">Getting Started</A>",
"        <A HREF=\"#gui\">GUI Overview</A>",
"        <A HREF=\"#mouse\">Mouse Operations</A>",
"        <A HREF=\"#keystroke\">Keystroke Accelerators</A>",
"        <A HREF=\"#comline\">Command-line Options</A>",
"        <A HREF=\"#client\">Client Connections</A>",
"	<A HREF=\"#framebuf\">Frame Buffers</A>",
"            <A HREF=\"#frame16\">Support for 16 Frames</A>",
"        <A HREF=\"#markers\">Markers</A>",
"            <A HREF=\"#panner\">Panner Marker</A>",
"            <A HREF=\"#magnifier\">Magnifier Marker</A>",
"            <A HREF=\"#coords\">Coords Box Marker</A>",
"            <A HREF=\"#rulers\">Ruler Markers</A>",
"            <A HREF=\"#genmark\">General Markers</A>",
"                <A HREF=\"#markmenu\">Menu Options</A>",
"        <A HREF=\"#wcspix\">Real-Time WCS/Pixel Readout</A>",
"        <A HREF=\"#curfreeze\">Freezing Cursor Readout</A>",
"        <A HREF=\"#autoreg\">Auto-Registration of Images</A>",
"        <A HREF=\"#cutgraphs\">Image Cut Graphics</A>",
"        <A HREF=\"#peakup\">Peak-Up Cursor Centroid Positioning</A>",
"",
"        <A HREF=\"#control\">Integrated Control Panel</A>",
"          <A HREF=\"#display\">Display Panel</A>",
"            <A HREF=\"#cview\">View Controls</A>",
"            <A HREF=\"#cenhance\">Enhancement Controls</A>",
"            <A HREF=\"#cblink\">Blink Controls</A>",
"            <A HREF=\"#copts\">Options:</A>",
"              <A HREF=\"#cpanner\">Panner</A>",
"              <A HREF=\"#cmagnifier\">Magnifier</A>",
"              <A HREF=\"#ccoords\">Coords Box</A>",
"              <A HREF=\"#cautoscale\">Autoscale</A>",
"              <A HREF=\"#cantialias\">Antialias</A>",
"              <A HREF=\"#ctile\">Tile Frames</A>",
"              <A HREF=\"#cwarnings\">Warnings</A>",
"              <A HREF=\"#ccentroid\">Centroid Peaks</A>",
"	    <A HREF=\"#ccmap\">Colormap Selection</A>",
"              <A HREF=\"#cbltin\">Builtin Colormaps</A>",
"              <A HREF=\"#cuser\">User-defined Colormaps</A>",
"          <A HREF=\"#load\">Load Panel</A>",
"            <A HREF=\"#lbrowse\">Directory browsing</A>",
"            <A HREF=\"#lpattern\">File Patterns</A>",
"            <A HREF=\"#lload\">Direct File Load</A>",
"            <A HREF=\"#lframe\">Frame Selections</A>",
"          <A HREF=\"#save\">Save Panel</A>",
"            <A HREF=\"#sfname\">File Name</A>",
"            <A HREF=\"#sformat\">Format</A>",
"            <A HREF=\"#scolor\">Color</A>",
"          <A HREF=\"#print\">Print Panel</A>",
"            <A HREF=\"#popts\">Postscript Options</A>",
"            <A HREF=\"#pcolors\">Color Options</A>",
"            <A HREF=\"#pproc\">Processing Options</A>",
"            <A HREF=\"#pprinter\">Printer selection</A>",
"          <A HREF=\"#info\">Info Panel</A>",
"          <A HREF=\"#tileP\">Tile Panel</A>",
"          <A HREF=\"#coordsP\">Coords Panel</A>",
"",
"        <A HREF=\"#tclshell\">Tcl Interactie Shell</A>",
"</pre>",
"<p>",
"<hr>",
"<h2><a name=#basic>Getting Started</a></h2>",
"As a display server, XImtool is started as a separate process from client",
"software such as IRAF.  Once it is running it will accept ",
"<a href=#client>client connections</a> simultaneously on fifo pipes, unix",
"domain sockets, or inet sockets.  A display client like the IRAF DISPLAY",
"task makes a connection and sends the image across using an IIS protocol",
"(other/different protocols may be supported in the future).  Once the image",
"is loaded in the display buffer it may be <a href=#cenhance>enhanced</a>,",
"<a href=#save>saved to a disk file</a> in a number of different formats, or ",
"<a href=#print>printed</a> as Encapsulated Postscript to a printer or disk file.",
"<p>",
"When run in standalone mode, images may be loaded on the ",
"<a href=#comline>command line</a> or by using the <a href=#load>Load Panel</a>.",
"This allows you to browse images and perform the same manipulations as if",
"they had been displayed by a client.",
"<hr>",
"",
"<h2><a name=#gui>GUI Overview</a></h2>",
"<p>",
"The GUI consists of a large image display window and a number of smaller",
"pannels that control various specific functions such as image",
"<a href=#load>Load</a>, <a href=#save>Save</a> and <a href=#print>Print</a>",
"as well as a general purpose <a href=#control>Control Panel</a>. The main",
"window menubar has several menu buttons to the left: the <i>Files</i> menu",
"is used to load/save/print an image as well as quit the task. The <i>View</i>",
"menu let's you select the image orientation, zoom, colormap or frame. The",
"<i>Options</i> menu allows you to call up control panels, toggle markers",
"or blinking etc.  Some of this functionality is duplicated elsewhere in",
"the GUI.  The right side of the menubar contains command buttons to flip the",
"image as well as buttons for frame selection and the help button.",
"<p>",
"For more detailed information on the operation of the control panels please",
"see the on-line help (i.e. use the '?' button or Alt-h keystroke in the",
"main image window).",
"",
"<h2><a name=#mouse>Mouse Operations</a></h2>",
"Clicking and dragging MB1 (mouse button 1) in the main image",
"window creates a rectangular region <a href=#markers>marker</a>, used",
"to select a region of the image.  If you do this accidentally and don't",
"want the marker, put the pointer in the marker and type DELETE or",
"BACKSPACE to delete the marker.  With the pointer in the marker,",
"MB3 will call up a <a href=#markmenu>marker menu</a> listing some things",
" you can do with the marker, like zoom the outlined region.  MB1 can be used",
"to drag or resize the marker. <a href=#markers>See below</a> for more",
"information on markers.",
"<p>",
"Clicking on MB2 in the main image window pans (one click) or zooms (two ",
"clicks) the image.  Further clicks cycle through the builtin zoom factors. ",
"Moving the pointer to a new location and clicking moves the feature under ",
"the pointer to the center of the display window.  Holding down the Shift",
"key while clicking MB2 will cause a full-screen crosshair cursor to appear",
"until the button is released, this can be useful for fine positioning of the",
"cursor.",
"<p>",
"MB3 is used to adjust the contrast and brightness of the displayed image.",
"The position of the pointer within the display window determines the ",
"contrast and brightness values.  Click once to set the values corresponding",
"to the pointer location, or click and drag to continuously adjust the display.",
"<hr>",
"",
"<h2><a name=#keystroke>Keystroke Accelerators</a></h2>",
"	The following keystrokes are currently defined in the GUI:",
"<pre>",
"                        <b>Misc Functions</b>                      ",
"    <b>Ctrl-b 		</b><i>Previous (back) frame</i>",
"    <b>Ctrl-c 		</b><i>Center frame</i>",
"    <b>Ctrl-f 		</b><i>Forward frame</i>",
"    <b>Ctrl-i 		</b><i>Invert colormap</i>",
"    <b>Ctrl-m 		</b><i>Toggle magnifier</i>",
"    <b>Ctrl-n 		</b><i>Normalize</i>",
"    <b>Ctrl-p 		</b><i>Toggle panner</i>",
"    <b>Ctrl-r 		</b><i>Register</i>",
"    <b>Ctrl-s 		</b><i>Match LUT scaling</i>",
"    <b>Ctrl-t 		</b><i>Tile frames toggle</i>",
"    <b>Ctrl-u 		</b><i>Unzoom (zoom=1)</i>",
"    <b>Ctrl-x 		</b><i>Flip X</i>",
"    <b>Ctrl-y 		</b><i>Flip Y</i>",
"    ",
"    <b>Ctrl-= 		</b><i>Print using current setup</i>",
"    <b>Ctrl-< 		</b><i>Decrease blink rate (blink faster)</i>",
"    <b>Ctrl-> 		</b><i>Increase blink rate (blink slower)</i>",
"    <b>Ctrl-+ 		</b><i>Zoom in</i>",
"    <b>Ctrl-- 		</b><i>Zoom out</i>",
"    ",
"    <b>Alt-1 thru Alt-4    </b><i>Set frame to be displayed</i>",
"    <b>Ctrl-1 thru Ctrl9   </b><i>Set integer zoom factor</i>",
"    ",
"    <b>Ctrl-Alt-q 		</b><i>Quit</i>",
"    <b>Ctrl-Alt-f 		</b><i>Fitframe</i>",
"    ",
"                        <b>Panel Toggles</b>                      ",
"    <b>Alt-b 		</b><i>Blink frames</i>",
"    <b>Alt-c 		</b><i>Control panel</i>",
"    <b>Alt-h 		</b><i>Help popup</i>",
"    <b>Alt-i 		</b><i>Info box popup</i>",
"    <b>Alt-l 		</b><i>Load file popup</i>",
"    <b>Alt-p 		</b><i>Print popup</i>",
"    <b>Alt-s 		</b><i>Save popup</i>",
"    <b>Alt-t 		</b><i>TclShell popup</i>",
"    ",
"                        <b>Cursor Positioning</b>                   ",
"    <b>Ctrl-h / Ctrl-Left  </b><i>Move cursor one pixel left</i>",
"    <b>Ctrl-j / Ctrl-Down  </b><i>Move cursor one pixel down</i>",
"    <b>Ctrl-k / Ctrl-Up    </b><i>Move cursor one pixel up</i>",
"    <b>Ctrl-l / Ctrl-Right </b><i>Move cursor one pixel right</i>",
"    ",
"    <b>Shift-Ctrl-h 	</b><i>Move cursor ten pixels left</i>",
"    <b>Shift-Ctrl-Left     </b><i>Move cursor ten pixels left</i>",
"    <b>Shift-Ctrl-j 	</b><i>Move cursor ten pixels down</i>",
"    <b>Shift-Ctrl-Down     </b><i>Move cursor ten pixels down</i>",
"    <b>Shift-Ctrl-k        </b><i>Move cursor ten pixels up</i>",
"    <b>Shift-Ctrl-Up       </b><i>Move cursor ten pixels up</i>",
"    <b>Shift-Ctrl-l  	</b><i>Move cursor ten pixels right</i>",
"    <b>Shift-Ctrl-Right    </b><i>Move cursor ten pixels right</i>",
"    ",
"                        <b>Auto-Registration</b>                    ",
"    <b>Ctrl-a 		</b><i>Toggle auto-registration</i>",
"    <b>Ctrl-o 		</b><i>Set frame offset</i>",
"    ",
"                        <b>Frame Positioning</b>                   ",
"    <b>Ctrl-Left  		</b><i>Shift one full frame left</i>",
"    <b>Ctrl-Down  		</b><i>Shift one full frame down</i>",
"    <b>Ctrl-Up    		</b><i>Shift one full frame up</i>",
"    <b>Ctrl-Right 		</b><i>Shift one full frame right</i>",
"    ",
"    <b>Ctrl-Alt-Left  	</b><i>Shift one half frame left</i>",
"    <b>Ctrl-Alt-Down  	</b><i>Shift one half frame down</i>",
"    <b>Ctrl-Alt-Up    	</b><i>Shift one half frame up</i>",
"    <b>Ctrl-Alt-Right 	</b><i>Shift one half frame right</i>",
"    ",
"                        <b>Peak Up Centroiding</b>                  ",
"    <b>Ctrl-[ 		</b><i>Decrease centroiding box size</i>",
"    <b>Ctrl-] 		</b><i>Increase centroiding box size</i>",
"    <b>Ctrl-0 (zero) 	</b><i>Centroid/find local maximum</i>",
"    <b>Alt-Ctrl-0 (zero)   </b><i>Find local minimum</i>",
"    ",
"                        <b>Mouse Button Events</b>                   ",
"    <b>Shift-Btn1Down 	</b><i>Turn on magnifier</i>",
"    <b>Shift-Btn1Up 	</b><i>Turn off magnifier</i>",
"    <b>Shift-Btn2Down 	</b><i>Turn on crosshair cursor</i>",
"    <b>Shift-Btn2Up 	</b><i>Turn off crosshair cursor</i>",
"    ",
"    <b>Btn1Down 		</b><i>Create a Marker</i>",
"    <b>Btn1Motion 		</b><i>Resize marker being created</i>",
"    <b>Btn2Down 		</b><i>Zoom/center on cursor position</i>",
"    <b>Btn3Down/Motion     </b><i>Brightness/contrast scale the image</i>",
"    ",
"    <b>Ctrl-Btn1Down 	</b><i>Create Ruler Marker</i>",
"    <b>Ctrl-Btn1Motion     </b><i>Resize Ruler Marker being created</i>",
"    <b>Ctrl-Btn1Up 	</b><i>Destroy Ruler Marker</i>",
"    ",
"    <b>Alt-Motion 		</b><i>Freeze cursor readout</i>",
"</pre>",
"<hr>",
"",
"<h2><a name=#client>Client Connections</a></h2>",
"Ximtool allows clients to connect in any of the following ways:",
"",
"<dl>",
"<dt><b>fifo pipes</b></dt>",
"    <dd>The traditional approach.  The default, global /dev/imt1[io] pipes may ",
"	be used, or a private set of fifos.</dd>",
"<dt><b>tcp/ip socket</b></dt>",
"    <dd>Clients connect via a tcp/ip socket.  There is a default port, or",
"	a custom port may be specified.  This permits connecting to the",
"	server over a remote network connection anywhere on the Internet.</dd>",
"<dt><b>unix domain socket</b></dt>",
"    <dd>Like a tcp/ip socket, but limited to a single host system.  Usually ",
"	faster than a tcp/ip socket, and comparable to a fifo.  By default",
"	each user gets their own unix domain socket, so this option allows",
"	multiple users to run ximtools on the same host without having to",
"	customize things.</dd>",
"</dl>",
"",
"By default ximtool listens simultaneously for client connctions on all three",
"types of ports.  Clients communicate with XImtool using the IIS protocol,",
"other protocols may be supported in the future.",
"<hr>",
"",
"<h2><a name=#framebuf>Frame Buffers</a></h2>",
"XImtool starts up using default frame buffer size of 512x512 pixels, two",
"(of 16 possible) frames will be created. When loading disk images (i.e.",
"run in standalone mode) the frame buffer configuration file will be",
"searched for a defined frame buffer that is the same size or larger than",
"the current image, if no suitable buffer can be found a custom frame",
"buffer the same size as the image will be created in an unused portion of",
"the configuration table.  When used as a display server the frame buffer",
"configuration number is passed in by the client and loaded explicitly even",
"if it means clipping the image.  If a new frame buffer is a different size",
"than previously defined frames, all available frames will be initialized",
"and cleared prior to the display.  The default frame buffer configuration",
"file is <b>/usr/local/lib/imtoolrc</b>, this can be overridden by defining a",
"<b>IMTOOLRC</b> environment variable naming the file to be used, by creating a",
"<b>.imtoolrc</b> file in your home directory, or a new file may be specified",
"using the <b>-imtoolrc</b> command line flag or <b>imtoolrc</b> application",
"resource.",
"<p>",
"The format of the frame buffer configuration file is",
"<pre>",
"   configno nframes width height [extra fields]",
"",
"e.g.                   ",
"	1  2  512  512",
"	2  2  800  800",
"	3  1 1024 1024          # comment",
"</pre>",
"At most 128 frame buffer sizes may be defined, each configuration may",
"define up to 16 frames, configuration numbers need not be sequential.",
"",
"<h3><a name=#frame16>Support for 16 Display Frames</a></h3>",
"<p>",
"As part of the extensive GUI changes with the V1.3 release, support for",
"the full 16 frames allowed by the IIS protocol is now available.  IRAF",
"V2.11.4 or later client tasks (and CDL library) are required to take",
"advantage of this frames.  All changes are backwards compatible, older",
"versions of IRAF will continue to work but cannot access more than the",
"original four frames.  The new DISPLAY task will automatically sense",
"whether the display server being used supports 16 frames or the original 4",
"and adjust the 'frame' parameter maximum accordingly.  The changes are",
"fully backwards compatible for other servers.",
"<p>",
"More frames are possible if needed but will require further changes to the",
"client IRAF code to be effective.  Allowing creation of more than 16",
"frames by the Load panel can be done independently but would also require",
"numerous code change to XImtool.  Please contact site support if there is",
"a need for this, or for workaround suggestions depending on your",
"application.",
"",
"",
"<h2><a name=#comline>Command-line Options</a></h2>",
"	The following command-line options are currently recognized:",
"<pre>",
"  <b>-basePixel</b> &lt;num&gt         Base colormap pixel number",
"  <b>-cmap1</b> &lt;file&gt            User cmap 1 ",
"  <b>-cmap2</b> &lt;file&gt            User cmap 2 ",
"  <b>-cmapDir1</b> &lt;dir&gt          User cmapDir 1 ",
"  <b>-cmapDir1</b> &lt;dir&gt          User cmapDir 2 ",
"  <b>-cmapInitialize</b> &lt;bool&gt   Initialize colormap at startup",
"  <b>-cmapName</b> &lt;name&gt         Private colormap name ",
"  <b>-config</b> &lt;num&gt            Initial config number",
"  <b>-defgui</b>                  Print default GUI to stdout",
"  <b>-displayPanner</b> &lt;bool&gt    Display panner box",
"  <b>-displayCoords</b> &lt;bool&gt    Display wcs coords box",
"  <b>-fifo</b> &lt;pipe&gt             Fifo pipe to use",
"  <b>-fifo_only</b>               Use fifo pipes only ",
"  <b>-gui</b> &lt;file&gt              GUI file to use ",
"  <b>-help</b>                    Print command-line summary ",
"  <b>-imtoolrc</b> &lt;file&gt         Frame buffer configuration file ",
"  <b>-inet_only</b>               Use inet sockets only ",
"  <b>-invert</b>                  Invert colormap on startup?",
"  <b>-ismdev</b>                  ISM socket template",
"  <b>-maxColors</b> &lt;num&gt         Number of colors ",
"  <b>-memModel</b> &lt;type&gt         Memory model (fast,small,beNiceToServer)",
"  <b>-nframes</b> &lt;num&gt           Number of frames at startup",
"  <b>-port</b> &lt;num&gt              Inet port to use",
"  <b>-printConfig</b> &lt;file&gt      Printer configuration file ",
"  <b>-port_only</b>               Use inet sockets only ",
"  <b>-tile</b>                    Tile frames on startup?",
"  <b>-unix</b> &lt;name&gt             Unix socket to use",
"  <b>-unix_only</b>               Use unix sockets only ",
"  &lt;<b>file</b>&gt                   File to load on startup",
"</pre>",
"<hr>",
"<h2><a name=#markers>Markers</a></h2>",
"<h3><a name=#panner>Panner Marker</a></h3>",
"<p>",
"The panner window always displays the full frame buffer.  Try setting the",
"frame buffer configuration to a nonsquare frame buffer (e.g. imtcryo) and",
"then displaying a square image (e.g. dev$pix) and the panner will show you",
"exactly where the image has been loaded into the frame.",
"<p>",
"The panner window uses two markers, one for the window border and one to",
"mark the displayed region of the frame.  Most of the usual marker keystrokes",
"mentioned <a href=#genmark>below</a> apply to these markers as well, e.g. ",
"you can use MB1 to reposition on the panner window within the main image ",
"display window, or to drag the region marker within the panner (pan the ",
"image).  Resizing the region marker zooms the image; this is a non-aspect ",
"constrained zoom. The panner window itself can be resized by dragging a ",
"corner with MB1.  Typing delete or backspace anywhere in the panner window ",
"deletes the panner.",
"<p>",
"A special case is MB2.  Hitting MB2 anywhere in the panner window pans the",
"image to that point.  This is analogous to typing MB2 in the main display",
"window to pan the image.",
"<p>",
"The panner marker can be disabled by defining the <i>displayPanner</i>",
"GUI resource, its size and location can be controlled using the",
"<i>pannerArea</i> and <i>pannerGeom</i> GUI resources respectively.",
"",
"<h3><a name=#magnifier>Magnifier Marker</a></h3>",
"The magnifier marker can be used to zoom in on a small area around the cursor.",
"It will be updated as the cursor moves but only for small motions (either",
"mouse movement or with the cursor movement keystrokes) to minimize the",
"impact on the system.  The zoom factor is expressed as some fraction of the",
"size of the magnifier marker itself.  The default zoom is 4, i.e. the area",
"in the marker represents and area in the image that's one-fourth the size",
"of the marker.  Other zoom factors may be selected using the popup menu ",
"created by hitting MB1 in the marker.",
"<p>",
"By default the magnifier marker is not visible, to toggle it select the",
"<i>Magnifier</i> option from the <i>Options</i> menubar button.  Alternatively,",
"for just a quick look holding down the Shift Key and MB2 Button will display",
"the marker until the button is released.",
"<p>",
"The magnifier marker can be disabled by defining the <i>displayMagnifier</i>",
"GUI resource, its size and location can be controlled using the",
"<i>magnifierArea</i>and <i>magnifierGeom</i> GUI resources respectively.",
"",
"<h3><a name=#coords>Coords Box Marker</a></h3>",
"<p>",
"Ximtool provides a limited notion of world coordinates, allowing frame",
"buffer pixel coordinates and pixel values to be converted to some arbitrary",
"client defined coordinate system.  The coords box feature is used to display",
"these world coordinates as the pointer is moved about in the image window.",
"<p>",
"The quantities displayed in the coords box are X, Y, and Z: the X,Y world",
"coordinates of the pointer, and Z, the world equivalent of the pixel value",
"under the pointer.  All coordinate systems are linear.  The precision of a",
"displayed quantity is limited by the range of values of the associated raw",
"frame buffer value.  For example, if the display window is 512x512 only 512",
"coordinate values are possible in either axis (the positional precision can",
"be increased however by zooming the image).  More seriously, at most about",
"200 pixel values can be displayed since this is the limit on the range of",
"pixel values loaded into the frame buffer.  If a display pixel is saturated",
"a \"+\" will be displayed after the intensity value.",
"<p>",
"The coords box is a marker (text marker) and it can be moved and resized",
"with the pointer like any other marker.",
"",
"<h3><a name=#rulers>Ruler Markers</a></h3>",
"<p>",
"Holding down the Ctrl key and the Left-Mouse-Button while moving",
"the mouse will drag out a \"ruler marker\" measuring the distance from the",
"initial point to the current mouse position.  Releasing the Ctrl key before",
"lifting the mouse button will leave the marker on the display, otherwise",
"it will be erased automatically once the mouse button is released.  Any",
"number of ruler markers can be created in the frame.",
"<p>",
"Distances are measured by default in image logical pixels however",
"the Right-Mouse-Button can be used inside the marker to popup a menu of",
"options:",
"",
"<dl>",
"<dt><b>Sticky</b></dt>",
"    <dd>By default rulers are destroyed whenever the display changes due",
"	to a pan, zoom, flip, or frame change.  This option will make the",
"	ruler \"sticky\" so it will not be erased, subsequent use of the menu",
"	to shows this option to be \"UnSticky\" to remove this feature.</dd>",
"<dt><b>Units</b></dt>",
"    <dd>Sub-menu to select the units of the display.  If the ISM is enabled",
"	and a WCS is present in the image and selected as one of the readout",
"	options, distances may also be read out in units of arcseconds,",
"	arcminutes, or degrees instead of the default logical pixels. All",
"	markers created after the unit change will readout in the new units",
"	as their default.  </dd>",
"<dt><b>Color</b></dt>",
"    <dd>Select the color of the marker.</dd>",
"<dt><b>Draw into Frame</b></dt>",
"    <dd>(<i>Not Yet Implemented</i>)  Draw the marker as overlay graphics",
"	in the frame.  Doing so will retain the marker when printing a",
"	hardcopy of the display.</dd>",
"<dt><b>Destroy</b></dt>",
"    <dd>Destroy the marker.</dd>",
"</dl>",
"",
"<p>",
"The marker can also be destroyed by hitting the Delete or Backspace key",
"while the cursor is in the marker.  There is presently no way to move the",
"marker to a new position in the frame.",
"",
"",
"<h3><a name=#genmark>General Markers</a></h3>",
"Although ximtool doesn't do much with markers currently, they are a general",
"feature of the Gterm widget and are used more extensively in other programs",
"(e.g. the prototype IRAF science GUI applications).  Ximtool uses markers",
"for the marker zoom feature discussed above, and also for the ",
"<a href=#panner>panner</a> and the <a href=#coords>coords box</a>.  All ",
"markers share some of the same characteristics, so it is worthwhile learning",
"basic marker manipulation keystrokes.",
"",
"<ul>",
"<li> MB1 anywhere inside a marker may be used to drag the marker.",
"<li> MB1 near a marker corner or edge, depending on the type of marker,",
"     resizes the marker.",
"<li> Shift-MB1 on the corner of most markers will rotate the marker.",
"<li> Markers stack, if you have several markers and you put one on top",
"     of the other.  The active marker is highlighted to tell you which of the ",
"     stacked markers is active.  If the markers overlap, this will be marker ",
"     \"on top\" in the stacking order.",
"<li> MB2 in the body of a marker \"lowers\" the marker, i.e. moves it to",
"     the bottom of the stacking order.",
"<li> Delete or backspace in a marker deletes it.",
"<li> Markers have their own translation resources and so the default",
"     <a href=#keystroke>keystroke commands</a> will not be recognized when the",
"     cursor is in a marker.",
"</ul>",
"",
"For example, try placing the pointer anywhere in the coords box, then press",
"MB1 and hold it down, and drag the coords box marker somewhere else on the",
"screen.  You can also resize the coords box by dragging a corner, or delete",
"it with the delete or backspace key.  (The <b>Initialize</b> button will get",
"the original coords box back if you delete it).",
"<p>",
"<h4><a name=#markmenu>Marker Menu Options</a></h4>",
"<ul>",
"<li> MB3 (mouse button 3) calls up the marker menu (by default).",
"<li> <b>Zoom</b> does an equal aspect zoom of the region outlined by the marker.",
"     In this way you can mark a region of the image and zoom it up.",
"<li> <b>Fill</b> exactly zooms the area outlined by the marker, making it fill",
"     the display window.  Since the marker is not likely to be exactly square, ",
"     the aspect ratio of the resultant image will not be unitary.",
"<li> <b>Print</b> prints the region outlined by the marker to the printer or",
"     file currently configured by the <a href=#print>Print Panel</a>.",
"<li> <b>Save</b> saves the region outlined by the marker to the file currently",
"     configured by the <a href=#save>Save Panel</a>.",
"<li> <b>Info</b> prints a description of the marked region. The text is ",
"     printed in the <a href=#info>Info Panel</a>.",
"<li> <b>Unrotate</b> unrotates a rotated marker.",
"<li> <b>Color</b> is a menu of possible marker colors.",
"<li> <b>Type</b> is a menu of possible marker types.  This is still a little",
"     buggy and it isn't very useful, but you can use it to play with different ",
"     types of markers.",
"<li> <b>Destroy</b> destroys the marker.  You can also hit the delete or ",
"     backspace key in a marker to destroy the marker.",
"</ul>",
"",
"<hr>",
"<h2><a name=#wcspix>Real-Time WCS/Pixel Readout</a></h2>",
"XImtool now has the ability to display the actual pixel value of an image",
"(as well as the scaled value previously shown) and the cursor position in",
"image WCS values (e.g. RA/DEC, GLAT/GLONG, etc).  This is done using an",
"external task (the 'ism_wcspix.e' binary in the new distribution) to",
"access the image and pass the coordinate/pixel information to the GUI.",
"<p>",
"WCS readout is enabled by default but can be toggled or reset using the",
"<i>WCS/Pix</i> button on the Coords tab in the control panel or the <i>ISM</i>",
"toggle on the alt-gui menubar.  When enabled, images currently in the",
"server or subsequently displayed will be passed to the external process",
"where they are cached for access.  Cursor movements generate an event that",
"maps the current frame buffer position to a position in the cached image.",
"The ISM (ISM is Image Support Module) task then reads the image to",
"determine the pixel value (or a small table of values around the current",
"position), and computes one or more coordinates from the image position.",
"The ISM task also has access to the associated BPM images and can",
"optionally return bad pixel information during the cursor readout.",
"<p>",
"By default, the logical and world image coordinates are displayed to both",
"the Coords panel readout as well as the main display window wcsbox text",
"marker.  Alternate coordinate systems (e.g. transformation of equatorial",
"to galactic coordinates or some other sky system, physical coords,",
"amplifier coords, etc) can be selected for display by hitting the",
"<i>Options</i> toggle on the Coords panel.  Available coordinate systems are",
"chosen using the <i>Type</i> menu on the panel, the readout format",
"(sexigesimal, degrees, etc) using the <i>Format</i> menu, and the display to",
"the current panel or main image window using the remaining toggles for",
"each WCS.  Up to four systems may be displayed at one time, the coordinate",
"panel and wcsbox marker will adjust size automatically depending on the",
"display.",
"<p>",
"By selecting the <i>BPM Data</i> toggle from the Coords.Options panel ximtool",
"is able to flag pixels in images with an associated bad pixel mask.  This",
"bad pixel mask is currently assumed to be named in the image header \"BPM\"",
"keyword by convention.  If the cursor passes over a bad pixel in the mask,",
"the Coords bpm display as well as the main window wcsbox will change to a",
"red background color.  Only the Coords display will show the value, any",
"non-zero value will be flagged with the color change.",
"<p>",
"With the ISM enabled the Compass indicator will display a set of arrows",
"showing North-East if a WCS is available, otherwise just the current X-Y",
"axes are shown.  The pixel table will display actual pixel values from the",
"image, with the ISM off the pixel table displays the scaled image values",
"from the frame buffer.",
"",
"",
"<hr>",
"<h2><a name=#curfreeze>Freezing Cursor Readout</a></h2>",
"<p>",
"Holding down the Alt key will now freeze the cursor display readout",
"and draw crosshairs on the screen at the last position.  This can be used",
"for example to position the cursor but then allow the cursor to be moved to",
"another window (to enter text, start a program, whatever) without losing",
"the position information displayed on the screen.",
"",
"",
"",
"<hr>",
"<h2><a name=#autoreg>Auto-Registration of Images</a></h2>",
"<p>",
"The auto-register feature allows you specify a registration of two or",
"more display frames with an offset.  When enabled, this registration is",
"maintained for all frames in the list if any one of them is panned or",
"zoomed to a new location in the frame buffer.",
"<p>",
"For example, to use this feature do the following:",
"",
"<ul>",
"<li> Enable Auto-Register (either on the Control Panel or the toolbar on the",
"     alt-gui) and pan/zoom to some star of interest.",
"<li> Use Mouse-Button-2 to center the star in the frame.",
"<li> Cycle through the frames and you may see a small shift of the star.  For",
"     each frame,  position the cursor on the star and type <b>Ctrl-o</b> to",
"     offset it to the center.  Repeat as necessary.  Small corrections will be",
"     cumulatively added so you can use the <b>Ctrl-0</b> (Ctrl-zero) peak-up",
"     command to centroid each object in the frame before the <b>Ctrl-o</b>",
"     offset.",
"<li> Pan around the image in one display frame, then switch frames and the new",
"     frame should also be panned to the new image with the proper offset.",
"<li> A <b>Ctrl-a</b> command will toggle the feature, offsets are only allowed",
"     when autoreg is enabled.",
"</ul>",
"",
"Hitting <b>Register</b> will zero the offsets, as will toggling the",
"auto-register function.  What you should see is the object centered in the",
"frame and as you blink through it remains registered but the panner box",
"marker is moving around.  Drag the panner around and all frames still",
"remain registered with the given offset.  The control/info panels now",
"display what the offset is for each frame.",
"<p>",
"The register display list is shared with the blink list and can be set",
"using the Display control panel.  By default all frames are included in",
"the list.  For accessing more than four frames, use the box icon in the",
"Blink/Register box of the Display control panel to bring up a new window",
"with access to all 16 available frames.",
"",
"",
"<hr>",
"<h2><a name=#cutgraphs>Image Cut Graphics</a></h2>",
"<p>",
"XImtool now has the ability to display horizontal and vertical",
"cut-graphs of the display, these appear as \"flip-out\" panels that appear",
"on the bottom and right side of the main display window and are controlled",
"by the small <b>H</b> and <b>V</b> buttons in the lower right corner of",
"the window.  When both panels are enabled the corner area of the display",
"also shows an options panel for the graphs.  Current options are:",
"",
"<dl>",
"<dt><b>Better Speed</b></dt>",
"    <dd>Draw the graphics so they update at the fastest possible rate.",
"	This is done by subsampling pixels to produce a smoother graph",
"	but without sacrificing too much accuracy.</dd>",
"<dt><b>Better Accuracy</b></dt>",
"    <dd>Draw the graphics using all screen pixels to produce the most",
"	accurate display.  On fast modern machines this can be enabled with",
"	no apparent loss of speed, however older machines may wish to use",
"	this only occassionally to limit any lag in the cursor tracking.</dd>",
"<dt><b>Image Pixels</b></dt>",
"    <dd>(<i>Not Yet Implemented</i>)<dd>",
"<dt><b>Jump Cursor</b></dt>",
"    <dd>If enabled, large jumps of the cursor do not update the graphics",
"	display, small movements around an object of interest will update",
"	the display continuously.</dd>",
"<dt><b>Smooth Cursor</b></dt>",
"    <dd>If enabled, all cursor movements cause the display to be updated.",
"	This is another option that can be set safely on faster machines",
"	but will cause a delay on slower ones.</dd>",
"<dt><b>Graphics Cursors</b></dt>",
"    <dd>If enabled, the graphics cursors in either of the plots are active",
"	and can be used to update the cursor readout on the main image window",
"	and the complementary cut-graph.  This can be used for example to",
"	freeze the cursor in the main display using the Alt key (see above),",
"	then moving to one of the graphics windows to perform cut graphs in",
"	only one axis.</dd>",
"</dl>",
"",
"Graphs are (currently) drawn using only the scaled display values ",
"to avoid complications of accessing multiple images in a mosaic display. Both",
"plots are labeled using the frame z1/z2 values and contain cursor indicators",
"which update contuously.",
"",
"",
"<hr>",
"<h2><a name=#peakup>Peak-Up Cursor Centroid Positioning</a></h2>",
"<p>",
"Several new keystroke commands are available to reposition the",
"cursor to a centroid or min/max pixel value within a bounding box of the",
"cursor position,  allowing you to approximate the position with the mouse",
"and fine tune it quickly before typing the application keystroke command.",
"The initial box size is controlled with a <b>centerBoxSize</b> GUI resource",
"(defaults to 5 pixels) but can be adjusted interactively using the",
"<b>Ctrl-[</b> and <b>Ctrl-]</b> commands to descrease/increase the box",
"size respectively.  A marker will flash briefly to indicate the box size.",
"<p>",
"The <b>Ctrl-0</b> (zero) key finds either a centroid or the local maximum",
"pixel value within this box region, <b>Alt-Ctrl-0</i> (zero) will find the",
"local minimum value.  In either case the cursor is reposition to the computed",
"value.  The default peak-up action is to find the centroid position in the",
"box however this can be changed to find the max pixel by selection the",
"\"<a href=#ccentroid>Centroid Peaks</a>\" option from the main Display",
"control panel or by resetting the <i>peakCentroid</i> GUI resource",
"(defaults to True).  ",
"<p>",
"Centroiding is done using only the scaled screen pixel values and",
"only pixels above the mean value within the box are used.  It works best",
"if the box size is set appropriately, the centroid position may appear to",
"drift if the box is too large and includes too many background pixels.",
"",
"",
"<hr>",
"<h2><a name=#control>Integrated Control Panel</a></h2>",
"",
"<h3><a name=#display>Display Panel</a></h3>",
"XImtool has a control panel which can be used to exercise most of the",
"capabilities the program has for image display.  The control panel can be",
"accessed either via the <b>Options</b> menu from the main window menubar, or",
"by",
"pressing the leftmost button in the row of buttons at the upper right side",
"of the display in the standard GUI (in the alternate GUI the ",
"<i>Control Bar</i> accessed by the rightmost button on the menubar",
"provides widgets for selecting the desired control panel).",
"<p>",
"The separate windows previously used for Control/Print/Load/Save/etc",
"have now been integrated into a single window with the appropriate control",
"panel selectable with a Tab widget.  There are also new Tab panels for",
"setting the frame tile configuration (see below), more detailed information",
"on the server status, and selecting the WCS readout options (see below).",
"",
"<h3><a name=#cview>View Controls</a></h3>",
"<p> ",
"The <b>Frame</b> box will list only the frame buffers you currently have",
"defined.  Currently, the only way to destroy a frame buffer is to change the",
"frame buffer configuration, new frame buffers (up to 4) will be created",
"automatically if requested by the client.",
"<p> ",
"The <b>text display window</b> gives the field X,Y center, X,Y scale ",
"factors, and the X,Y zoom factors.  The scale factor and the zoom factor ",
"will be the same unless autoscale is enabled.  The scale is in units of ",
"display pixels per frame buffer pixel, and is an absolute measure (it doesn't",
"matter whether or not <a href=#cautoscale>autoscale</a> is enabled).  Zoom is",
"relative to the autoscale factor, which is 1.0 if autoscaling is disabled.  ",
"This information is also presented in the <a href=#info>Info panel</a>.",
"<p> ",
"The numbers in the <b>Zoom</b> box are zoom factors.  Blue numbers zoom,",
"red numbers dezoom. <b>Zoom In</b> and <b>Zoom Out</b> may be used to go to",
"larger or smaller zoom factors, e.g. \"Ctrl-5\" followed by \"Zoom In\" will get you",
"to zoom factor 10.  Specific zoom factors may also be accessed directly as ",
"Control <a href=#keystrokes>keystrokes</a>, e.g. Ctrl-5 will set zoom factor 5.",
"<b>Center</b> centers the field. <b>Toggle Zoom</b> toggles between the ",
"current zoom/center values, and the unzoomed image.",
"<p> ",
"<b>Aspect</b> recomputes the view so that the aspect ratio is 1.0.  ",
"Aspect also integerizes the zoom factor (use the version in the View menu ",
"if you don't want integerization).",
"<p> ",
"<b>Fit Frame</b> makes the display window the same size as the frame ",
"buffer. Note that <a href=#cautoscale>autoscale</a> has much the same effect,",
"and allows you to resize the display window to any size you want, or view ",
"images to large to fit on the screen.",
"",
"<h3><a name=#cenhance>Enhancement Controls</a></h3>",
"",
"<p> ",
"At the top is a scrolled list of all the <a href=#cbltin>available ",
"colormaps</a>.  Click on the one you want to load it.  You can add your own",
"<a href=#cuser>colormaps</a> to this list.",
"<p> ",
"The two sliders adjust the <b>contrast</b> (upper slider) and ",
"<b>brightness</b> (lower slider) of the display. The <b>Invert</b> button ",
"inverts the colormap (multiples the contrast by -1.0). Note that due to the",
"use of the private colormap the sliders are a bit sluggish when dragged to ",
"window the display.  If this is annoying, using MB3 in the display window is",
"faster.",
"<p>",
"The <b>Normalize</b> button (on the bottom of the control panel) will ",
"normalize the enhancement, i.e. set the contrast and brightness to the default",
"one-to-one values (1.0, 0.5). This is the preferred setting for many of the",
"pseudocolor colortables and for private colormaps loaded from disk images.",
"",
"<h3><a name=#cblink>Blink Controls</a></h3>",
"<p>",
"<b>Blink frames</b> is the list of frames to be blinked. When blink mode is",
"in effect ximtool just cycles through these frames endlessly, pausing",
"\"blink rate\" seconds between each frame. The same frame can be entered in",
"the list more than once.  To program an arbitrary list of blink frames,",
"hit the Reset button and click on each blink frame button until it is set",
"to the desired frame number.  The main control panel allows only the",
"original four frames to be specified in the blink list, however access to",
"the full list of 16 frames now supported is gained using the box icon",
"button next the the <b>Reset</b> button to bring up a new control panel.",
"<p>",
"The <b>Blink Rate</b> can be adjusted as slow or as fast as you want using",
"the arrow buttons. If you set the blink rate small enough it will go to",
"zero, enabling single step mode (see below).",
"<p>",
"The <b>Register</b> button registers all the blink frames with the current",
"display frame. Frames not in the blink list are not affected.",
"<p>",
"The <b>Match LUTs</b> button sets the enhancement of all blink frames to",
"the same values as the display frame. Frames not in the blink list are not",
"affected.",
"<p>",
"The <b>Blink</b> button turns blink on and off. When the blink rate is set",
"to zero the Blink button will single step through the blink frames, one",
"frame per button press.",
"<p>",
"<b>NOTE:</b> You can blink no matter what ximtool options are in effect,",
"but many of these will slow blink down. To get the fastest blink you may",
"want to turn off the panner and coords box, and match the LUTs of all the",
"blink frames.  All the ximtool controls are fully active during blink",
"mode, plus you can load frames etc.",
"",
"",
"<h3><a name=#copts>Options:</a></h3>",
"<dl>",
"<dt><b><a name=#cpanner>Panner</a></b></dt>",
"    <dd>Toggles the display of the Panner marker.</dd>",
"<dt><b><a name=#cmagnifier>Magnifier</a></b></dt>",
"    <dd>Toggles the display of the magnifier marker.</dd>",
"<dt><b><a name=#ccoords>Coords Box</a></b></dt>",
"    <dd>Toggles the display of the WCS Coords Box marker.</dd>",
"<dt><b><a name=#cautoscale>Autoscale</a></b></dt>",
"    <dd>If autoscale is enabled then at zoom=1, the frame buffer will",
"	be automatically scaled to fit within the display window.  With",
"	autoscale disabled (the default), the image scale is more",
"	predictable, but the image may be clipped by the display window,",
"	or may not fill the display window.</dd>",
"<dt><b><a name=#cantialias>Antialias</a></b></dt>",
"    <dd>When dezooming an image, i.e., displaying a large image in a",
"	smaller display window, antialiasing causes all the data to be used",
"	to compute the displayed image.  If antialiasing is disabled then",
"	image is subsampled to compute the displayed image.  Antialiasing",
"	can prevent subsampling from omitting image features that don't",
"	fall in the sample grid, but it is significantly slower than",
"	dezooming via subsampling.  The default is no antialising. </dd>",
"<dt><b><a name=#ctile>Tile Frames</a></b></dt>",
"    <dd>The default display mode is to view one frame at a time.  In tile",
"	frames mode, 2 or 4 frames may be viewed simultaneously in the",
"	display window.  All the usual operations (zoom and pan, colortable",
"	enhancement, cursor readback, etc.) still work for each frame even",
"	when in tile frames mode. </dd>",
"<dt><b><a name=#cwarnings>Warnings</a></b></dt>",
"    <dd>The warnings options toggles whether you see warning dialog boxes",
"	in situations like overwriting an existing file, clearing the frame",
"	buffer, etc.</dd>",
"<dt><b><a name=#ccentroid>Centroid Peaks</a></b></dt>",
"    <dd>If enabled, the <b>Ctrl-0</b> keystroke will reposition the cursor",
"	to the computed centroid of the centroiding box, otherwise the cursor",
"	is repositioned to the local maximum value within the box.</dd>",
"</dl>",
"",
"<h3><a name=#ccmap>Colormap Selection</a></h3>",
"By default XImtool will display images using either a grayscale colormap",
"if loaded by a client, or a private colormap when loading an image from",
"disk that contains a colormap.  Each frame defines its own colormap so",
"you can define different colormaps or enhancements for each frame, they",
"will change automatically as you cycle through the frames.",
"",
"<h4><a name=#cbltin>Builtin Colormaps</a></h4>",
"Once loaded, the colormap may either be changed using the builtin colormap",
"menu under the <b>View</b> menu button on the main window, or from the",
"<a href=#cenhance>Enhancement</a> box on the <a href=#control>control panel</a>. Ximtool has about a dozen colormap",
"options builtin, other <a href=#cuser>user-defined colormaps</a> may ",
"optionally be loaded.",
"",
"<h4><a name=#cuser>User-defined Colormaps</a></h4>",
"The cmap[12] and cmapDir[12] resources (or <a href=#comline>command line",
"arguments</a> are used to tell ximtool which specific colormaps to make",
"available or where to look for colortables respectively.  The colortables",
"are loaded when ximtool starts up, or when it is reinitialized (e.g. by",
"pressing the <b>Initialize</b> button in the <a href=#control>control ",
"panel</a>).  Ximtool will ignore any files in the colormap directory",
"which do not look like colortables.  New colortables will also be added",
"for each images loaded from disk.",
"<p>",
"The format of a user lookup table is very simple: each row defines one",
"colortable entry, and consists of three columns defining the red, green,",
"and blue values scaled to the range 0.0 (off) to 1.0 (full intensity).",
"<pre>",
"        R G B",
"        R G B",
"        (etc.)",
"</pre>",
"Blank lines and comment lines (# ...) are ignored.",
"<p>",
"Usually 256 rows are provided, but the number may actually be anything in",
"the range 1 to 256.  Ximtool will interpolate the table as necessary to",
"compute the colortable values used in Ximtool.  Ximtool uses at most 201",
"colors to render pixel data, so it is usually necessary to interpolate the",
"table when it is loaded.",
"<p>",
"The name of the colortable as it will appear in the Ximtool control panel",
"is the root name of the file, e.g., if the file is \"rainbow.lut\" the ",
"colortable name will be \"rainbow\".  Lower case names are suggested to avoid",
"name collisions with the builtin colortables.  Private colormaps for disk",
"images will be have the same name as the image loaded.  If the same colortable",
"file appears in multiple user colortable directories, the first one will be",
"used.",
"<p>",
"The directory \"luts\" in the ximtool source directory contains a sample set",
"of colortable files.  This can be installed as /usr/local/lib/imtoolcmap",
"when ximtool is installed.",
"",
"<hr>",
"<h2><a name=#load>Load Panel</a></h2>",
"The Load Panel allows you load images from disk directly to the frame",
"buffer, this is analogous to loading an image on the command line except",
"that browsing is possible. At present recognized formats include IRAF OIF",
"format (i.e. <i>.imh</i> extension), simple FITS files, GIF, and Sun",
"rasterfiles.  The task will automatically sense the format of the image",
"and load it appropriately. Images with private colormaps (such as GIF)",
"will be loaded using the private colormap (meaning that changing the",
"brightness/contrast enhancements will render an apparently random-colored",
"image), all others will be loaded with a grayscale colormap.  ",
"<p>",
"When loading new images the frame buffer configuration table will be",
"searched for a frame buffer that is the same size or larger than the new",
"image size, if no frame buffer can be found a custom buffer exactly the",
"size of the image will be created. This means that the image may not fill",
"the display window when loaded, or you may see a subsection of the image",
"in the main display window.  Setting the",
"<a href=#cautoscale><b>autoscale</b></a> option on the main",
"Display panel will scale the entire image to fit the main display window,",
"the full frame buffer will always be visible in the Panner marker window.",
"<p>",
"Images with more colors than can be displayed will automatically be",
"quantized to the number of available colors before display.  If the",
"<b>Auto Grayscale</b> button is enabled any image colormap will be",
"converted to grayscale and loaded as the standard grayscale colormap.",
"<p>",
"Formats which permit pixels larger than 8-bits/pixel will be sampled on",
"a grid to determine an optimal range in the data to be used to compute a",
"linear transformation to the number of display colors. This is the same",
"z-scale sampling and transformation used by the IRAF <b>DISPLAY</b> task",
"when computing the <b>z1/z2</b> values and provides a much better initial",
"display than simple truncation to 8-bits.  This scaling will be done",
"automatically using a grid of <b>Nsample</b> points if the <b>Zscale</b>",
"option is enabled.  Otherwise, if the <b>Zrange</b> option is set the full",
"data range will be used to scale the image.  Lastly, is neither <b>Zscale</b>",
"nor <b>Zrange</b> are enabled, the z1/z2 values may be set explicitly using",
"the options box.",
"",
"<h3><a name=#lbrowse>Directory Browsing</a></h3>",
"The load panel contains a list of files in the current directory that may",
"be selected for loading by selecting with left mouse button. If the file",
"is a directory the contents of the new directory will be loaded, if it's a",
"plain file an attempt will be made to load it as an image otherwise an",
"error popup will appear.  Directories in the list are identified with a",
"trailing '/' character, you will always see any subdirectories listed even",
"if a filter is specified.",
"<p>",
"The <b>Root</b> button will reset the current directory to the system root",
"directory. The <b>Home</b> button will reset the current directory to the",
"user's login directory, the <b>Up</b> button moves up one directory level, and",
"<b>Rescan</b> reloads the file list by rescanning the directory. The current",
"working directory is given below the file selection window.",
"<p>",
"Selecting the <b>List Image Headers</b> option will change the display text",
"to list all images in the current directory which match the filename filter.",
"Directory browsing is disabled while this option is in effect.",
"",
"<h3><a name=#lpattern>File Patterns</a></h3>",
"By default all files and directories will be listed. You may specify a",
"filter to select only those files with a given extension such as",
"\"*.fits\" using the <b>Filter</b> text box.  Directories will",
"always be seen in the list and are identified with a trailing '/'",
"character. Any valid unix pattern matching string will be recognized, ",
"multiple templates may be specified in a comma-delimited list such as",
"\"*.imh,*.fits\" to list both OIF and FITS images.",
"",
"<h3><a name=#lload>Direct File Load</a></h3>",
"If you know exactly which file you wish to load, you may enter its",
"name in the <b>Load File</b> text box and either hit &lt;cr&gt or the",
"<b>Load</b> button to load it.  An absolute or relative path name may",
"be given, if a simple filename is specified it will be searched for in",
"the current working directory which is displayed in the <b>Directory</b>",
"label of the panel.",
"",
"<h3><a name=#lframe>Frame Selections</a></h3>",
"By default images will be loaded into the current frame, you may choose",
"a different frame using the Frame menu button to select from the",
"available frames.",
"",
"",
"<hr>",
"<h2><a name=#save>Save Panel</a></h2>",
"The Save Panel lets you save the current contents of the main display window ",
"to a disk file (including the Panner/Coords markers, any general graphics",
"markers, or overlay graphics displayed by the client program).  Presently,",
"only the contents of the main display window may be saved, there is no",
"facility for saving the undisplayed contents of the entire frame buffer ",
"other than to enable the <a href=#cautoscale>autoscale</a> feature.  A limited",
"number of formats are currently available, others will be added in future",
"versions.",
"",
"<dl>",
"<dt><b><a name=#sfname>File Name</a></b></dt>",
"    <dd>The <b>File Name</b> text box allows you to enter the file name of",
"	the saved file. A \"%d\" anywhere in the name will be replaced by a",
"	sequence number allowing multiple frames to be saved with unique",
"	names. </dd>",
"<dt><b><a name=#sformat>Format</a></b></dt>",
"    <dd>The <b>Format</b> box allows you to choose the format of the image",
"	to be created.  Not all formats are currently implemented. The EPS",
"	format is similar to the \\fIPrint\\fR option however there is no",
"	annotation. </dd>",
"<dt><b><a name=#scolor>Color</a></b></dt>",
"    <dd>The <b>Color</b> box lets you choose the color type of the image",
"	to be created. The options will change depending on the format,",
"	e.g. FITS doesn't allow color so no color options will be allowed.",
"	Formats which allow 24-bit images will be written using the current",
"	colormap after converting to a 24-bit image, pseudocolor images will",
"	be written with the current colormap. </dd>",
"</dl>",
"<hr>",
"",
"<h2><a name=#print>Print Panel</a></h2>",
"The Print Panel allows you dump the contents of the main display window as",
"Enacpsulated Postscript to either a named printer device or to a disk file.",
"The <b>Print To</b> selects the type of output, the <b>Print Command</b>",
"box will adjust accordingly, either as a Unix printer command or as a file",
"name.  A \"%d\" anywhere in the name for disk output will be replaced by a ",
"sequence number allowing multiple frames to be saved with unique names.",
"<a href=#pprinter>Selecting printers</a> from the installed list will",
"automatically change the command to be used to generate the output.  This",
"command does not necessarily need to be a printer command, the ",
"<a href=#pprinter>printer configuration file</a> lets you define any command",
"string to process the image.",
"",
"<h3><a name=#pcolors>Color Options</a></h3>",
"The <b>Color</b> box lets you choose the color type of the image to be created.",
"PseudoColor or 24-bit postscript will be created using the current colormap.",
"",
"<h3><a name=#popts>Postscript Options</a></h3>",
"<dl>",
"<dt>Orientation</dt>",
"    <dd> Set the page orientation.</dd>",
"<dt>Paper Size</dt>",
"    <dd> Select the paper size to be used.</dd>",
"<dt>Image Scale</dt>",
"    <dd> Set the scale factor used to compute the final image size.</dd>",
"</dl>",
"",
"<h3><a name=#pproc>Processing Options</a></h3>",
"<dl>",
"<dt>Auto Scale</dt>",
"    <dd>The auto scale toggles whether or not the image is automatically",
"	scaled to fit the page. If not enabled, the <b>image scale</b> will",
"	be used to dtermine the output image size.</dd>",
"<dt>Auto Rotate</dt>",
"    <dd>Auto rotate determines whether or not the image will be rotated to",
"	fit on the page.  When set, an image larger than the current",
"	orientation will be rotated and possibly scaled to fit the page.</dd>",
"<dt>Max Aspect</dt>",
"    <dd>Max Aspect takes images smaller than the page and automatically",
"	increases the scale so the image fills the page in the current",
"	orientation.</dd>",
"<dt>Annotate</dt>",
"    <dd>The annotate option toggles whether or not the final file includes",
"	annotation such as the image title, a colorbar, and axis labels.</dd>",
"</dl>",
"<h3><a name=#pprinter>Printer selection</a></h3>",
"The printer selection list lets choose the printer to be used.  The printer",
"configuration file is /usr/local/lib/ximprint.cfg  by default or may be reset",
"using the <em>printConfig</em> resource.  The format of the file is simply",
"<pre>",
"	<b>name</b> &lt tab &gt <em>command</em>",
"</pre>",
"The <b>name</b> value is what appears in the selection list and may be more",
"than a single word, the <em>command</em> can be any command that accepts EPS",
"input from a pipe, the two fields must be separated by a tab character. ",
"Normally the command will be",
"a simple 'lpr -Pfoo' or some such, but can also include converters or",
"previewers.  At most 128 printer commands may be used.",
"",
"<hr>",
"<h2><a name=#info>Info Panel</a></h2>",
"The Info panel was revised to provide a greater variety of status",
"information.  The type of output is controlled by the toggle buttons on",
"the bottom of the frame, however all output is kept current as the program",
"runs.  Current info options include:",
"",
"<dl>",
"<dt><b>Frame</b></dt>",
"    <dd>Info about the current display frame.</dd>",
"<dt><b>Server</b></dt>",
"    <dd>Info about various server options, e.g. colormaps, memory model,",
"        antialias type, etc.</dd>",
"<dt><b>Clients</b></dt>",
"    <dd>Show currently connected clients.  Lists available connection",
"	channels and active ISM clients.</dd>",
"<dt><b>WCS</b></dt>",
"    <dd>List all WCS and mappings for the current frame.</dd>",
"<dt><b>ISM</b></dt>",
"    <dd>Log of various ISM status messages.</dd>",
"<dt><b>Imtoolrc</b></dt>",
"    <dd>Show current frame buffer configuration table.</dd>",
"</dl>",
"",
"",
"<hr>",
"<h2><a name=#tileP>Tile Panel (NEW)</a></h2>",
"With the additional frames, the default tiling scheme proved inadequate.",
"A new control panel Tile frame now allows you to select from a number of",
"tile configurations, the list of frames to be tiled, a <b>fill style</b>",
"(left-to-right or top-to-bottom), as well as optional labels for each of",
"the tiles (frame number, image title or image name).",
"<p>",
"Tile configuration will make use of all frames currently selected in the",
"<b>Tile Frame</b> group in the following manner:",
"",
"<dl>",
"<dt><b>Disabled</b></dt>",
"    <dd>Do not tile the display.</dd>",
"<dt><b>Manual</b></dt>",
"    <dd>Tile according to <b>Manual Configuration</b> settings.</dd>",
"<dt><b>Best</b></dt>",
"    <dd>Optimize layout for frame buffer aspect.</dd>",
"<dt><b>Square</b></dt>",
"    <dd>Always force a square layout (2x2, 3x3, etc).</dd>",
"<dt><b>Horizontal</b></dt>",
"    <dd>Preferentially tile horizontally (6 frames ==> 3x2).</dd>",
"<dt><b>Vertical</b></dt>",
"    <dd>Preferentially tile vertically (6 frames ==> 2x3).</dd>",
"<dt><b>One Row</b></dt>",
"    <dd>Tile all in one row (Nx1).</dd>",
"<dt><b>One Column</b></dt>",
"    <dd>Tile all in one column (1xN).</dd>",
"</dl>",
"",
"",
"<hr>",
"<h2><a name=#coordsp>Coords Panel (NEW)</a></h2>",
"The Coords Panel is meant to provide a full-featured readout as well as",
"serve as a control panel for the various options.  The display window",
"contains the image name/title and frame buffer info, and a selection of",
"coordinate and image pixel readouts.  The intent is provide more infor-",
"mation than can fit comfortably on the main image window while still",
"taking up as little screen space as possible.  To this end the <b>Options</b>",
"button is used to hide most of the feature controls when not in use",
"(see below).  Other options on the main panel include:",
"",
"<dl>",
"<dt><b>WCS/Pix</b></dt>",
"    <dd>Toggle the real-time WCS/pixel readout capability (i.e. the ISM",
"	used to access the disk image).  This must be enabled for certain",
"	other options to work.</dd>",
"",
"<dt><b>Pix Table</b></dt>",
"    <dd>Open a panel showing an image pixel table. The panel shows an array",
"	of pixels surrounding the cursor position, either the actual pixel",
"	values if the ISM is enabled, or scaled display values otherwise.",
"	The size of the table may be selected from the menubar.</dd>",
"",
"<dt><b>Header</b></dt>",
"    <dd>Display the current image header in a new panel.  Both the entire",
"	image header as well as WCS-specific parts of the header are",
"	available under different tabs.  This option is only active when",
"	the ISM is enabled.</dd>",
"",
"<dt><b>Compass</b></dt>",
"    <dd>Draw an orientation compass on the display panner.  If the ISM is",
"	enabled and a WCS is present in the header, the compass will",
"	indicate N/E according to the WCS, otherwise the X/Y axes of the",
"	image are drawn.</dd>",
"",
"<dt><b>Options</b></dt>",
"    <dd>Pop-up/down the option control portion of the panel. When enabled,",
"	the Coords Panel will change size to reveal the options which can be",
"	changed (explained below). </dd>",
"</dl>",
"",
"The <b>Readout Values</b> group controls the selection of WCS type,",
"location and format to be displayed.  The <b>Type</b> menu always",
"provides a selection of the image Logical, Physical or World systems,",
"which may be identical depending on the image header.  If a World system",
"is supplied in the image addition entries for transformations to other sky",
"systems, (e.g.  FK5 to ICRS or galactic/ecliptic) will also be available.",
"The selection is dependent on whether the ISM is running as well as WCS",
"information present in the image.  The <b>Format</b> menu allows the",
"use to select a sexigesimal display, conversion to degrees or radians,",
"or whichever format is most natural for the coordinate being display.",
"The two toggle to the right control whether this WCS is to be displayed",
"on the <i>Panel</i> (i.e. the Coords Panel window) or the <i>ImgWin</i>",
"(i.e.  the text marker on the main image window).",
"<p>",
"Other options below this group control whether or not to display the WCS",
"labels, the image name/title, and frame buffer information in the main",
"Coords Panel display.  The <b>BPM Data</b> option controls whether or not the",
"ISM will try to map any bad-pixel mask associated with the image.  If",
"enabled, a bad-pixel mask specified by the image header BPM keyword",
"(currently fixed by convention but this may be selectable later) will be",
"mapped along with the image.  Aside from wcs/pixel readouts at each cursor",
"position, any BPM data values found will also be displayed.  A non-zero",
"value will cause the BPM field of the Coords Panel readout as well as the",
"main image window marker to switch to a red background color to flag the",
"value.",
"<p>",
"The last box allows the user to specify a different ISM task to be",
"executed or to reinitialize the current one.  In most cases this won't",
"need to be changed, however a custom ISM could be started when using",
"special data formats.  This command string can also be controlled by the",
"application <i>ism_task</i> resource.",
"",
"",
"<hr>",
"<h2><a name=#tclshell>Tcl Interactive Shell</a></h2>",
"	The <em>TclShell</em> is mostly used as a development or debugging",
"tool for the GUI.  It allows the user to type commands directly to the",
"TCL interpreter letting you send messages to the object manager or execute",
"specific procedures in the TCL code that makes up the GUI.  Most users will",
"never need this, but for an example of what it does, bring it up and type a",
"command such as",
"<pre>",
"    send helpButton set background red",
"</pre>",
"Cool, huh.",
"<hr>",
"",
"<h2><a name=#acknowledgements>Acknowledgements</a></h2>",
"	<i>XImtool</i> was developed by the IRAF Group at the National Optical",
"Astronomy Observatories in Tucson, AZ.  For further information or to report",
"problems please contact <i>iraf@noao.edu</i>",
"<hr>",
"This document was last updated 11/6/96.",
"",
"</BODY>",
"</HTML>",
