#!/bin/sh

# f2c is downloaded from www.netlib.org
# ftp://netlib.bell-labs.com/netlib/

# tablesXX.tar.gz is found in 
# http://www.stsci.edu/resources/software_hardware/stsdas/download

# Requirements
#   archives:
#     f2c_src.tar.gz  ... f2c
#     libf2c.zip      ... f2c library
#     as.pcix.gen.gz  ... IRAF base
#     tables33.tar.gz ... tbtables library
#   patches:
#     iraf_stdarg.patch (for recent Linux systems)
#     iraf_v212_sgidispatch.patch (bug-fix)
#     iraf_noao_ace.patch (bug-fix)
#     iraf_noao_smw.patch (bug-fix)
#     tables33_bugfix.patch (bug-fix)

PREFIX=/opt/iraf

set_irafenv() {
  # see unix/portkit/README and unix/hlib/irafuser.csh
  iraf=${PREFIX}/iraf/
  MACH=linux
  IRAFARCH=$MACH
  export iraf MACH IRAFARCH
  #
  HOSTID=unix
  host=${iraf}unix/
  hlib=${iraf}unix/hlib/
  hbin=${iraf}unix/bin.$MACH/
  tmp=/tmp/
  export HOSTID host hlib hbin tmp
  #
  CC_IOPT="-I${PREFIX}/iraf/include"

  CC="gcc"
  F77="$hlib/f77.sh"
  F2C=$hbin/f2c.e
  RANLIB=ranlib
  export CC F77 F2C RANLIB
  #
  HSI_CF="$CC_IOPT -O -DLINUX -DPOSIX -DSYSV -w -Wunused"
  HSI_XF="-Inolibc -w -/Wunused"
  HSI_FF="$CC_IOPT -O"
  HSI_LF=""
  HSI_F77LIBS=""
  HSI_LFLAGS=""
  HSI_OSLIBS=""
  mkzflags="'lflags=-Nxz -/Wl,-Bstatic'"
  #
  HSI_CF="$HSI_CF -DNOVOS"
  HSI_LIBS="${iraf}unix/bin/libboot.a ${iraf}unix/bin/libos.a"
  export HSI_CF HSI_XF HSI_FF HSI_LF HSI_F77LIBS HSI_LFLAGS HSI_OSLIBS mkzflags HSI_LIBS

  XC_CFLAGS=$CC_IOPT
  XC_FFLAGS=$CC_IOPT
  export XC_CFLAGS XC_FFLAGS

  # see tables/lib/zzsetenv.def
  tables=${PREFIX}/iraf/tables/
  tablesbin=${tables}/bin.generic/
  tableslib=${tables}/lib/
  export tables tablesbin tableslib

  # see noao/lib/zzsetenv.def
  noao=${PREFIX}/iraf/noao/
  noaobin=${noao}/bin.generic/
  noaolib=${noao}/lib/
  export noao noaobin noaolib

  pkglibs=${noao}/bin.generic/,${noao}/lib/,${tables}/bin.generic/,${tables}/lib/
  export pkglibs

  PATH=${PREFIX}/iraf/local/bin:$PATH
}

if [ ! `pwd` = $PREFIX ]; then
  echo "work on $PREFIX directory."
  exit
fi

if [ "$1" = "" ] ; then

  rm -rf iraf
  mkdir iraf
  rm -rf irafbin
  mkdir irafbin

  mkdir -p iraf/include
  mkdir -p iraf/tables

  cd iraf

  tar zxf ../as.pcix.gen.gz
  patch -p0 < ../iraf_v212_sgidispatch.patch
  patch -p0 < ../iraf_stdarg.patch
  patch -p0 < ../iraf_noao_ace.patch
  patch -p0 < ../iraf_noao_smw.patch
  patch -p0 <<EOF
*** unix/boot/spp/xc.c~	2004-02-02 12:25:46.000000000 +0900
--- unix/boot/spp/xc.c	2005-06-14 17:59:32.000000000 +0900
***************
*** 60,66 ****
  #define	RPP		"rpp.e"
  #define	EDSYM		"edsym.e"
  #define	SHIMAGE		"S.e"
! #define LIBMAIN		"libmain.o"
  #define SHARELIB	"libshare.a"
  #define IRAFLIB1	"libex.a"
  #define IRAFLIB2	"libsys.a"
--- 60,66 ----
  #define	RPP		"rpp.e"
  #define	EDSYM		"edsym.e"
  #define	SHIMAGE		"S.e"
! #define LIBMAIN		"${PREFIX}/iraf/bin/libmain.o"
  #define SHARELIB	"libshare.a"
  #define IRAFLIB1	"libex.a"
  #define IRAFLIB2	"libsys.a"
EOF

  cd tables
  tar zxf ../../tables33.tar.gz
  patch -p0 < ../../tables33_bugfix.patch
  cd ..

  rm -rf f2c_work
  mkdir f2c_work
  cd f2c_work
  tar zxvf ../../f2c_src.tar.gz
  cd src
  make -f makefile.u f2c
  cd ..
  unzip ../../libf2c.zip
  cd libf2c
  make -f makefile.u all
  cd ..
  cd ..

  set_irafenv

  rm -rf _work_
  mkdir -p _work_/libc
  for i in `ls unix/hlib/libc|grep '\.h$'` ; do
    cat unix/hlib/libc/$i | sed -e 's|"/iraf/iraf|"'$PREFIX'/iraf|' > _work_/libc/$i
    chmod 644 unix/hlib/libc/$i
    cat _work_/libc/$i > unix/hlib/libc/$i
  done

  cd unix
  sh -x ./setarch.sh
  rm -f bin/f2c.e*
  rm -f bin/f2c.1*
  cp -p ../f2c_work/src/f2c bin/f2c.e
  cp -p ../f2c_work/src/f2c.1 bin/.
  gzip bin/f2c.1
  cp -p ../f2c_work/libf2c/f2c.h bin/.
  cp -p ../f2c_work/libf2c/libf2c.a bin/.
  cd ..

  cd include
  ln -s ../unix/hlib/libc/iraf.h .
  ln -s ../unix/bin/f2c.h .
  cd ..

  cd unix
  sh -x ./mkpkg.sh
  cd ..

  cd local/bin
  for i in ../../unix/bin/*.e ; do
    ln -s $i `echo $i|sed -e 's|.*/||' -e 's|\.e||'`
  done
  cd ../..

  rm -f bin
  ln -s bin.generic bin
  mkpkg

  ARCLST0=`find pkg|grep -e '\.o$' -e '\.a$'`
  ARCLST1=`find sys|grep -e '\.o$' -e '\.a$'`
  tar zcvf bin/OBJS.tar.gz $ARCLST0 $ARCLST1
  cd bin
  ln -s OBJS.tar.gz OBJS.arc.Z 
  touch IB.LNUX.X86
  cd ..

  cd ..

  cd irafbin
  mv ../iraf/bin.generic bin.linux
  mkdir -p ../iraf/bin.generic
  rm -f ../iraf/bin
  ln -s bin.linux ../iraf/bin
  cd ..

  echo ""
  echo "Next: exec \"sh PlamoBuild.sh tables\"."

elif [ "$1" = "tables" ] ; then
  cd iraf
  set_irafenv
  cd tables
  mkpkg
  cd ..
  cd ..

  echo ""
  echo "Next: exec \"sh PlamoBuild.sh noao\"."

elif [ "$1" = "noao" ] ; then
  cd iraf
  set_irafenv
  cd noao

  rm -f bin
  ln -s bin.generic bin
  mkpkg

  ARCLST0=`find .|grep -v '\./bin'|grep -v '\./lib'|grep -e '\.o$' -e '\.a$'|sed -e 's|^\./||'`
  tar zcvf bin/OBJS.tar.gz $ARCLST0
  cd bin
  ln -s OBJS.tar.gz OBJS.arc.Z 
  touch NB.LNUX.X86
  cd ..

  cd ..

  rm -rf ../irafbin/noao.bin.linux
  mv noao/bin.generic ../irafbin/noao.bin.linux
  mkdir noao/bin.generic
  rm noao/bin
  ln -s bin.linux noao/bin

  cd ..

  echo ""
  echo "Next: exec \"sh PlamoBuild.sh pkg\"."

elif [ "$1" = "pkg" ] ; then
    SWNAME=iraf
    SWVERSION=2.12
    SWARCH=i386
    SWPVER=P1

    DOCDIR=/usr/share/doc
    
    PKGDIR=`pwd`/pkg
    BGNDIR=`pwd`
    rm -rf $PKGDIR
    mkdir -p $PKGDIR

    mkdir -p ${PKGDIR}/${DOCDIR}/${SWNAME}-${SWVERSION}

    cp -p PlamoBuild.sh iraf_v212_sgidispatch.patch iraf_stdarg.patch iraf_noao_ace.patch iraf_noao_smw.patch tables33_bugfix.patch ${PKGDIR}/${DOCDIR}/${SWNAME}-${SWVERSION}/.

    cd $PKGDIR
    tar cf - ${PREFIX}/iraf ${PREFIX}/irafbin | tar xf -
    rm -rf ./${PREFIX}/iraf/_work_ ./${PREFIX}/iraf/f2c_work

    cat ./$PREFIX/iraf/unix/hlib/irafuser.csh ./$PREFIX/iraf/unix/hlib/install > ./$PREFIX/iraf/unix/hlib/install_all.csh

    cat <<EOF > ./$PREFIX/iraf/unix/hlib/install_plamo
#!/bin/sh
LANG=C
export LANG
iraf=${PREFIX}/iraf
export iraf
cd \${iraf}/unix/hlib
/bin/tcsh ./install_all.csh \$@
EOF
    chmod 755 ./$PREFIX/iraf/unix/hlib/install_plamo

    chown -R root:root *

    /sbin/makepkg ${SWNAME}-${SWVERSION}-${SWARCH}-${SWPVER}.tgz <<EOF
y
EOF

    cat >> install/doinst.sh <<EOF
id iraf 1> /dev/null 2> /dev/null
if [ \$? != 0 ] ; then
  usr/sbin/useradd -d $PREFIX/iraf/local -s /bin/csh iraf
fi
chown -R iraf $PREFIX
( cd usr/include ; rm -rf iraf.h )
( cd usr/include ; ln -sf $PREFIX/iraf/unix/hlib/libc/iraf.h iraf.h )
echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
echo iraf Υ󥹥ȡ륹ץȤμ¹Ԥϡ
echo $PREFIX/iraf/unix/hlib/install_plamo -n
echo ǥƥȤ塤
echo $PREFIX/iraf/unix/hlib/install_plamo
echo ֥󥹥ȡ뤷ޤ
echo install_plamoǤΥ󥹥ȡ뤬С̥桼 cl,
echo mkiraf Ǥޤ
echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
EOF

    tar zcf ${SWNAME}-${SWVERSION}-${SWARCH}-${SWPVER}.tgz usr opt install

fi

