#!/usr/bin/perl

#
# This program shows how to fetch some
# values out of ntop using the Perl
# interface. Those data are stored in a
# RRD database that can be found at
#
# http://ee-staff.ethz.ch/~oetiker/webtools/rrdtool/
#

#makes things work when run without install
use lib qw( ../perl-shared/blib/lib ../perl-shared/blib/arch );

#makes programm work AFTER install
use lib qw( /usr/local/rrdtool-1.0.28/lib/perl ../lib/perl );

use RRDs;
use LWP::Simple; # Part of libwww (see http://www.cpan.org)

#############

$ntopHost  = "localhost"; # Host where ntop is running
$ntopPort  = 3000;        # Port where ntop is listening for HTTP connections
$if        = "iprb0";     # Interface to monitor
$url       = "http://".$ntopHost.":".$ntopPort."/dumpTrafficData.html?language=perl&key=$if";
$sleepTime = 150;
#############

$start     = time;
$name      = "nwUsage";
$rrd       = $name.".rrd";

#############

if(!(-e $rrd)) {
  RRDs::create ($rrd, "--start",$start-1, "--step",150,
		"DS:unicastPkts:COUNTER:600:0:U",
		"DS:broadcastPkts:COUNTER:600:0:U",
		"DS:multicastPkts:COUNTER:600:0:U",
		"DS:ipBytes:COUNTER:600:0:U",
		"DS:nonIpBytes:COUNTER:600:0:U",
		"DS:tcpBytes:COUNTER:600:0:U",
		"DS:udpBytes:COUNTER:600:0:U",
		"DS:icmpBytes:COUNTER:600:0:U",

		"DS:synPkts:COUNTER:600:0:U",
		"DS:rstPkts:COUNTER:600:0:U",
		"DS:rstAckPkts:COUNTER:600:0:U",
		"DS:invalidFlagPkts:COUNTER:600:0:U",
		"DS:numEstConn:COUNTER:600:0:U",

		"RRA:AVERAGE:0.5:1:600",
		"RRA:AVERAGE:0.5:6:700",
		"RRA:AVERAGE:0.5:24:775",
		"RRA:MAX:0.5:1:600",
		"RRA:MAX:0.5:6:700",
		"RRA:MAX:0.5:24:775"
		);
    
    $ERROR = RRDs::error;
    die "$0: unable to create `$rrd': $ERROR\n" if $ERROR;
}

while(1) {
    $content = get($url);

    if($content ne "") {
	eval($content);

	$a = $ntopHash{$if}{ethernetPkts}-$ntopHash{$if}{broadcastPkts}-$ntopHash{$if}{multicastPkts};
	$b = $ntopHash{$if}{broadcastPkts};
	$c = $ntopHash{$if}{multicastPkts};
	$d = $ntopHash{$if}{ipBytes};
	$e = $ntopHash{$if}{ethernetBytes}-$ntopHash{$if}{ipBytes};
	$f = $ntopHash{$if}{tcpBytes};
	$g = $ntopHash{$if}{udpBytes};
	$h = $ntopHash{$if}{icmpBytes};

	$i = $ntopHash{$if}{TCPflags}{synPkts};
	$l = $ntopHash{$if}{TCPflags}{rstPkts};
	$m = $ntopHash{$if}{TCPflags}{rstAckPkts};
	$n = $ntopHash{$if}{TCPflags}{synFinPkts}+$ntopHash{$if}{TCPflags}{finPushUrgPkts}
	     +$ntopHash{$if}{TCPflags}{nullPkts};
	$o = $ntopHash{$if}{TCPflags}{numEstablishedTCPConnections};

	$value = $start.":".$a.":".$b.":".$c.":".$d.":".$e.":".$f.":".$g.":".$h.":".
	    $i.":".$l.":".$m.":".$n.":".$o;

	print $value."\n";
      RRDs::update $rrd, $value;
	if ($ERROR = RRDs::error) {
	    die "$0: unable to update `$rrd': $ERROR\n";
	}
    }


RRDs::graph "$name.png",
    "--title", "Traffic Statistics for ".$if, 
    "--start", "now-1h",
    "--end", "now",
    "--lower-limit=1",
#    "--interlace", 
    "--imgformat","PNG",
    "--height=250",
    "--width=600",
#    "--logarithmic",
    "--vertical-label","Packets    ",
    "DEF:a=$rrd:unicastPkts:AVERAGE",
    "DEF:b=$rrd:broadcastPkts:AVERAGE",
    "DEF:c=$rrd:multicastPkts:AVERAGE",
    "AREA:c#0000FF: Multicast",
    "GPRINT:c:LAST:Current \\: %8.2lf %s",
    "GPRINT:c:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:c:MIN:Min      \\: %8.2lf %s",
    "GPRINT:c:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:b#00FF00: Broadcast",
    "GPRINT:b:LAST:Current \\: %8.2lf %s",
    "GPRINT:b:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:b:MIN:Min      \\: %8.2lf %s",
    "GPRINT:b:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:a#FF0000: Unicast  ",
    "GPRINT:a:LAST:Current \\: %8.2lf %s",
    "GPRINT:a:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:a:MIN:Min      \\: %8.2lf %s",
    "GPRINT:a:MAX:Max      \\: %8.2lf %s\\n";

    if ($ERROR = RRDs::error) {
	print "ERROR: $ERROR\n";
    };

###########################################

RRDs::graph $name."-1.png",
    "--title", "Traffic Statistics for ".$if, 
    "--start", "now-1h",
    "--end", "now",
    "--lower-limit=1",
#    "--interlace", 
    "--imgformat","PNG",
    "--height=250",
    "--width=600",
#    "--logarithmic",
    "--vertical-label","Throughtput",
    "DEF:a=$rrd:tcpBytes:AVERAGE",
    "DEF:b=$rrd:udpBytes:AVERAGE",
    "DEF:c=$rrd:icmpBytes:AVERAGE",
    "AREA:a#0000FF: TCP ",
    "GPRINT:a:LAST:Current \\: %8.2lf %s",
    "GPRINT:a:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:a:MIN:Min      \\: %8.2lf %s",
    "GPRINT:a:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:b#00FF00: UDP ",
    "GPRINT:b:LAST:Current \\: %8.2lf %s",
    "GPRINT:b:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:b:MIN:Min      \\: %8.2lf %s",
    "GPRINT:b:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:c#FF0000: ICMP",
    "GPRINT:c:LAST:Current \\: %8.2lf %s",
    "GPRINT:c:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:c:MIN:Min      \\: %8.2lf %s",
    "GPRINT:c:MAX:Max      \\: %8.2lf %s\\n";

    if ($ERROR = RRDs::error) {
	print "ERROR: $ERROR\n";
    };

###########################################

RRDs::graph $name."-2.png",
    "--title", "TCP Connection Statistics for ".$if, 
    "--start", "now-1h",
    "--end", "now",
    "--lower-limit=1",
#    "--interlace", 
    "--imgformat","PNG",
    "--height=250",
    "--width=600",
#    "--logarithmic",
    "--vertical-label","Packets",
    "DEF:a=$rrd:synPkts:AVERAGE",
    "DEF:b=$rrd:rstPkts:AVERAGE",
    "DEF:c=$rrd:rstAckPkts:AVERAGE",
    "DEF:d=$rrd:invalidFlagPkts:AVERAGE",
    "DEF:e=$rrd:numEstConn:AVERAGE",
    "AREA:a#0000FF: Attemped     ",
    "GPRINT:a:LAST:Current \\: %8.0lf %S",
    "GPRINT:a:AVERAGE:Avg  \\: %8.0lf %s",
    "GPRINT:a:MIN:Min      \\: %8.0lf %s",
    "GPRINT:a:MAX:Max      \\: %8.0lf %s\\n",
    "AREA:e#00FF00: Established  ",
    "GPRINT:e:LAST:Current \\: %8.0lf %s",
    "GPRINT:e:AVERAGE:Avg  \\: %8.0lf %s",
    "GPRINT:e:MIN:Min      \\: %8.0lf %s",
    "GPRINT:e:MAX:Max      \\: %8.0lf %s\\n",
    "LINE2:b#FF00FF: Reset        ",
    "GPRINT:b:LAST:Current \\: %8.0lf %s",
    "GPRINT:b:AVERAGE:Avg  \\: %8.0lf %s",
    "GPRINT:b:MIN:Min      \\: %8.0lf %s",
    "GPRINT:b:MAX:Max      \\: %8.0lf %s\\n",
    "LINE2:c#FF0000: Rejected     ",
    "GPRINT:c:LAST:Current \\: %8.0lf %s",
    "GPRINT:c:AVERAGE:Avg  \\: %8.0lf %s",
    "GPRINT:c:MIN:Min      \\: %8.0lf %s",
    "GPRINT:c:MAX:Max      \\: %8.0lf %s\\n",
    "LINE2:d#00FFFF: Invalid Flags",
    "GPRINT:d:LAST:Current \\: %8.0lf %s",
    "GPRINT:d:AVERAGE:Avg  \\: %8.0lf %s",
    "GPRINT:d:MIN:Min      \\: %8.0lf %s",
    "GPRINT:d:MAX:Max      \\: %8.0lf %s\\n",
    ;

    if ($ERROR = RRDs::error) {
	print "ERROR: $ERROR\n";
    };


    sleep $sleepTime;
    $start  = time;
}
