#!/bin/sh

PKGDIR=`pwd`/pkg
SWNAME=sketch-0.6.15
PYTHONDIR=python2.2

rm -rf $SWNAME
tar zxvf $SWNAME.tar.gz
cd $SWNAME
patch -p0 <../sketch-0.6.12_bugfix.patch
patch -p0 <../sketch-0.6.12_plamo.patch
patch -p0 <../sketch-0.6.12_ruler_courier.patch
patch -p0 <../sketch-0.6.12_tkdefaults.patch
patch -p1 <../sketch-0.6.14_8.0jp.patch
patch -p1 <../sketch-0.6.14_printdlg_eps.patch
patch -p1 <../sketch-0.6.14_xfigloader.patch

rm -rf $PKGDIR

./setup.py configure --prefix=/usr --dest-dir=$PKGDIR --with-nls --imaging-include=/usr/include/$PYTHONDIR/Extensions
./setup.py build --prefix=/usr --dest-dir=$PKGDIR
./setup.py install --prefix=/usr --dest-dir=$PKGDIR

cd ..

rm -rf JapaneseText-1.0.2
tar zxvf JapaneseText-1.0.2.tar.gz
cd JapaneseText-1.0.2
patch -p1 < ../JapaneseText-1.0.2-DESTDIR.patch
patch < ../JapaneseText.patch
cp -p ../Makefile.pre.in lib/.
make
make install #SKETCHDIR=/usr/lib/sketch-0.6.15 DESTDIR=$PKGDIR/usr/lib/$SWNAME/Script
cd ..
mv ~/.sketch/JapaneseText.py* $PKGDIR/usr/lib/$SWNAME/Script/.
mv ~/.sketch/freetypemodule.so $PKGDIR/usr/lib/$SWNAME/Script/.
mv ~/.sketch/euc2unicode.py* $PKGDIR/usr/lib/$SWNAME/Script/.

mkdir -p $PKGDIR/usr/X11R6/bin

cat > $PKGDIR/usr/X11R6/bin/sketch <<EOF
#!/bin/sh
mkdir -p \$HOME/.sketch
if [ ! -f \$HOME/.sketch/userhooks.py ] ; then
  cat << EOF > \$HOME/.sketch/userhooks.py
EOF

SCRIPTS="`/bin/ls $PKGDIR/usr/lib/sketch-0.6.15/Script/*.py|grep -v __init__`"
for i in $SCRIPTS ; do echo import Script.`basename $i`|sed -e 's/\.py$//' ; done >> $PKGDIR/usr/X11R6/bin/sketch

rm -f $PKGDIR/usr/bin/sketch
cat >> $PKGDIR/usr/X11R6/bin/sketch <<EOF
Script.JapaneseText.kanjifonts = [
    ("Kochi-Mincho",
     "/usr/X11R6/lib/X11/fonts/TrueType/kochi-mincho.ttf"),
    ("Kochi-Gothic",
     "/usr/X11R6/lib/X11/fonts/TrueType/kochi-gothic.ttf"),
    ("GT-Mincho",
     "/usr/X11R6/lib/X11/fonts/TrueType/gt200001.ttf"),
    ("Ricoh-Mincho",
     "/usr/X11R6/lib/X11/fonts/TrueType/msmincho.ttc", 1),
    ("Ricoh-Gothic",
     "/usr/X11R6/lib/X11/fonts/TrueType/msgothic.ttc", 1),
    ("Mikachan",
     "/usr/X11R6/lib/X11/fonts/TrueType/mika.ttf"),
    ("Mikachan-p",
     "/usr/X11R6/lib/X11/fonts/TrueType/mika-p.ttf"),
    ]
Script.JapaneseText.asciifonts = [
    ("Kochi-Mincho",
     "/usr/X11R6/lib/X11/fonts/TrueType/kochi-mincho.ttf"),
    ("Kochi-Gothic",
     "/usr/X11R6/lib/X11/fonts/TrueType/kochi-gothic.ttf"),
    ("GT-Mincho",
     "/usr/X11R6/lib/X11/fonts/TrueType/gt200001.ttf"),
    ("Ricoh-Mincho",
     "/usr/X11R6/lib/X11/fonts/TrueType/msmincho.ttc", 0),
    ("Ricoh-Gothic",
     "/usr/X11R6/lib/X11/fonts/TrueType/msgothic.ttc", 0),
    ("Mikachan",
     "/usr/X11R6/lib/X11/fonts/TrueType/mika.ttf"),
    ("Mikachan-p",
     "/usr/X11R6/lib/X11/fonts/TrueType/mika-p.ttf"),
    ("Times-Medium-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/times.ttf"),
    ("Times-Medium-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/timesi.ttf"),
    ("Times-Bold-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/timesbd.ttf"),
    ("Times-Bold-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/timesbi.ttf"),
    ("Arial-Medium-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/arial.ttf"),
    ("Arial-Medium-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/ariali.ttf"),
    ("Arial-Bold-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/arialbd.ttf"),
    ("Arial-Bold-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/arialbi.ttf"),
    ("Trebuchet-Medium-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/trebuc.ttf"),
    ("Trebuchet-Medium-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/trebucit.ttf"),
    ("Trebuchet-Bold-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/trebucbd.ttf"),
    ("Trebuchet-Bold-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/trebucbi.ttf"),
    ("Verdana-Medium-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/verdana.ttf"),
    ("Verdana-Medium-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/verdanai.ttf"),
    ("Verdana-Bold-R",
     "/usr/X11R6/lib/X11/fonts/TrueType/verdanab.ttf"),
    ("Verdana-Bold-I",
     "/usr/X11R6/lib/X11/fonts/TrueType/verdanaz.ttf"),
    ]
EOF
echo EOF >> $PKGDIR/usr/X11R6/bin/sketch
echo fi >> $PKGDIR/usr/X11R6/bin/sketch
echo exec /usr/lib/$SWNAME/sketch.py \$@ >> $PKGDIR/usr/X11R6/bin/sketch
chmod 755 $PKGDIR/usr/X11R6/bin/sketch

mkdir -p $PKGDIR/usr/doc/$SWNAME/JapaneseText-1.0.2
cp -p JapaneseText-1.0.2/README.* $PKGDIR/usr/doc/$SWNAME/JapaneseText-1.0.2/.
cp -p Makefile.pre.in $PKGDIR/usr/doc/$SWNAME/JapaneseText-1.0.2/.

cd $SWNAME
cp -p BUGS C* FAQ INSTALL NEWS PROJECTS README TODO $PKGDIR/usr/doc/$SWNAME
cp -dpuR Doc Examples $PKGDIR/usr/doc/$SWNAME
cd ..
cp -p plamobuild.sh *.patch $PKGDIR/usr/doc/$SWNAME/.
mv $PKGDIR/usr/doc/$SWNAME/JapaneseText.patch $PKGDIR/usr/doc/$SWNAME/JapaneseText-1.0.2-DESTDIR.patch $PKGDIR/usr/doc/$SWNAME/JapaneseText-1.0.2/.
gzip $PKGDIR/usr/doc/$SWNAME/*.patch
gzip $PKGDIR/usr/doc/$SWNAME/JapaneseText-1.0.2/*.patch
