#!/bin/sh

SWNAME=Python-2.2.2
PKGDIR=`pwd`/pkg
TCLTKVERSION=8.0jp

rm -rf $SWNAME
tar zxf $SWNAME.tgz
cd $SWNAME
patch <<EOF
--- setup.py._orig_	2002-10-10 09:59:16.000000000 +0900
+++ setup.py	2003-04-24 09:21:57.000000000 +0900
@@ -679,7 +679,7 @@
         # The versions with dots are used on Unix, and the versions without
         # dots on Windows, for detection by cygwin.
         tcllib = tklib = tcl_includes = tk_includes = None
-        for version in ['8.4', '84', '8.3', '83', '8.2',
+        for version in ['$TCLTKVERSION', '80', '8.4', '84', '8.3', '83', '8.2',
                         '82', '8.1', '81', '8.0', '80']:
             tklib = self.compiler.find_library_file(lib_dirs,
                                                     'tk' + version )
EOF
./configure --prefix=/usr
cd Modules
#cp Setup.in Setup
cat <<EOF > /dev/null
--- Setup._orig_	2003-04-24 08:49:04.000000000 +0900
+++ Setup	2003-04-24 08:54:11.000000000 +0900
@@ -130,7 +130,7 @@
 # modules are to be built as shared libraries (see above for more
 # detail; also note that *static* reverses this effect):
 
-#*shared*
+*shared*
 
 # GNU readline.  Unlike previous Python incarnations, GNU readline is
 # now incorporated in an optional module, configured in the Setup file
@@ -140,7 +140,7 @@
 # it, depending on your system -- see the GNU readline instructions.
 # It's okay for this to be a shared library, too.
 
-#readline readline.c -lreadline -ltermcap
+readline readline.c -lreadline -lncurses
 
 
 # Modules that should always be present (non UNIX dependent):
@@ -302,13 +302,13 @@
 # every system.
 
 # *** Always uncomment this (leave the leading underscore in!):
-# _tkinter _tkinter.c tkappinit.c -DWITH_APPINIT \\
+ _tkinter _tkinter.c tkappinit.c -DWITH_APPINIT \\
 # *** Uncomment and edit to reflect where your Tcl/Tk libraries are:
 #	-L/usr/local/lib \\
 # *** Uncomment and edit to reflect where your Tcl/Tk headers are:
 #	-I/usr/local/include \\
 # *** Uncomment and edit to reflect where your X11 header files are:
-#	-I/usr/X11R6/include \\
+	-I/usr/X11R6/include \\
 # *** Or uncomment this for Solaris:
 #	-I/usr/openwin/include \\
 # *** Uncomment and edit for Tix extension only:
@@ -321,9 +321,9 @@
 # *** Uncomment and edit for TOGL extension only:
 #	-DWITH_TOGL togl.c \\
 # *** Uncomment and edit to reflect your Tcl/Tk versions:
-#	-ltk8.2 -ltcl8.2 \\
+	-ltk$TCLTKVERSION -ltcl$TCLTKVERSION \\
 # *** Uncomment and edit to reflect where your X11 libraries are:
-#	-L/usr/X11R6/lib \\
+	-L/usr/X11R6/lib \\
 # *** Or uncomment this for Solaris:
 #	-L/usr/openwin/lib \\
 # *** Uncomment these for TOGL extension only:
@@ -331,7 +331,7 @@
 # *** Uncomment for AIX:
 #	-lld \\
 # *** Always uncomment this; X11 libraries to link with:
-#	-lX11
+	-lX11
 
 # Lance Ellinghaus's modules:
 
@@ -435,7 +435,7 @@
 # Andrew Kuchling's zlib module.
 # This require zlib 1.1.3 (or later).
 # See http://www.cdrom.com/pub/infozip/zlib/
-#zlib zlibmodule.c -I\$(prefix)/include -L\$(exec_prefix)/lib -lz
+zlib zlibmodule.c -I\$(prefix)/include -L\$(exec_prefix)/lib -lz
 
 # Interface to the Expat XML parser
 #
EOF
cd ..
make

rm -rf $PKGDIR
mkdir -p $PKGDIR/usr

make install prefix=$PKGDIR/usr

mkdir -p $PKGDIR/usr/doc/$SWNAME
cp -p ../plamobuild.sh LICENSE README $PKGDIR/usr/doc/$SWNAME/.
cp -dpuR Doc $PKGDIR/usr/doc/$SWNAME/.
chown -R root:root $PKGDIR/usr/doc
gzip $PKGDIR/usr/man/man1/*.1
cd $PKGDIR
makepkg $SWNAME.tgz <<EOF
y
y
EOF


